#ifndef ABSTRACTARDUBOY_H
#define ABSTRACTARDUBOY_H

#include <stdint.h>
#include "glcdfont.h"

#define WIDTH 128
#define HEIGHT 64

#define WHITE 1
#define BLACK 0

#define COLUMN_ADDRESS_END (WIDTH - 1) & 0x7F
#define PAGE_ADDRESS_END ((HEIGHT/8)-1) & 0x07

#define _BV(b) (1UL << (b))
#define min(a,b) (((a)<(b))?(a):(b))
#define max(a,b) (((a)>(b))?(a):(b))
#define abs(a) (((a) < 0) ? -(a) : (a))
//#define pgm_read_byte(a) 1

#define LEFT_BUTTON _BV(0)
#define RIGHT_BUTTON _BV(1)
#define UP_BUTTON _BV(2)
#define DOWN_BUTTON _BV(3)
#define A_BUTTON _BV(4)
#define B_BUTTON _BV(5)

typedef bool boolean;
typedef uint8_t byte;

class AbstractArduboy
{
public:
    AbstractArduboy();

    // pure virtual function
    virtual void start() = 0;

    virtual long getTime() = 0;

    virtual void LCDDataMode() = 0;
    virtual void LCDCommandMode() = 0;
    virtual void drawScreen(const unsigned char *image) = 0;

    virtual uint8_t getInput() = 0;

    // virtual
    virtual void idle();
    virtual void saveMuchPower();
    
    // init
    void begin(){start();};

    // frame management
    void setFrameRate(uint8_t rate);
    bool nextFrame();
    bool everyXFrames(uint8_t frames);

    // info
    int cpuLoad();

    // buttons
    void poll();
    bool pressed(uint8_t buttons);
    bool notPressed(uint8_t buttons);
    bool justPressed(uint8_t buttons);

    // graphics
    void blank();
    void clear();
    void clearDisplay();
    void display();
    void drawPixel(int x, int y, uint8_t color);
    uint8_t getPixel(uint8_t x, uint8_t y);
    void drawCircle(int16_t x0, int16_t y0, int16_t r, uint8_t color);
    void drawCircleHelper(int16_t x0, int16_t y0, int16_t r, uint8_t cornername, uint8_t color);
    void fillCircle(int16_t x0, int16_t y0, int16_t r, uint8_t color);
    void fillCircleHelper(int16_t x0, int16_t y0, int16_t r, uint8_t cornername, int16_t delta, uint8_t color);
    void drawLine(int16_t x0, int16_t y0, int16_t x1, int16_t y1, uint8_t color);
    void drawRect(int16_t x, int16_t y, int16_t w, int16_t h, uint8_t color);
    void drawFastVLine(int16_t x, int16_t y, int16_t h, uint8_t color);
    void drawFastHLine(int16_t x, int16_t y, int16_t w, uint8_t color);
    void fillRect(int16_t x, int16_t y, int16_t w, int16_t h, uint8_t color);
    void fillScreen(uint8_t color);
    void drawRoundRect(int16_t x, int16_t y, int16_t w, int16_t h, int16_t r, uint8_t color);
    void fillRoundRect(int16_t x, int16_t y, int16_t w, int16_t h, int16_t r, uint8_t color);
    void drawBitmap(int16_t x, int16_t y, const uint8_t *bitmap, int16_t w, int16_t h, uint8_t color);
    void drawCompressed(int16_t sx, int16_t sy, const uint8_t *bitmap, uint8_t color);

    void drawChar(int16_t x, int16_t y, unsigned char c, uint16_t color, uint16_t bg, uint8_t size);
    uint8_t writeChar(uint8_t);
    inline void setCursor(int16_t x, int16_t y) { cursor_x = x; cursor_y = y; };
    void setTextSize(uint8_t s) {textsize = max(1,s); };

    static inline void swap(int16_t &a, int16_t &b);
    
    // Audio
    class ArduboyAudio
    {
      public:
        ArduboyAudio(){audio_enabled = false;};
        void setup();
        void on();
        void off();
        void saveOnOff();
        bool enabled();
        void tone(unsigned int frequency, unsigned long duration);
    
      protected:
        bool audio_enabled;
    }audio;

protected:
    uint8_t frameRate;
    uint16_t frameCount;
    uint8_t eachFrameMillis;
    long lastFrameStart;
    long nextFrameStart ;
    bool post_render;
    uint8_t lastFrameDurationMs;

    uint8_t currentButtonState;
    uint8_t previousButtonState;

    uint8_t sBuffer[(HEIGHT * WIDTH) / 8];
    
    int16_t  cursor_x, cursor_y;
    uint16_t textcolor, textbgcolor;
    uint8_t  textsize;
    uint8_t  rotation;
    bool  wrap; // If set, 'wrap' text at right edge of display
};

#endif // ABSTRACTARDUBOY_H
