#include "mbed.h"
#include "abstractarduboy.h"

Ticker timer;
SPI _spi(p30, p31, p29); // mosi, miso, sclk

DigitalOut _cs(p3);
DigitalOut _dc(p28);
DigitalOut _rst(p4);

DigitalIn   _left(BUTTON1);
DigitalIn   _right(BUTTON4);
DigitalIn   _A(BUTTON2);
DigitalIn   _B(BUTTON3);

unsigned long  _millis;

void gameTimerCallback(void)
{
    _millis++;
}

class MbedBoy : public AbstractArduboy, public Stream
{
  public:
    MbedBoy(){};

    void start()
    {
        // init systime
        timer.attach(gameTimerCallback, 0.0005);
        
        // init SPI
        _spi.format(8,3);
        _spi.frequency(1000000);
        
        // init pin
        _left.mode(PullUp);
        _right.mode(PullUp);
        _A.mode(PullUp);
        _B.mode(PullUp);
        
        // init pin LCD
        _dc = 0;
        _cs = 0;
        _rst = 1;
        wait_ms(1);
        _rst = 0;
        wait_ms(10);
        _rst = 1;
        
        bootLCD();
    }
    
    long getTime()
    {
        return _millis;
    }
    
    void drawScreen(const unsigned char *image)
    {
          for (int i = 0; i < (HEIGHT*WIDTH)/8; i++)
          {
            _spi.write(image[i]);
          } 
    }
    
    uint8_t getInput()
    {
        return !_left + ((!_right) << 2) + ((!_A) << 4) + ((!_B) << 3);
    }

    void LCDCommandMode()
    {
        _cs = 1;
        _dc = 0;
        _cs = 0;
    }

    void LCDDataMode()
    {
        _dc = 1;
        _cs = 0;
    }
    
    void bootLCD()
    {
      LCDCommandMode();
      _spi.write(0xAE);  // Display Off
      _spi.write(0XD5);  // Set Display Clock Divisor v
      _spi.write(0xF0);  //   0x80 is default
      _spi.write(0xA8);  // Set Multiplex Ratio v
      _spi.write(0x3F);
      _spi.write(0xD3);  // Set Display Offset v
      _spi.write(0x0);
      _spi.write(0x40);  // Set Start Line (0)
      _spi.write(0x8D);  // Charge Pump Setting v
      _spi.write(0x14);  //   Enable
      // why are we running this next pair twice?
      _spi.write(0x20);  // Set Memory Mode v
      _spi.write(0x00);  //   Horizontal Addressing
      _spi.write(0xA1);  // Set Segment Re-map (A0) | (b0001)
      _spi.write(0xC8);  // Set COM Output Scan Direction
      _spi.write(0xDA);  // Set COM Pins v
      _spi.write(0x12);
      _spi.write(0x81);  // Set Contrast v
      _spi.write(0xCF);
      _spi.write(0xD9);  // Set Precharge
      _spi.write(0xF1);
      _spi.write(0xDB);  // Set VCom Detect
      _spi.write(0x40);
      _spi.write(0xA4);  // Entire Display ON
      _spi.write(0xA6);  // Set normal/inverse display
      _spi.write(0xAF);  // Display On
    
      LCDCommandMode();
      _spi.write(0x20);     // set display mode
      _spi.write(0x00);     // horizontal addressing mode
    
      _spi.write(0x21);     // set col address
      _spi.write(0x00);
      _spi.write(COLUMN_ADDRESS_END);
    
      _spi.write(0x22); // set page address
      _spi.write(0x00);
      _spi.write(PAGE_ADDRESS_END);
    
      LCDDataMode();
    }

    // Stream implementation - provides printf() interface
    // You would otherwise be forced to use writeChar()
    virtual int _putc(int value) { return writeChar(value); };
    virtual int _getc() { return -1; };
};