/*
Hello, World! example
June 11, 2015
Copyright (C) 2015 David Martinez
All rights reserved.
This code is the most basic barebones code for writing a program for Arduboy.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
*/

#include "mbedboy.hpp"

// make an instance of arduboy used for many functions

DigitalOut led2(LED2);

MbedBoy arduboy;

// This function runs once in your game.
// use it for anything that needs to be set only once in your game.
void setup() {
    led2 = 1;

  // initiate arduboy instance
  arduboy.start();
  
  arduboy.blank();

  // here we set the framerate to 15, we do not need to run at
  // default 60 and it saves us battery life
 // arduboy.setFrameRate(15);
}


// our main game loop, this runs once every cycle/frame.
// this is where our game logic goes.
void loop() {
  // pause render until it's time for the next frame
  if (!(arduboy.nextFrame()))
    return;

    led2 = 0;
  // first we clear our screen to black
//  arduboy.clear();
//    wait_ms(2000);
  // we set our cursor 5 pixels to the right and 10 down from the top
  // (positions start at 0, 0) 
  arduboy.setTextCursor(1, 1);
  // then we print to screen what is in the Quotation marks ""
  arduboy.printf("Hello, world!");
   // wait_ms(2000);

    arduboy.drawCircle(30,30,30,WHITE);
  // then we finaly we tell the arduboy to display what we just wrote to the display
  arduboy.display();
}
