//Circuit Dude
//  Version 1.0, November 17, 2016
//  By Jonathan Holmes (crait)
//
//  Website: http://www.crait.net/
//  Twitter: @crait
//  Make your own levels: http://www.crait.net/circuitdude/
//
//Help Circuit Dude build an awesome invention by leading him
//through 50 unique levels, completing circuits and plugging
//in microchips. After all chips are inserted into their sockets,
//the exit will activate and you can advance to the next puzzle!
//What kind of secret invention is Circuit Dude building?
//Complete all 50 levels to find out!
//
//
//1.0 - November 17, 2016
//  Initial release



//  Align and clean up menu text
//  

#include "mbedboy.hpp"
//#include <EEPROM.h>

DigitalOut led3(LED3);

MbedBoy arduboy;
#define OFF HIGH
#define ON LOW
#define SAVELOCATION (EEPROM_STORAGE_SPACE_START + 410)

void checkcompletion();
void swapall(int8_t from, int8_t to);
void rotateinplace(int8_t index);
void checklocation(int8_t locx, int8_t locy);
bool checkcollision(int8_t locx, int8_t locy) ;
void loadlevel(int givenlevel) ;
void continuestate(int8_t tostate);
void drawlevel();
void drawtitle();
void printmenuitem(int8_t menuitem, int8_t y) ;

boolean menubuttonfree = true;
int8_t menubuttoncounter = 0;
boolean gamebuttonfree = true;
int frame = 0;
int8_t animation = 0;
int8_t transitionanimation = 0;
int8_t deathcounter = 0;
int8_t gamestate = 0;
int8_t level = 0;
boolean levelcomplete = false;
int8_t levelcompletecounter = 0;
int8_t playerx = 0;
int8_t playery = 0;
int8_t playertox = 0;
int8_t playertoy = 0;
boolean canswitch = true;
int8_t temperature = 0;
int8_t maxlevel = 0;
int8_t levelchecker = 0;
boolean soundon = true;

const unsigned char lock[]  = {
  0x7e, 0x79, 0x59, 0x79, 0x7e
};

const unsigned char me[] = {
    0x45, 0x8a, 0x15, 0xaa, 0x15, 0xaa, 0xd5, 0x6a,
    0x34, 0x28, 0x21, 0x32, 0x1d, 0x0a, 0x0c, 0x06,
    0x03, 0x02, 0x07, 0x02, 0x23, 0x41, 0xa0, 0x41,
    0x80, 0x40, 0x81, 0x40, 0x20, 0x80, 0x40, 0x80,
    0x40, 0x20, 0x08, 0xc7, 0x7d, 0xa2, 0x55, 0xa2,
    0x51, 0xa8, 0x15, 0x88, 0x44, 0xa2, 0x51, 0xaa,
    0x54, 0xa8, 0x51, 0x82, 0x05, 0xff, 0x00, 0x00,
    0x41, 0x80, 0x80, 0x00, 0x80, 0xe0, 0xf0, 0xf0,
    0xf0, 0xf0, 0xe0, 0x60, 0x60, 0x60, 0x68, 0xed,
    0xe4, 0xe3, 0xe0, 0xe0, 0x61, 0x72, 0xe1, 0x02,
    0xe1, 0x32, 0x1a, 0xaf, 0x11, 0x88, 0x54, 0x8a,
    0x45, 0x2a, 0x05, 0x92, 0x45, 0xa2, 0x41, 0xa0,
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xbf, 0xe0, 0x00,
    0x00, 0x00, 0x00, 0x3c, 0xfe, 0xff, 0xff, 0xff,
    0x1d, 0xec, 0x36, 0x37, 0xf7, 0xf7, 0xee, 0x1f,
    0xff, 0x3f, 0xdf, 0x2e, 0x37, 0xf6, 0xee, 0x1c,
    0x03, 0x7e, 0x55, 0xca, 0xc5, 0xa2, 0x51, 0xa8,
    0x54, 0xaa, 0x55, 0x2a, 0x15, 0x8a, 0x45, 0x22,
    0x51, 0xa2, 0x54, 0xa0, 0x55, 0xfe, 0xc3, 0xbc,
    0x66, 0x40, 0x00, 0x38, 0xdf, 0x7f, 0xbf, 0xff,
    0xff, 0xfe, 0x7d, 0x7d, 0x7d, 0xfd, 0xfe, 0x3f,
    0x7f, 0xff, 0xf0, 0x6d, 0x1d, 0xbd, 0xfe, 0xff,
    0xe0, 0x83, 0x3f, 0xc0, 0x7f, 0xa2, 0x55, 0xa2,
    0x51, 0x28, 0x04, 0xa2, 0x51, 0xa8, 0x54, 0xaa,
    0x11, 0xa2, 0x15, 0xa2, 0xc5, 0x6a, 0x45, 0x63,
    0x41, 0x6b, 0x5e, 0x78, 0x71, 0xa6, 0x4b, 0x8d,
    0x97, 0x9c, 0x38, 0x31, 0x23, 0x06, 0x46, 0x4d,
    0x4d, 0x6d, 0x72, 0x7f, 0x6f, 0x1f, 0x37, 0x0f,
    0x1d, 0xcb, 0xe0, 0x7f, 0x55, 0x6a, 0x45, 0x40,
    0xc0, 0x8a, 0xc5, 0x6a, 0xb5, 0xda, 0xed, 0xca,
    0x3d, 0xce, 0xf3, 0xfd, 0xfe, 0xf8, 0x87, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xc0, 0xbf, 0xbe, 0xbd,
    0xdb, 0x57, 0xa7, 0xcf, 0xb7, 0x8b, 0xfa, 0xf6,
    0x76, 0xa6, 0xca, 0x76, 0xea, 0x9c, 0x5f, 0xdf,
    0xc0, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x0f,
    0xb6, 0xb9, 0xfb, 0xf8, 0xf3, 0xf7, 0xff, 0xf8
};

const unsigned char title[]  = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x07, 0x03, 0x03, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xe7, 0xff, 0xff, 0xff,
    0xff, 0x33, 0x33, 0x33, 0xff, 0xff, 0xff, 0xff,
    0x3f, 0x3f, 0x3f, 0x7f, 0x3f, 0x3f, 0x3f, 0x3f,
    0xff, 0xff, 0xff, 0x7f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x3f, 0x3f, 0x3f, 0xff, 0xff, 0xff, 0x3f, 0x3f,
    0x3f, 0xff, 0xff, 0xff, 0x33, 0x33, 0x33, 0xff,
    0xff, 0xff, 0xff, 0x3f, 0x3f, 0x07, 0x07, 0x07,
    0x3f, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x7f, 0x7f,
    0x7f, 0x3e, 0xbe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0x00, 0x7f, 0x7f, 0x7f, 0x00, 0x00,
    0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
    0x7f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
    0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,
    0x0f, 0x0f, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x0f, 0x8f, 0x9f, 0x9f, 0x3f, 0x3e, 0x7e, 0xfe,
    0xfe, 0xfe, 0xfe, 0xfe, 0x3f, 0x9f, 0xdf, 0xdf,
    0xdf, 0x9e, 0x5e, 0xde, 0x9f, 0x5f, 0xbf, 0x7f,
    0xfe, 0xfe, 0xfe, 0xff, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0x3f, 0x7e, 0xfe, 0xfe, 0xfe,
    0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
    0xfe, 0xff, 0xff, 0x7f, 0x7e, 0x7e, 0xfe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe,
    0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x1f, 0x03, 0x01, 0xe1, 0xf8, 0xfc,
    0xfc, 0x1e, 0x0e, 0x06, 0x82, 0xc2, 0xe3, 0xf1,
    0xf1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf8, 0x01,
    0xff, 0xff, 0x7f, 0x3f, 0xb0, 0x8f, 0xfe, 0xf1,
    0xef, 0xef, 0xe0, 0xef, 0xef, 0xe0, 0xf7, 0x00,
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
    0xff, 0x03, 0x03, 0x03, 0xff, 0xff, 0xff, 0x03,
    0x03, 0x03, 0xff, 0xff, 0xff, 0x07, 0x03, 0x03,
    0xf3, 0xf3, 0xf3, 0x00, 0x00, 0x00, 0xff, 0xff,
    0xff, 0xff, 0x07, 0x03, 0x03, 0x33, 0x33, 0x33,
    0x03, 0x03, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
    0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
    0xff, 0xf8, 0xfa, 0xfb, 0xf9, 0xfd, 0xf9, 0xc3,
    0xa7, 0x33, 0x3b, 0x3f, 0x3f, 0x1d, 0x80, 0xfe,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0xe0, 0xe0, 0xe7,
    0xe7, 0xe7, 0xe0, 0xe0, 0xf8, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0xe0, 0xe0, 0xe7, 0xe7, 0xe7, 0xe0,
    0xe0, 0xe0, 0xff, 0xff, 0xff, 0xf0, 0xe0, 0xe0,
    0xe7, 0xe7, 0xe7, 0xe0, 0xe0, 0xe0, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xe0, 0xe0, 0xe7, 0xe7, 0xe7,
    0xe7, 0xe3, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x00, 0x00, 0x0f, 0x7f, 0x7f,
    0xff, 0xe0, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x80, 0x80, 0xc0, 0xc0, 0x80, 0x00, 0x00, 0x00,
    0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xc0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xf0, 0xf0, 0xf0,
    0xf8, 0xf8, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x80,
    0xc0, 0xc1, 0xc1, 0xc3, 0xc3, 0xc3, 0xc3, 0xc1,
    0xc0, 0xe0, 0xe0, 0xf0, 0xf8, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x03, 0xf9, 0xf9, 0xf9, 0xf9,
    0x01, 0xf9, 0xf9, 0xf9, 0xf9, 0xfa, 0xfa, 0xfe,
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x81, 0x0f,
    0x01, 0x80, 0x00, 0x00, 0x00, 0x40, 0xe0, 0xe0,
    0xf0, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xfc, 0xfc, 0xfe, 0xff,
    0xff, 0xff, 0xf9, 0xf3, 0xe7, 0xcf, 0xaf, 0x6f,
    0x6f, 0xaf, 0xef, 0xaf, 0xef, 0xaf, 0xaf, 0xb7,
    0xb7, 0xd7, 0xe7, 0x03, 0xfb, 0xfd, 0xff, 0xff,
    0xff, 0x03, 0xf3, 0x19, 0x19, 0x1c, 0x1e, 0x0f,
    0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x8f,
    0x8f, 0x0f, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87,
    0xc7, 0xc7, 0xc7, 0xc7, 0xc7, 0x87, 0x43, 0xc3,
    0x83, 0x63, 0xe3, 0xc3, 0xa3, 0x63, 0xe3, 0xe3,
    0xe3, 0xe1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1,
    0xf1, 0xe1, 0xe9, 0xd9, 0xd8, 0x38, 0x38, 0xf8,
    0xf8, 0xf8, 0xf8, 0xc0, 0xc7, 0xcf, 0xef, 0xdf,
    0xc0, 0xdf, 0xdf, 0x81, 0x89, 0x83, 0xef, 0xef,
    0x81, 0x89, 0x83, 0xf7, 0xc0, 0xc4, 0xc1, 0xf8,
    0xff, 0xff, 0xfc, 0xf8, 0xf8, 0xf0, 0xf0, 0xf1,
    0xf1, 0xe1, 0xe0, 0xe0, 0xe0, 0x01, 0x03, 0x07,
    0x47, 0xc7, 0xe7, 0xe7, 0x07, 0x07, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0xfe, 0xfc, 0xfd, 0x79, 0x7b, 0x3b, 0xbb,
    0x9d, 0x9d, 0xde, 0xcf, 0x8f, 0x07, 0x07, 0x03,
    0x19, 0x3c, 0xff, 0xfe, 0xfe, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0xfd, 0xf3, 0xef, 0xdf, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xfb, 0xf7, 0xfe, 0xfd, 0xfb, 0xff, 0xfe, 0xfd,
    0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf9,
    0xf5, 0xce, 0xae, 0xde, 0xfe, 0xff, 0xff, 0xff,
    0xbf, 0xbf, 0xdf, 0xdf, 0xef, 0xef, 0xef, 0xf7,
    0xf7, 0xfb, 0xfb, 0x7f, 0x7f, 0xbf, 0xbf, 0xdf,
    0xdf, 0xdf, 0xef, 0xef, 0xf7, 0xf7, 0xcf, 0xbf
};

const unsigned char final1[]  = {
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xcf, 0xcf, 0xcf, 0xcf, 0x8f, 0x9e, 0x9e,
    0x9c, 0x9c, 0xfc, 0xff, 0xff, 0x0f, 0x00, 0x80,
    0x50, 0xaa, 0x55, 0xaa, 0x55, 0x00, 0x00, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0x3f, 0x3f, 0x1f, 0x9f,
    0x8f, 0xcf, 0xcf, 0xcf, 0x4f, 0x47, 0x67, 0x27,
    0x27, 0xe7, 0xa7, 0x37, 0x37, 0x37, 0x37, 0x33,
    0x73, 0xd3, 0x93, 0x93, 0x93, 0x93, 0x93, 0x93,
    0x99, 0x89, 0xc9, 0xc9, 0xc9, 0xc1, 0xc1, 0xc1,
    0xe1, 0x31, 0x18, 0x08, 0xc8, 0xc8, 0xe8, 0xf8,
    0xf1, 0xf1, 0xf3, 0xf3, 0xe7, 0xc7, 0x0f, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0x73, 0x73, 0x73,
    0x73, 0x73, 0xff, 0xff, 0xff, 0x00, 0x00, 0xaa,
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0x00, 0x00, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x03, 0x00, 0x00, 0xfc, 0xff, 0xff,
    0xff, 0x03, 0x01, 0x00, 0xf0, 0xf8, 0xfc, 0xfe,
    0xfe, 0xfe, 0x07, 0x07, 0x07, 0x07, 0xc6, 0xec,
    0xe8, 0xc8, 0x0f, 0x03, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x03, 0x02, 0x02, 0x19, 0x3c, 0x3c, 0x18, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xdb,
    0xbb, 0x7b, 0xf7, 0xcf, 0xbf, 0x3f, 0xdf, 0xef,
    0xe7, 0xf3, 0x79, 0xdc, 0xcf, 0x27, 0x7b, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0xfc, 0x9c, 0x9c, 0x8c, 0xce, 0xc6,
    0xe6, 0xe6, 0x67, 0x67, 0x7f, 0xfc, 0xe0, 0x00,
    0x05, 0x2a, 0x55, 0xaa, 0x55, 0x00, 0x00, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
    0xff, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x01,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x1f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x1f,
    0x07, 0x38, 0x7b, 0xf7, 0xdf, 0x9f, 0x7f, 0xf1,
    0xe6, 0xd6, 0x56, 0x9b, 0xac, 0x97, 0xc9, 0xe0,
    0xff, 0xff, 0xff, 0x7f, 0x7f, 0xff, 0x7f, 0x7f,
    0x7f, 0x3f, 0x3f, 0x3f, 0x3f, 0x19, 0x99, 0x98,
    0x9c, 0x9c, 0x8c, 0xce, 0xce, 0xcf, 0xcf, 0xc7,
    0xe0, 0xe0, 0xe1, 0xe0, 0xf1, 0xf0, 0xf0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x3f, 0x1f, 0x0e, 0x00, 0x00, 0x01, 0x0f, 0x0f,
    0x1f, 0xfc, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x80, 0x80, 0xc0, 0xe0,
    0xf0, 0xf0, 0x38, 0x78, 0xf0, 0xe0, 0xe0, 0xe0,
    0xf0, 0xf0, 0xf0, 0xf0, 0xf8, 0xf8, 0xf8, 0xf8,
    0xfc, 0xfc, 0xfc, 0x7c, 0x7e, 0xbe, 0xfe, 0xfe,
    0xff, 0x7f, 0x7f, 0x3f, 0x3f, 0x9f, 0xc7, 0xf0,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xfc,
    0xfc, 0xfc, 0xfe, 0xfc, 0xfd, 0xfc, 0xfe, 0x3e,
    0x1e, 0x0e, 0x07, 0x03, 0x23, 0x31, 0x30, 0x30,
    0x79, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78, 0x78,
    0x78, 0x78, 0x70, 0x70, 0x70, 0x71, 0xf1, 0xf1,
    0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1,
    0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1,
    0xf1, 0xf1, 0xf1, 0xf1, 0xe1, 0xe1, 0xe1, 0xe3,
    0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3,
    0x00, 0x00, 0x80, 0x00, 0x00, 0x08, 0x1c, 0x3c,
    0x3e, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xfc, 0xf9, 0xf5, 0xed,
    0xcd, 0xd5, 0x9d, 0xb5, 0x3d, 0x75, 0x75, 0x76,
    0xb6, 0xba, 0xdc, 0xe0, 0xff, 0xff, 0x7f, 0x7f,
    0x3f, 0x80, 0xfe, 0xff, 0xff, 0xff, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x3f, 0x3f, 0x1f, 0x1f, 0x1f, 0x1f, 0x00,
    0x00, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
    0xfe, 0xfe, 0xfc, 0xfc, 0xfc, 0xfc, 0xf8, 0xf8,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xfc, 0xfc, 0xfc,
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf9, 0xf9, 0xf9, 0xf9,
    0xf9, 0xf9, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1,
    0xf1, 0xf1, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,
    0x70, 0x7f, 0x7f, 0x7f, 0x7f, 0x7e, 0x7e, 0x3e,
    0x3e, 0x3c, 0x3c, 0xfc, 0xfc, 0x00, 0x00, 0x00,
    0x68, 0xf8, 0xfc, 0xfc, 0x00, 0x00, 0x3f, 0x7f,
    0x7f, 0x3f, 0x3f, 0x3f, 0x3f, 0x1f, 0x9f, 0x9f,
    0x8f, 0xcf, 0xcf, 0xe7, 0xe7, 0xe7, 0xf7, 0xf3,
    0xf3, 0xf3, 0xf1, 0xc1, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x0f, 0xff, 0xfc, 0xf0, 0xf0, 0xf0, 0xf8,
    0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xfc, 0xfc, 0xfc,
    0xfc, 0xfc, 0xfc, 0xfc, 0xfe, 0xfe, 0x06, 0x00,
    0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8,
    0xfc, 0xfc, 0xfc, 0xfd, 0xff, 0xff, 0xfe, 0xfc,
    0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0x3c, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

const unsigned char final2[]  = {
    0x55, 0xab, 0x55, 0xab, 0x57, 0xab, 0x57, 0xaf,
    0x57, 0xaf, 0xdf, 0xef, 0xff, 0xff, 0xff, 0xff,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xa8, 0x54, 0xaa, 0x55, 0xaa, 0x45, 0x02,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x80,
    0x40, 0xaa, 0x54, 0xaa, 0x55, 0xaa, 0x55, 0xaa,
    0x54, 0xaa, 0x51, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x00, 0xff, 0xff, 0xff, 0xff, 0xef, 0xdf, 0xaf,
    0x57, 0xaf, 0x57, 0xab, 0x57, 0xab, 0x55, 0xab,
    0xf5, 0xfa, 0xfd, 0xfa, 0xfd, 0xfe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x2a, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,
    0x50, 0xa0, 0x55, 0xaa, 0x44, 0x28, 0x15, 0x02,
    0x15, 0x2a, 0x15, 0x2a, 0x15, 0x2a, 0x55, 0xaa,
    0x55, 0xaa, 0x55, 0xa8, 0x50, 0xa0, 0x10, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x00, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xfd, 0xfa, 0xfd, 0xfa,
    0x55, 0xab, 0x55, 0xab, 0x55, 0xaa, 0xd5, 0xea,
    0xf5, 0xfa, 0xfd, 0xfe, 0xff, 0xff, 0x7f, 0xff,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02, 0x05, 0x0a, 0x15, 0x0a,
    0x15, 0x2a, 0x55, 0x2a, 0x55, 0xa8, 0x50, 0x80,
    0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x40, 0x28,
    0x14, 0x0a, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xf0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
    0x00, 0xff, 0x7f, 0xff, 0xff, 0xfe, 0xfd, 0xfa,
    0xf5, 0xea, 0xd5, 0xaa, 0x55, 0xab, 0x55, 0xab,
    0x7d, 0xbe, 0x5f, 0xbf, 0x5f, 0xaf, 0x57, 0xaf,
    0x57, 0xab, 0xd5, 0xea, 0xfd, 0xfe, 0xff, 0xff,
    0x00, 0x00, 0xff, 0xff, 0x7f, 0x3f, 0x9f, 0xcf,
    0xe7, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf8, 0xf0,
    0xf0, 0xe0, 0xc0, 0xc0, 0xc0, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0xc0, 0xc0, 0xc0, 0xe0,
    0xf0, 0xf0, 0xf8, 0xfc, 0xff, 0xff, 0xff, 0xff,
    0xe7, 0xcf, 0x9f, 0x3f, 0x7f, 0xff, 0xff, 0x00,
    0x00, 0xff, 0xff, 0xfe, 0xfd, 0xea, 0xd5, 0xab,
    0x57, 0xaf, 0x57, 0xaf, 0x5f, 0xbf, 0x5f, 0xbe,
    0x55, 0xaa, 0x55, 0xaa, 0x55, 0xea, 0xf5, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x1f,
    0x80, 0xe0, 0xf1, 0xf0, 0xf0, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0x73, 0x73, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x73, 0x73, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3,
    0xf3, 0xf3, 0xf3, 0xf3, 0xf0, 0xf0, 0xf1, 0xe0,
    0x80, 0x1f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0xf5, 0xea, 0x55, 0xaa, 0x55, 0xaa,
    0xd5, 0xfa, 0xfd, 0xfe, 0xff, 0xff, 0x7f, 0xbf,
    0x5f, 0xaf, 0x57, 0x2b, 0x05, 0xc0, 0xf0, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x7f, 0x3f, 0x1f, 0x8f, 0xc7, 0xe3, 0xf1,
    0xf8, 0xf8, 0xfc, 0xfc, 0xf8, 0xe1, 0x03, 0x07,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x07,
    0xe3, 0xf8, 0xfc, 0xfe, 0xfe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfc, 0xf8, 0xe1,
    0x07, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0xf0, 0xc0, 0x05, 0x2b, 0x57, 0xaf,
    0x5f, 0xbf, 0x7f, 0xff, 0xff, 0xfe, 0xfd, 0xfa,
    0x57, 0xab, 0x57, 0xab, 0x55, 0xaa, 0x55, 0x2a,
    0x15, 0x82, 0xe0, 0xf8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0x3f, 0x3f, 0x1f, 0x9f,
    0xcf, 0xc7, 0x67, 0x07, 0x07, 0x03, 0xc3, 0xf1,
    0xf8, 0xf8, 0xfc, 0xff, 0xff, 0xff, 0xff, 0x7f,
    0x3f, 0x1f, 0x8f, 0xc7, 0xe3, 0xf0, 0xf8, 0xfc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
    0x83, 0x1f, 0x3f, 0x7f, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7f, 0x7f, 0x3f, 0x1f, 0x87,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0xf8, 0xe0, 0x82,
    0x15, 0x2a, 0x55, 0xaa, 0x55, 0xab, 0x57, 0xaf,
    0x55, 0xaa, 0x55, 0xaa, 0x15, 0x0a, 0xc1, 0xf0,
    0xfc, 0xff, 0xff, 0x3f, 0x1f, 0x8f, 0xc7, 0x83,
    0xe1, 0xf8, 0xfc, 0xfc, 0xc0, 0xf0, 0xff, 0xff,
    0xff, 0xc1, 0xf0, 0xf8, 0xfe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0xf3, 0xe7, 0xc1, 0x18,
    0x1e, 0x3f, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xf0, 0xf3, 0xe7, 0xc6, 0xce, 0x9c, 0x9c, 0x9c,
    0x9c, 0x9c, 0x8c, 0xce, 0xce, 0xe7, 0xe3, 0xf0,
    0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0xf0, 0xc1, 0x0a, 0x15, 0xaa, 0x55, 0xaa,
    };
    
    const unsigned char final3[]  = {
    0x80, 0x40, 0xa0, 0xf0, 0xf8, 0x3e, 0x07, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xfa, 0x7d, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xc0, 0xf0, 0xb8, 0xce,
    0xe6, 0x73, 0x3b, 0x39, 0x19, 0x19, 0x39, 0xf1,
    0xe1, 0xc3, 0x03, 0x06, 0x0e, 0x3c, 0xf0, 0xc0,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x80, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0,
    0xe0, 0x70, 0x38, 0x3c, 0x1f, 0x07, 0x03, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0x78,
    0x3f, 0x1f, 0x00, 0x80, 0xc0, 0xf0, 0x7f, 0x1f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x08, 0x08, 0x0c, 0x0e, 0x0e,
    0x07, 0x03, 0x01, 0x01, 0x0c, 0x0f, 0x0f, 0x07,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x0c, 0x0e, 0x07, 0x07, 0x07, 0x06, 0x06,
    0x06, 0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00
};

const unsigned char final4[]  = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80,
    0xc0, 0xe0, 0xd0, 0x50, 0x00, 0x48, 0x40, 0xe0,
    0xf0, 0xf0, 0xf8, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
    0xfc, 0xfc, 0x7c, 0x7c, 0xfc, 0xbc, 0xbc, 0xfc,
    0xf8, 0xe8, 0x08, 0x10, 0x30, 0x30, 0x20, 0x40,
    0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xc0,
    0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff, 0xff, 0xfb,
    0xf9, 0x18, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03,
    0x03, 0x01, 0x01, 0x80, 0x81, 0x01, 0x60, 0x04,
    0x0c, 0x18, 0xf0, 0xc0, 0x80, 0x01, 0x03, 0xf7,
    0xff, 0xef, 0xe7, 0xfe, 0xfc, 0xf8, 0xf0, 0x13,
    0x3e, 0x26, 0x00, 0x00, 0x00, 0x80, 0x80, 0xa0,
    0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0xe0, 0xfc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x0f, 0x07,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x41, 0x83, 0x07, 0x0f, 0x00, 0x00,
    0x01, 0x01, 0x41, 0x67, 0x87, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0xe0, 0xc3, 0x3f, 0x0f,
    0x07, 0x03, 0x03, 0x0c, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xdc, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00,
    0x80, 0x01, 0x00, 0x80, 0xc0, 0xe0, 0xf8, 0xfc,
    0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xf0, 0xe0, 0xc4, 0xcf, 0x9f, 0x0f, 0x27,
    0x3f, 0x7f, 0xf4, 0xe4, 0xc7, 0xcf, 0xdf, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xf0, 0xe0, 0xc0, 0x80, 0x80, 0xc0, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x07, 0x3f, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0xfc, 0xf8, 0x39, 0x1b, 0x03, 0x01, 0x01, 0x01,
    0x01, 0x03, 0x03, 0x03, 0x03, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x0f, 0x1f, 0x3f, 0x3f, 0x3f, 0x3f,
    0x3f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x7f, 0x3f, 0x07, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
    0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0xfc, 0xf8, 0xe0, 0xe0, 0xc0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xf0,
    0xfc, 0xff, 0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07,
    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
    0x03, 0x07, 0x0f, 0x0f, 0x0f, 0x1f, 0x1f, 0x1f,
    0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x39,
    0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x20,
    0x00, 0x10, 0x10, 0x08, 0x0c, 0x0e, 0x07, 0x03,
    0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
const unsigned char final5[]  = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x50, 0xf0, 0xf8, 0x78, 0x78,
    0x38, 0x78, 0x73, 0x23, 0x8f, 0xff, 0xfe, 0x7f,
    0x3f, 0xc0, 0x7c, 0x7c, 0xfc, 0xbc, 0xbc, 0xfc,
    0xf8, 0xe8, 0x08, 0x10, 0x30, 0x30, 0x20, 0x40,
    0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
    0xe0, 0xf8, 0xfc, 0x1c, 0x0c, 0x06, 0x06, 0x02,
    0x06, 0x86, 0xcc, 0xd8, 0x70, 0x70, 0x38, 0x9c,
    0xdc, 0xc6, 0xf9, 0xfc, 0xfe, 0x3e, 0x06, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
    0xe0, 0xfc, 0xc7, 0x80, 0x01, 0x01, 0x04, 0x06,
    0x1f, 0xf9, 0xf0, 0xc0, 0x80, 0x01, 0x03, 0xf7,
    0xff, 0xef, 0xe7, 0xfe, 0xfc, 0xf8, 0xf0, 0x13,
    0x3e, 0x26, 0x00, 0x00, 0x00, 0x80, 0x82, 0xac,
    0xd8, 0x18, 0x38, 0x60, 0xf0, 0xb0, 0x10, 0x10,
    0x30, 0x20, 0xe0, 0x80, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x1f, 0xdf,
    0x7f, 0x33, 0x61, 0x43, 0x03, 0x02, 0x00, 0x00,
    0x00, 0x3f, 0x7f, 0xf1, 0xcc, 0x9e, 0x3f, 0x7f,
    0xff, 0xff, 0x0f, 0x03, 0x01, 0x00, 0x00, 0x80,
    0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x10,
    0x20, 0xc1, 0x63, 0x39, 0x0f, 0x00, 0x00, 0x00,
    0xfc, 0x07, 0x41, 0x67, 0x87, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
    0xdf, 0xff, 0xff, 0xf6, 0xe0, 0xc3, 0x3f, 0x0f,
    0x07, 0x03, 0x03, 0x0c, 0x20, 0x01, 0x1e, 0xf3,
    0x81, 0x01, 0x03, 0x03, 0x06, 0x0c, 0x38, 0xf0,
    0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x1f, 0x01,
    0x60, 0x80, 0x80, 0x00, 0x00, 0xfc, 0xfe, 0xff,
    0xff, 0x07, 0xf3, 0xfb, 0xfb, 0xf3, 0xf7, 0xf7,
    0xf4, 0xf5, 0xf5, 0xf1, 0xf1, 0xf5, 0xa1, 0x21,
    0x29, 0x23, 0x62, 0x4a, 0x5a, 0xda, 0xca, 0x62,
    0xc3, 0x41, 0x70, 0x98, 0xcc, 0xee, 0xfe, 0xff,
    0xff, 0xff, 0x7f, 0x7f, 0x7f, 0xff, 0xff, 0xff,
    0xfb, 0xff, 0xef, 0xff, 0xff, 0x7f, 0x3f, 0x1f,
    0x4f, 0x23, 0x91, 0x99, 0x91, 0x99, 0x99, 0xb9,
    0x19, 0x33, 0x76, 0xe4, 0xe4, 0xcd, 0xd8, 0x30,
    0x03, 0x3e, 0x00, 0x00, 0x30, 0x3c, 0x0f, 0x07,
    0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0e,
    0x3e, 0xfc, 0xf8, 0xf0, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x06,
    0x04, 0x08, 0x08, 0x11, 0x18, 0x1c, 0x0f, 0x1f,
    0xbf, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0x7f, 0x7f, 0xff, 0xff,
    0xf8, 0xf0, 0x60, 0x44, 0x6f, 0xff, 0xef, 0xe7,
    0xff, 0xff, 0x74, 0x64, 0x67, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x7e, 0x7e, 0xfe, 0xfc, 0xfc,
    0xfc, 0xf8, 0xf8, 0xf8, 0xf8, 0xf8, 0xfd, 0x7c,
    0xfe, 0xfe, 0xff, 0xff, 0xff, 0xf0, 0x80, 0x01,
    0x01, 0x03, 0x06, 0x0c, 0xf9, 0x07, 0x7d, 0xc1,
    0x41, 0x00, 0x10, 0x20, 0x20, 0x60, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xc0,
    0xe0, 0xff, 0xff, 0x3f, 0x1f, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x3f,
    0x63, 0xc6, 0x44, 0x49, 0xfb, 0x1b, 0xc3, 0xe3,
    0xf3, 0xf3, 0xf9, 0xf8, 0xfc, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xfe, 0xfc, 0xf8, 0xf0, 0xe1,
    0xe7, 0x6f, 0x0f, 0x07, 0x07, 0x07, 0xc6, 0x3f,
    0x07, 0x03, 0xf0, 0x0c, 0x03, 0x07, 0x07, 0x07,
    0x07, 0x07, 0x0f, 0x1f, 0x3f, 0x3f, 0x3f, 0x3d,
    0x3e, 0xff, 0xdf, 0x3f, 0x7f, 0xff, 0xff, 0xff,
    0xfe, 0xfc, 0x78, 0x38, 0x85, 0x80, 0xfc, 0x1f,
    0x00, 0x00, 0x80, 0x80, 0xe0, 0xe0, 0xff, 0xf8,
    0x06, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
    0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x03, 0x06, 0x04, 0x07, 0x0e, 0x08, 0x13,
    0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff, 0xdf, 0xff,
    0x7f, 0x7f, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0xf0, 0xe0, 0x80, 0xf0, 0x4f, 0x80, 0x7c,
    0xf8, 0xe3, 0xec, 0x90, 0x20, 0x40, 0x80, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xf0,
    0xf4, 0xff, 0xff, 0x7f, 0x3c, 0x80, 0xc3, 0x67,
    0x33, 0x38, 0x2e, 0x2b, 0x3b, 0x10, 0x11, 0x1d,
    0x07, 0x03, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x02, 0x07, 0x0f, 0x2f, 0x4f, 0xdf, 0xdf, 0x1f,
    0xbf, 0xbf, 0x3f, 0xbf, 0xbf, 0xa7, 0xb1, 0x16,
    0x48, 0x63, 0x76, 0x1f, 0x2f, 0x5a, 0x54, 0x79,
    0x32, 0x44, 0x58, 0x48, 0x6c, 0x6e, 0x67, 0x33,
    0x19, 0x0d, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const unsigned char eyes1[]  = {
    0xc9, 0xf9, 0x0d, 0xc5, 0xe5, 0xe5, 0xe4, 0x84,
    0x8c, 0xfc, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe6,
    0xe2, 0x72, 0x72, 0x72, 0x70, 0x70, 0x70, 0x70,
    0x7c, 0x62, 0x61, 0x39, 0x39, 0x32, 0x24, 0x3c,
    0xff, 0x01, 0x01, 0x01, 0x01, 0x31, 0x79, 0x78,
    0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x06, 0x0f, 0x0f, 0x06, 0x00, 0x00
};

const unsigned char eyes2[]  = {
    0xc9, 0xe9, 0x1d, 0x8d, 0xcd, 0xcd, 0xcc, 0x0c,
    0x1c, 0xf4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe6,
    0xe2, 0x72, 0x72, 0x72, 0x70, 0x70, 0x70, 0x70,
    0x78, 0x44, 0x42, 0x72, 0x32, 0x64, 0x48, 0x7c,
    0xff, 0x01, 0x00, 0x01, 0x01, 0x21, 0x71, 0x31,
    0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x04, 0x06, 0x06, 0x04, 0x00, 0x00
};
const unsigned char eyes3[]  = {
    0xc9, 0xe9, 0x25, 0x15, 0x95, 0x95, 0x94, 0x14,
    0x24, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe6,
    0xe2, 0x72, 0x72, 0x72, 0x70, 0x70, 0x70, 0x70,
    0x70, 0x88, 0x84, 0xe4, 0x64, 0xc8, 0x98, 0xfc,
    0xff, 0x03, 0x00, 0x03, 0x01, 0x01, 0x01, 0x02,
    0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

};


const unsigned char signals[4][16]  = {
    {
        0xff, 0x81, 0xff, 0x91, 0x89, 0x89, 0x89, 0x91,
        0x91, 0x91, 0x91, 0x89, 0x91, 0xff, 0x81, 0xff
    }, {
        0xff, 0x81, 0xff, 0x91, 0xa1, 0xa1, 0x91, 0x91,
        0x89, 0x85, 0x85, 0x89, 0x91, 0xff, 0x81, 0xff
    }, {
        0xff, 0x81, 0xff, 0x89, 0x85, 0x89, 0x91, 0xa1,
        0xc1, 0xa1, 0x91, 0x91, 0x91, 0xff, 0x81, 0xff
    }, {
        0xff, 0x81, 0xff, 0x89, 0x85, 0x85, 0x89, 0x91,
        0x91, 0xa1, 0xc1, 0xc1, 0xa1, 0xff, 0x81, 0xff
    }
};

const unsigned char temptop[]  = {
    0xff, 0x01, 0x05, 0x01, 0x01, 0x01, 0xf1, 0x89,
    0x09, 0xf1, 0x01, 0x01, 0x01, 0x05, 0x01, 0xff
};

const unsigned char tempmiddle[]  = {
    0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x88,
    0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff
};

const unsigned char tempbottom[]  = {
    0xff, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x08,
    0x00, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0xff,
    0xff, 0x80, 0xa0, 0x80, 0x8f, 0x9f, 0xbf, 0xb0,
    0xb0, 0xbf, 0x9f, 0x8f, 0x80, 0xa0, 0x80, 0xff
};

const unsigned char side[]  = {
    0xff, 0x80, 0xa0, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0xa0, 0x80, 0xff,
    0xee, 0xfe, 0xee, 0xe4, 0x07, 0x80, 0x9f, 0x90,
    0xbb, 0xfa, 0xba, 0x82, 0x82, 0xba, 0xbe, 0xb8,
    0xf7, 0x9f, 0x97, 0xf7, 0x01, 0xf7, 0x97, 0x97,
    0x97, 0xf7, 0x07, 0xf7, 0x97, 0x9f, 0x97, 0xf7,
    0x01, 0x01, 0x01, 0x01, 0x00, 0x01, 0x00, 0x01,
    0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xfe, 0x02, 0xaa, 0x82, 0xaa, 0x02, 0xe2, 0x36,
    0x24, 0x34, 0x24, 0x36, 0xe2, 0x02, 0xf2, 0x9e,
    0x0f, 0x98, 0xfb, 0x0a, 0xfb, 0x98, 0x09, 0x0b,
    0x09, 0x0b, 0x99, 0xfb, 0x09, 0xf8, 0x98, 0x0f,
    0xff, 0x81, 0xff, 0x81, 0x81, 0x81, 0x81, 0x81,
    0x81, 0x81, 0x81, 0x81, 0x81, 0xff, 0x81, 0xff
};


const unsigned char character[2][8]  = {
    {
        0x30, 0x9f, 0xe1, 0x4d, 0x4d, 0xe1, 0x9f, 0x30  //0 - Outline
    }, {
        0x00, 0x00, 0x1e, 0x32, 0x32, 0x1e, 0x00, 0x00  //1 - Fill
    }
};

const unsigned char deathsheet[4][24]  = {
    {
        0x00, 0x00, 0xc0, 0x7c, 0x04, 0x30, 0x34, 0x8c,
        0x58, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02,
        0x03, 0x00, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00,
    }, {
        0x00, 0x40, 0xd6, 0x02, 0x00, 0x18, 0x10, 0x8a,
        0x46, 0x14, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x02,
        0x03, 0x00, 0x00, 0x03, 0x02, 0x00, 0x00, 0x00
    }, {
        0x04, 0xea, 0x11, 0x0a, 0x82, 0x21, 0x81, 0x12,
        0x01, 0x81, 0x8a, 0x74, 0x00, 0x00, 0x01, 0x03,
        0x03, 0x01, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00
    }, {
        0xc5, 0x00, 0x14, 0x01, 0x02, 0x80, 0x00, 0x10,
        0x01, 0x00, 0x80, 0x15, 0x01, 0x00, 0x06, 0x07,
        0x02, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x01
    }
};

#define BLOCK 0
#define TLCOR 1
#define TRCOR 2
#define BLCOR 3
#define BRCOR 4
#define HWALL 5
#define VWALL 6
#define NUBUP 7
#define NUBDO 8
#define NUBLE 9
#define NUBRI 10
#define CHIPI 11
#define LEDOF 12
#define LEDON 13
#define CPUIN 14
#define HEATI 15
#define VTROT 19
#define HTROT 20
#define CONUP 21
#define CONDO 22
#define CONLE 23
#define CONRI 24
#define CHIPO 37
#define EXITS 38
#define CPUOU 42
#define HEATO 43
#define HEATB 44
#define ROTAB 45
#define TLROT 46
#define TRROT 47
#define BRROT 48
#define BLROT 49
#define BLANK 50
#define START 51
#define HOLD 99
const unsigned char spritesheet[][8]  = {
    {
        0x00, 0x7e, 0x7e, 0x66, 0x66, 0x7e, 0x7e, 0x00  //0 Block Wall
    }, {
        0x00, 0xfe, 0xfe, 0x06, 0x06, 0xe6, 0xe6, 0x66  //1 Top-Left Corner Wall
    }, {
        0x66, 0xe6, 0xe6, 0x06, 0x06, 0xfe, 0xfe, 0x00  //2 Top-Right Corner Wall
    }, {
        0x00, 0x7f, 0x7f, 0x60, 0x60, 0x67, 0x67, 0x66  //3 Bottom-Left Corner Wall
    }, {
        0x66, 0x67, 0x67, 0x60, 0x60, 0x7f, 0x7f, 0x00  //4 Bottom-Right Corner Wall
    }, {
        0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66  //5 Horizontal Wall
    }, {
        0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00  //6 Vertical Wall
    }, {
        0x00, 0xfe, 0xfe, 0x06, 0x06, 0xfe, 0xfe, 0x00  //7 Top Nub Wall
    }, {
        0x00, 0x7f, 0x7f, 0x60, 0x60, 0x7f, 0x7f, 0x00  //8 Bottom Nub Wall
    }, {
        0x00, 0x7e, 0x7e, 0x66, 0x66, 0x66, 0x66, 0x66  //9 Left Nub Wall
    }, {
        0x66, 0x66, 0x66, 0x66, 0x66, 0x7e, 0x7e, 0x00  //10 Right Nub Wall
    }, {
        0xda, 0x7f, 0x61, 0x61, 0x61, 0x61, 0x7f, 0xda  //11 Chip Inserted
    }, {
        0x00, 0x7e, 0xd1, 0x51, 0x41, 0xc1, 0x7e, 0x00, //12 LED Off
    }, {
        0x00, 0x7e, 0xdf, 0x5f, 0x7f, 0xff, 0x7e, 0x00, //13 LED On
    }, {
        0xe7, 0xbd, 0xff, 0x7e, 0x7e, 0xff, 0xbd, 0xe7  //14 CPU In
    }, {
        0xff, 0xab, 0xd5, 0xab, 0xd5, 0xab, 0xd5, 0xff  //15 Heatsink In
    }, {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  //16 ??? Wall
    }, {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  //17 ??? Wall
    }, {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  //18 ??? Wall
    }, {
        0xff, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0xff  //19 Rotating Vertical Tunnel
    }, {
        0x81, 0x81, 0x81, 0x91, 0x81, 0x81, 0x81, 0x81  //20 Rotating Horizontal Tunnel
    }, {
        0xff, 0xe7, 0xb3, 0x99, 0x99, 0xb3, 0xe7, 0xff  //21 Conveyer Belt Up
    }, {
        0xff, 0xe7, 0xcd, 0x99, 0x99, 0xcd, 0xe7, 0xff  //22 Conveyer Belt Down
    }, {
        0xff, 0xe7, 0xc3, 0x99, 0xbd, 0xe7, 0xc3, 0xff  //23 Conveyer Belt Left
    }, {
        0xff, 0xc3, 0xe7, 0xbd, 0x99, 0xc3, 0xe7, 0xff  //24 Conveyer Belt Right
    }, {
        0xff, 0xb3, 0x99, 0x8d, 0x8d, 0x99, 0xb3, 0xff  //   Conveyer Belt Up 2
    }, {
        0xff, 0xcd, 0x99, 0xb1, 0xb1, 0x99, 0xcd, 0xff  //   Conveyer Belt Down 2
    }, {
        0xff, 0xc3, 0x99, 0xbd, 0xe7, 0xc3, 0x81, 0xff  //   Conveyer Belt Left 2
    }, {
        0xff, 0x81, 0xc3, 0xe7, 0xbd, 0x99, 0xc3, 0xff  //   Conveyer Belt Right 2
    }, {
        0xff, 0x99, 0xcd, 0xe7, 0xe7, 0xcd, 0x99, 0xff  //   Conveyer Belt Up 3
    }, {
        0xff, 0x99, 0xb3, 0xe7, 0xe7, 0xb3, 0x99, 0xff  //   Conveyer Belt Down 3
    }, {
        0xff, 0x99, 0xbd, 0xe7, 0xc3, 0x99, 0xbd, 0xff  //   Conveyer Belt Left 3
    }, {
        0xff, 0xbd, 0x99, 0xc3, 0xe7, 0xbd, 0x99, 0xff  //   Conveyer Belt Right 3
    }, {
        0xff, 0xcd, 0xe7, 0xb3, 0xb3, 0xe7, 0xcd, 0xff  //   Conveyer Belt Up 4
    }, {
        0xff, 0xb3, 0xe7, 0xcd, 0xcd, 0xe7, 0xb3, 0xff  //   Conveyer Belt Down 4
    }, {
        0xff, 0xbd, 0xe7, 0xc3, 0x99, 0xbd, 0xe7, 0xff  //   Conveyer Belt Left 4
    }, {
        0xff, 0xe7, 0xbd, 0x99, 0xc3, 0xe7, 0xbd, 0xff  //   Conveyer Belt Right 4
    }, {
        0x00, 0x54, 0x54, 0x00, 0x00, 0x54, 0x54, 0x00  //37 Chip Out
    }, {
        0xc3, 0x81, 0x00, 0x00, 0x00, 0x00, 0x81, 0xc3, //38 Level Exit
    }, {
        0x00, 0x66, 0x42, 0x00, 0x00, 0x42, 0x66, 0x00, //   Level Exit 2
    }, {
        0x00, 0x00, 0x3c, 0x24, 0x24, 0x3c, 0x00, 0x00, //   Level Exit 3
    }, {
        0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, //   Level Exit 4
    }, {
        0x00, 0x42, 0x00, 0x00, 0x00, 0x00, 0x42, 0x00  //42 CPU Out
    }, {
        0x55, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xaa  //43 Heatsink Out
    }, {
        0x00, 0x2a, 0x40, 0x1a, 0x58, 0x02, 0x54, 0x00  //44 Heatsink Button
    }, {
        0x00, 0x4a, 0xe0, 0x02, 0x40, 0x07, 0x52, 0x00  //45 Rotation Button
    }, {
        0xf8, 0x04, 0x02, 0x01, 0x11, 0x01, 0x01, 0x01  //46 Top-Left Rotating Corner
    }, {
        0x01, 0x01, 0x01, 0x11, 0x01, 0x02, 0x04, 0xf8  //47 Top-Right Rotating Corner
    }, {
        0x80, 0x80, 0x80, 0x88, 0x80, 0x40, 0x20, 0x1f  //48 Bottom-Right Rotating Corner
    }, {
        0x1f, 0x20, 0x40, 0x80, 0x88, 0x80, 0x80, 0x80  //49 Bottom-Left Rotating Corner
    }
};

const unsigned char levelmap[50][112]  = {
    {
        // Level 1
        TLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR,
        VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
        VWALL, BLANK, START, BLANK, BLANK, CHIPO, BLANK, CHIPO, BLANK, LEDOF, BLANK, BLANK, BLANK, VWALL,
        VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
        VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
        VWALL, BLANK, EXITS, BLANK, BLANK, CHIPO, BLANK, CHIPO, BLANK, LEDOF, BLANK, BLANK, BLANK, VWALL,
        VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
        BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR
    },{
        // Level 2
        TLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR, BLANK, TLCOR, HWALL, HWALL, HWALL, TRCOR,
        VWALL, START, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL, BLANK, VWALL, LEDOF, BLANK, LEDOF, VWALL,
        VWALL, BLANK, BLANK, CHIPO, CHIPO, BLANK, BLANK, VWALL, BLANK, VWALL, BLANK, BLANK, BLANK, VWALL,
        VWALL, BLANK, BLANK, CHIPO, CHIPO, BLANK, BLANK, BLCOR, HWALL, BRCOR, BLANK, EXITS, BLANK, VWALL,
        VWALL, BLANK, BLANK, CHIPO, CHIPO, BLANK, BLANK, CHIPO, CHIPO, CHIPO, BLANK, BLANK, BLANK, VWALL,
        VWALL, BLANK, BLANK, CHIPO, CHIPO, BLANK, BLANK, CHIPO, CHIPO, CHIPO, BLANK, BLANK, BLANK, VWALL,
        VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, CHIPO, CHIPO, CHIPO, BLANK, BLANK, BLANK, VWALL,
        BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR,
    },{
        // Level 3
        TLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR,
        VWALL, CHIPO, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, CHIPO, BLANK, CHIPO, VWALL,
        VWALL, BLANK, TLCOR, HWALL, HWALL, HWALL, HWALL, NUBRI, BLANK, NUBLE, HWALL, NUBRI, BLANK, VWALL,
        VWALL, BLANK, NUBDO, LEDOF, LEDOF, BLANK, BLANK, BLANK, BLANK, BLANK, LEDOF, LEDOF, BLANK, VWALL,
        VWALL, BLANK, CHIPO, CHIPO, CHIPO, BLANK, START, BLANK, EXITS, BLANK, TLCOR, NUBRI, BLANK, VWALL,
        VWALL, BLANK, BLOCK, BLANK, NUBLE, HWALL, NUBRI, BLANK, NUBLE, HWALL, BRCOR, LEDOF, BLANK, VWALL,
        VWALL, CHIPO, BLANK, BLANK, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, BLANK, CHIPO, CHIPO, VWALL,
        BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR, BLANK, CHIPO, CHIPO, VWALL,
    },{
        // Level 4
        TLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR,
        VWALL, BLANK, BLANK, BLANK, CHIPO, BLANK, CHIPO, BLANK, CHIPO, BLANK, BLANK, BLANK, LEDOF, VWALL,
        VWALL, BLANK, BLANK, BLANK, TLCOR, HWALL, HWALL, HWALL, TRCOR, BLANK, BLANK, TLCOR, HWALL, BRCOR,
        VWALL, BLANK, START, BLANK, VWALL, BLANK, BLANK, BLANK, VWALL, BLANK, BLANK, VWALL, BLANK, BLANK,
        VWALL, BLANK, BLANK, BLANK, NUBDO, BLANK, BLANK, BLANK, NUBDO, BLANK, BLANK, VWALL, BLANK, BLANK,
        VWALL, BLANK, EXITS, BLANK, CONLE, CONLE, CONLE, CONLE, CONLE, BLANK, BLANK, VWALL, BLANK, BLANK,
        VWALL, BLANK, BLANK, BLANK, NUBUP, BLANK, BLANK, BLANK, NUBUP, BLANK, BLANK, VWALL, BLANK, BLANK,
        BLCOR, HWALL, HWALL, HWALL, BRCOR, BLANK, BLANK, BLANK, BLCOR, HWALL, HWALL, BRCOR, LEDOF, LEDOF,
    },{
        // Level 5
        CHIPO, CHIPO, CHIPO, BLCOR, HWALL, BRCOR, CHIPO, VWALL, BLANK, VWALL, LEDOF, EXITS, LEDOF, VWALL,
        CHIPO, CHIPO, BLANK, CONLE, CONLE, CONLE, BLANK, VWALL, BLANK, VWALL, BLANK, BLANK, BLANK, VWALL,
        CHIPO, CHIPO, CHIPO, TLCOR, HWALL, TRCOR, CONUP, VWALL, BLANK, BLCOR, TRCOR, CONUP, TLCOR, BRCOR,
        HWALL, TRCOR, CONDO, VWALL, BLANK, VWALL, CONUP, VWALL, BLANK, BLANK, VWALL, CONUP, VWALL, BLANK,
        BLANK, VWALL, CONDO, VWALL, BLANK, VWALL, CONUP, VWALL, BLANK, TLCOR, BRCOR, CONUP, BLCOR, TRCOR,
        HWALL, BRCOR, CONDO, BLCOR, HWALL, BRCOR, BLANK, BLCOR, HWALL, BRCOR, LEDOF, BLANK, LEDOF, VWALL,
        CHIPO, CHIPO, BLANK, CONRI, CONRI, CONRI, START, CONRI, CONRI, CONRI, BLANK, BLANK, BLANK, VWALL,
        CHIPO, CHIPO, BLANK, TLCOR, HWALL, TRCOR, CHIPO, TLCOR, HWALL, TRCOR, CHIPO, CHIPO, CHIPO, VWALL,
    },{
        // Level 6
        TLCOR, HWALL, NUBRI, CONDO, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, TRCOR,
        VWALL, START, CONLE, BLANK, NUBLE, HWALL, TRCOR, CHIPO, BLOCK, CHIPO, BLOCK, CHIPO, CHIPO, VWALL,
        VWALL, BLANK, CONRI, BLANK, CONRI, BLANK, VWALL, BLANK, CONRI, BLANK, CONRI, BLANK, BLANK, VWALL,
        VWALL, CHIPO, NUBUP, CHIPO, NUBUP, CHIPO, NUBDO, CHIPO, NUBUP, CHIPO, BLOCK, CHIPO, BLANK, VWALL,
        VWALL, EXITS, VWALL, CHIPO, VWALL, CHIPO, CONRI, BLANK, VWALL, BLANK, CONLE, CONLE, CONDO, VWALL,
        VWALL, CHIPO, NUBDO, BLANK, NUBDO, CHIPO, NUBUP, CHIPO, VWALL, CHIPO, NUBUP, CHIPO, BLANK, VWALL,
        VWALL, BLANK, CONLE, BLANK, CONRI, BLANK, NUBDO, BLANK, VWALL, BLANK, NUBDO, BLANK, BLANK, VWALL,
        BLCOR, HWALL, NUBRI, CONUP, CONLE, CONLE, CONLE, CONLE, NUBDO, CONRI, CONRI, CONUP, NUBLE, BRCOR,
    },{
        // Level 7
        CHIPO, CHIPO, CHIPO, CHIPO, VWALL, BLANK, CHIPO, BLANK, VWALL, BLANK, BLANK, BLANK, BLANK, BLANK,
        CHIPO, CHIPO, CHIPO, CHIPO, VWALL, BLANK, CHIPO, BLANK, VWALL, BLANK, CHIPO, CHIPO, CHIPO, BLANK,
        HWALL, NUBRI, BLANK, BLANK, NUBDO, BLANK, CHIPO, BLANK, VWALL, BLANK, CHIPO, CHIPO, CHIPO, BLANK,
        BLANK, BLANK, BLANK, BLANK, CPUOU, BLANK, CHIPO, BLANK, VWALL, BLANK, CHIPO, CHIPO, CHIPO, BLANK,
        HWALL, NUBRI, CPUOU, NUBLE, TRCOR, BLANK, CHIPO, BLANK, NUBDO, BLANK, BLANK, BLANK, BLANK, BLANK,
        BLANK, BLANK, BLANK, BLANK, VWALL, BLANK, CHIPO, BLANK, CPUOU, BLANK, BLANK, BLANK, BLANK, BLANK,
        BLANK, START, EXITS, BLANK, BLCOR, HWALL, HWALL, HWALL, HWALL, NUBRI, CPUOU, NUBLE, HWALL, TRCOR,
        BLANK, BLANK, BLANK, BLANK, CONLE, BLANK, CPUOU, BLANK, CONLE, BLANK, BLANK, BLANK, BLANK, VWALL,
    },{
        // Level 8
        TLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR,
        VWALL, CHIPO, CHIPO, CHIPO, BLANK, CONLE, BLANK, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, VWALL,
        VWALL, CHIPO, CHIPO, CHIPO, CPUOU, BLOCK, BLANK, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, BLCOR,
        NUBDO, CHIPO, NUBLE, TRCOR, BLANK, CONRI, CONUP, NUBLE, HWALL, HWALL, NUBRI, BLANK, BLANK, START,
        CONDO, CONLE, CONLE, NUBDO, BLANK, NUBUP, TLCOR, HWALL, HWALL, HWALL, NUBRI, BLANK, BLANK, EXITS,
        CONDO, CHIPO, CHIPO, CHIPO, CPUOU, NUBDO, NUBDO, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, TLCOR,
        CONDO, CHIPO, CHIPO, CHIPO, BLANK, CONLE, BLANK, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, VWALL,
        CONRI, CONRI, CONRI, CONRI, CONUP, NUBLE, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR,
    },{
        // Level 9
        LEDOF, CPUOU, LEDOF, TLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR, LEDOF, CPUOU, CPUOU, LEDOF,
        BLANK, BLANK, BLANK, VWALL, CONRI, BLANK, CHIPO, BLANK, BLANK, VWALL, BLANK, BLANK, BLANK, BLANK,
        NUBRI, CPUOU, NUBLE, BRCOR, BLANK, BLOCK, BLANK, BLOCK, BLANK, BLCOR, NUBRI, CPUOU, NUBLE, TRCOR,
        BLANK, BLANK, BLANK, BLANK, CHIPO, BLANK, CPUOU, BLANK, BLANK, CPUOU, BLANK, BLANK, BLANK, VWALL,
        NUBRI, CPUOU, NUBLE, TRCOR, BLANK, BLOCK, BLANK, BLOCK, BLANK, TLCOR, NUBRI, CPUOU, NUBLE, BRCOR,
        BLANK, BLANK, BLANK, VWALL, CONUP, BLANK, CHIPO, BLANK, CONLE, VWALL, BLANK, BLANK, BLANK, BLANK,
        BLANK, EXITS, BLANK, BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR, BLANK, START, BLANK, BLANK,
        BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, CPUOU, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK
    },{
        // Level 10
        CHIPO, CHIPO, CHIPO, BLANK, BLANK, BLANK, CHIPO, CHIPO, CHIPO, VWALL, BLANK, BLANK, BLANK, BLANK,
        CHIPO, LEDOF, CHIPO, BLANK, BLANK, BLANK, CHIPO, LEDOF, CHIPO, VWALL, BLANK, CHIPO, CHIPO, BLANK,
        CHIPO, CHIPO, CHIPO, BLANK, BLANK, BLANK, CHIPO, CHIPO, CHIPO, VWALL, BLANK, BLANK, BLANK, BLANK,
        TRCOR, CONDO, NUBLE, NUBRI, CONUP, NUBLE, NUBRI, CONDO, NUBLE, BRCOR, BLANK, BLANK, BLANK, BLANK,
        BRCOR, BLANK, CHIPO, CHIPO, START, CHIPO, CHIPO, BLANK, BLANK, CONRI, BLANK, BLANK, EXITS, BLANK,
        BLANK, CONRI, BLANK, CHIPO, CONDO, CHIPO, BLANK, CONLE, BLANK, NUBUP, BLANK, BLANK, BLANK, BLANK,
        BLANK, BLANK, HEATI, CHIPO, BLANK, CHIPO, HEATI, BLANK, BLANK, VWALL, BLANK, CHIPO, CHIPO, BLANK,
        LEDOF, BLANK, CONLE, CHIPO, CONUP, CHIPO, CONRI, BLANK, LEDOF, VWALL, BLANK, BLANK, BLANK, BLANK,
    },{
        // Level 11
        LEDOF, LEDOF, VWALL, BLANK, BLANK, BLANK, BLANK, HEATO, EXITS, VWALL, CHIPO, CHIPO, CHIPO, VWALL,
        HWALL, HWALL, BRCOR, BLANK, BLANK, BLANK, BLANK, HEATO, NUBLE, BRCOR, CHIPO, CHIPO, CHIPO, VWALL,
        BLANK, BLANK, HEATB, BLANK, CONRI, CONRI, CONDO, HEATO, HEATO, HEATB, BLANK, BLANK, BLANK, VWALL,
        BLANK, BLANK, NUBLE, HWALL, NUBRI, BLANK, CONDO, BLANK, NUBLE, TRCOR, HEATI, HEATI, HEATI, VWALL,
        CHIPO, CHIPO, CHIPO, NUBUP, CHIPO, CHIPO, CONDO, CHIPO, CHIPO, VWALL, BLANK, BLANK, BLANK, VWALL,
        CHIPO, CHIPO, CHIPO, NUBDO, CHIPO, CHIPO, HEATB, CHIPO, CHIPO, VWALL, BLANK, START, BLANK, VWALL,
        BLANK, BLANK, BLANK, HEATO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, VWALL, BLANK, BLANK, BLANK, VWALL,
        BLANK, BLANK, BLANK, NUBUP, CHIPO, CHIPO, HEATB, CHIPO, CHIPO, VWALL, BLANK, HEATB, BLANK, VWALL,
    },{
        // Level 12
        LEDOF, BLANK, BLANK, BLANK, CONRI, HEATB, BLANK, HEATO, CHIPO, HEATB, HEATI, HEATI, HEATB, CHIPO,
        BLANK, BLANK, EXITS, BLANK, NUBUP, CHIPO, CHIPO, NUBUP, CHIPO, CHIPO, HEATI, HEATI, CHIPO, CHIPO,
        LEDOF, BLANK, BLANK, BLANK, NUBDO, CHIPO, CHIPO, VWALL, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO,
        BLANK, BLANK, HEATB, BLANK, HEATI, HEATI, CHIPO, BLCOR, NUBRI, CONDO, NUBLE, TRCOR, HEATI, HEATI,
        BLANK, START, BLANK, BLANK, NUBUP, CHIPO, CHIPO, CHIPO, CHIPO, HEATB, CHIPO, VWALL, CHIPO, CHIPO,
        LEDOF, BLANK, HEATO, HEATO, NUBDO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, NUBDO, BLANK, NUBUP,
        BLANK, BLANK, HEATO, BLANK, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, BLANK, VWALL,
        LEDOF, BLANK, HEATO, HEATO, NUBLE, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR,
    },{
        // Level 13
        TLCOR, HWALL, TRCOR, BLANK, LEDOF, BLANK, NUBUP, EXITS, TLCOR, HWALL, HWALL, HWALL, HWALL, TRCOR,
        VWALL, CHIPI, BLCOR, HWALL, HWALL, HWALL, BRCOR, BLANK, NUBDO, CHIPO, CHIPO, CHIPO, CHIPO, VWALL,
        VWALL, BLANK, LEDOF, CHIPO, CONRI, CONRI, CONRI, BLANK, CONRI, CONRI, BLANK, BLANK, CHIPO, VWALL,
        VWALL, BLANK, LEDOF, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, BLOCK, CHIPO, CHIPO, CHIPO, CHIPO, VWALL,
        VWALL, BLANK, TLCOR, NUBRI, CHIPO, CONRI, CONRI, CONUP, CONLE, CONLE, BLANK, BLANK, CHIPO, VWALL,
        VWALL, BLANK, VWALL, CHIPO, CHIPO, CHIPO, START, CONUP, BLOCK, CHIPO, CHIPO, CHIPO, CHIPO, VWALL,
        VWALL, CHIPI, VWALL, CHIPO, CHIPO, CHIPO, CONRI, CONUP, CONLE, CONLE, BLANK, BLANK, CHIPO, VWALL,
        BLCOR, NUBRI, BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, NUBRI, CHIPO, CHIPO, CHIPO, CHIPO, NUBDO
    },{
        // Level 14
        CHIPO, BLANK, BLANK, BLANK, CHIPO, CHIPO, HEATB, CHIPO, CHIPO, BLANK, BLANK, BLANK, BLANK, CHIPO,
        CONDO, NUBLE, NUBRI, CONUP, NUBLE, NUBRI, CONDO, NUBLE, NUBRI, CONUP, NUBLE, HWALL, NUBRI, CONDO,
        BLANK, BLANK, BLANK, BLANK, CHIPO, CHIPO, BLANK, CHIPO, CHIPO, BLANK, BLANK, BLANK, BLANK, BLANK,
        HEATO, NUBLE, NUBRI, HEATI, TLCOR, NUBRI, CHIPO, NUBLE, TRCOR, HEATI, NUBLE, HWALL, NUBRI, HEATO,
        CHIPO, CHIPO, CHIPO, CHIPO, NUBDO, CHIPO, CHIPO, CHIPO, NUBDO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO,
        HEATB, CHIPO, CHIPO, HEATB, CONLE, CHIPO, CHIPO, CHIPO, CONRI, HEATB, CHIPO, CHIPO, CHIPO, HEATB,
        HEATO, NUBLE, NUBRI, HEATI, BLOCK, CHIPO, CHIPO, CHIPO, BLOCK, HEATO, NUBLE, HWALL, NUBRI, HEATI,
        BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, EXITS, BLANK, BLANK, BLANK, BLANK, START, BLANK, BLANK,
    },{
        // Level 15
        LEDOF, LEDOF, LEDOF, VWALL, BLANK, BLANK, BLANK, VWALL, BLANK, CHIPO, BLANK, CHIPO, BLANK, LEDOF,
        BLANK, START, BLANK, VWALL, BLANK, EXITS, BLANK, VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
        BLANK, BLANK, BLANK, VWALL, BLANK, BLANK, BLANK, BLCOR, NUBRI, VTROT, NUBLE, HWALL, NUBRI, CONDO,
        NUBRI, VTROT, NUBLE, BRCOR, BLANK, BLANK, BLANK, BLANK, BLANK, VTROT, BLANK, BLANK, BLANK, BLANK,
        BLANK, VTROT, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VTROT, BLANK, BLANK, BLANK, BLANK,
        NUBRI, VTROT, NUBLE, HWALL, HWALL, HWALL, HWALL, HWALL, NUBRI, VTROT, NUBLE, HWALL, NUBRI, CONUP,
        BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
        BLANK, CHIPO, BLANK, CHIPO, BLANK, CHIPO, BLANK, CHIPO, BLANK, CHIPO, BLANK, CHIPO, BLANK, LEDOF,
    },{
        // Level 16
        CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, EXITS,
        CONRI, CONRI, CONRI, CONRI, CONRI, CONRI, BLANK, CONRI, CONRI, CONDO, CONLE, CONLE, CONLE, CONLE,
        CONUP, NUBLE, TRCOR, CONUP, NUBLE, NUBRI, VTROT, NUBLE, NUBRI, CONDO, NUBLE, HWALL, NUBRI, CONUP,
        BLANK, ROTAB, NUBDO, CHIPO, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, HTROT, BLANK, BLANK, BLANK,
        BLANK, BLANK, HTROT, BLANK, BLANK, BLANK, START, BLANK, BLANK, CHIPO, NUBUP, BLANK, BLANK, BLANK,
        CONDO, NUBLE, NUBRI, CONUP, NUBLE, NUBRI, VTROT, NUBLE, NUBRI, CONDO, BLCOR, HWALL, NUBRI, CONDO,
        CONRI, CONRI, CONRI, CONUP, CONLE, CONLE, BLANK, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE,
        CHIPO, CHIPO, BLANK, CONLE, CONLE, CONLE, BLANK, CONRI, CONRI, CONRI, BLANK, CHIPO, CHIPO, CHIPO,
    },{
        // Level 17
        LEDOF, LEDOF, VWALL, LEDOF, LEDOF, LEDOF, VWALL, LEDOF, VWALL, LEDOF, LEDOF, NUBLE, HWALL, TRCOR,
        BLANK, BLANK, VWALL, BLANK, BLANK, BLANK, NUBDO, BLANK, VWALL, BLANK, BLANK, CHIPO, CHIPO, VWALL,
        BLANK, BLANK, VWALL, BLROT, HTROT, HTROT, HTROT, BLANK, VWALL, BLANK, BLANK, CHIPO, CHIPO, VWALL,
        BLANK, EXITS, VWALL, BLANK, BRROT, BLANK, NUBUP, BLANK, VWALL, BLANK, BLANK, CHIPO, CHIPO, VWALL,
        BLANK, BLANK, VWALL, BLROT, BRROT, TLCOR, BRCOR, BLANK, NUBDO, BRROT, BLANK, BLANK, BLANK, VWALL,
        BLANK, BLANK, VWALL, BLROT, BRROT, VWALL, BLANK, TLROT, BLANK, BLANK, TLCOR, NUBRI, CHIPO, NUBDO,
        BLANK, BLANK, NUBDO, BLANK, BLANK, BLCOR, TRCOR, BLANK, BLANK, BLANK, VWALL, BLANK, BLANK, BLANK,
        BLANK, BLANK, BLANK, BLANK, BLANK, LEDOF, VWALL, LEDOF, LEDOF, LEDOF, VWALL, BLANK, START, BLANK
    },{
        // Level 18
        NUBUP, BLANK, START, NUBUP, LEDOF, LEDOF, LEDOF, NUBLE, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR,
        VWALL, BLROT, TRROT, VWALL, BLANK, EXITS, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
        VWALL, BLROT, BRROT, BLCOR, HWALL, HWALL, HWALL, HWALL, TRCOR, CHIPO, CHIPO, NUBUP, CHIPO, VWALL,
        VWALL, CHIPO, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, VWALL, CHIPO, CHIPO, NUBDO, CHIPO, VWALL,
        VWALL, BLANK, BLANK, CHIPO, CONRI, CHIPO, BLANK, TRROT, VWALL, CHIPO, BLANK, CONLE, CONLE, VWALL,
        VWALL, BLROT, TRROT, BLANK, NUBLE, HWALL, HWALL, HWALL, BRCOR, CHIPO, CHIPO, BLOCK, CHIPO, VWALL,
        VWALL, BLROT, BRROT, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
        BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR,
    },{
        // Level 19
        NUBUP, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, START, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, NUBUP,
        VWALL, BLANK, BLOCK, CONDO, NUBLE, NUBRI, BLANK, NUBLE, NUBRI, CONDO, NUBLE, NUBRI, BLANK, VWALL,
        VWALL, BLANK, CHIPO, CONDO, CHIPO, CHIPO, BLANK, CHIPO, CHIPO, CONDO, CHIPO, CHIPO, BLANK, VWALL,
        NUBDO, BLANK, BLOCK, CONDO, NUBLE, NUBRI, BLANK, NUBLE, NUBRI, CONDO, NUBLE, NUBRI, BLANK, NUBDO,
        TLROT, BLANK, CHIPO, CONDO, CHIPO, CHIPO, BLANK, CHIPO, CHIPO, CONDO, CHIPO, CHIPO, BLANK, TRROT,
        VTROT, CONUP, BLOCK, CONDO, NUBLE, NUBRI, EXITS, NUBLE, NUBRI, CONDO, NUBLE, NUBRI, CONUP, VTROT,
        VTROT, CONUP, CONLE, CONLE, CONLE, CONLE, BLANK, CONRI, CONRI, CONRI, CONRI, CONRI, CONUP, VTROT,
        BLROT, HTROT, HTROT, HTROT, HTROT, HTROT, BLANK, HTROT, HTROT, HTROT, HTROT, HTROT, HTROT, BRROT,
    },{
        // Level 20
        VWALL, LEDOF, START, LEDOF, VWALL, CHIPO, CHIPO, VWALL, CHIPO, NUBDO, BLANK, NUBDO, LEDOF, LEDOF,
        BLCOR, NUBRI, BLANK, NUBLE, BRCOR, TLROT, HTROT, VWALL, BLANK, VTROT, BLANK, HEATO, BLANK, BLANK,
        BLANK, BLANK, BLANK, CHIPO, CHIPO, BLANK, BLANK, VWALL, HEATB, NUBUP, BLANK, NUBUP, BLANK, BLANK,
        BLANK, BLANK, BLANK, CHIPO, CHIPO, BLANK, BLANK, NUBDO, HEATI, NUBDO, BLANK, VWALL, CHIPO, CHIPO,
        BLANK, TRROT, BLANK, CHIPO, CHIPO, BLANK, BLANK, HEATB, BLANK, HEATI, BLANK, VWALL, CHIPO, CHIPO,
        NUBRI, VTROT, NUBLE, HWALL, HWALL, HWALL, HWALL, TRCOR, HEATI, BLANK, BLANK, VWALL, CHIPO, CHIPO,
        BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, ROTAB, VWALL, CHIPO, VTROT, BLANK, VWALL, BLANK, BLANK,
        CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, VWALL, CHIPO, CHIPO, NUBLE, BRCOR, EXITS, BLANK,
    },{
        // Level 21
        BLANK, BLANK, BLANK, EXITS, VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, START, BLANK, BLANK,
        NUBRI, HTROT, NUBLE, HWALL, BRCOR, BLANK, BLANK, TLCOR, HWALL, TRCOR, BLANK, BLANK, BLANK, BRROT,
        BLANK, VTROT, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL, LEDOF, VWALL, BLANK, NUBLE, NUBRI, BLANK,
        NUBRI, HTROT, BLOCK, CONUP, NUBUP, BLANK, BLANK, VWALL, BLANK, VWALL, CHIPO, CHIPO, CHIPO, CONUP,
        CHIPO, CHIPO, CHIPO, CHIPO, NUBDO, CHIPO, BLANK, VWALL, BLANK, VWALL, CHIPO, CHIPO, CONRI, CONUP,
        CHIPO, CHIPO, CHIPO, CHIPO, CONLE, CHIPO, BLANK, VWALL, LEDOF, VWALL, CHIPO, CHIPO, CHIPO, ROTAB,
        CHIPO, CHIPO, CHIPO, CHIPO, NUBUP, CHIPO, BLANK, BLCOR, HWALL, BRCOR, CHIPO, CHIPO, CHIPO, CONUP,
        CHIPO, CHIPO, CHIPO, CHIPO, VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, CHIPO, CHIPO, CONRI, CONUP,
    },{
        // Level 22
        BLANK, BLANK, BLANK, VWALL, LEDOF, LEDOF, VWALL, START, BLANK, BLANK, BLANK, CHIPO, CHIPO, CHIPO,
        BLANK, LEDOF, BLANK, VWALL, LEDOF, LEDOF, VWALL, BLANK, BLANK, NUBUP, BLANK, CHIPO, BLOCK, CHIPO,
        BLANK, BLANK, BLANK, VWALL, LEDOF, LEDOF, VWALL, BLANK, BLANK, NUBDO, BLANK, TRROT, BLANK, CHIPO,
        BLANK, CHIPI, BLANK, BLCOR, HWALL, HWALL, BRCOR, BLANK, CHIPO, CHIPO, BLANK, VTROT, NUBLE, TRCOR,
        BLANK, BLANK, BLANK, NUBUP, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, VTROT, CPUOU, VWALL,
        BLANK, CHIPI, BLANK, VWALL, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, BRROT, CHIPO, VWALL,
        BLANK, BLANK, BLANK, VWALL, CHIPO, CHIPO, BLOCK, CHIPO, CHIPO, TLCOR, HWALL, HWALL, HWALL, BRCOR,
        BLANK, CHIPI, BLANK, VWALL, BLANK, CHIPO, CHIPO, CHIPO, EXITS, VWALL, BLANK, BLANK, BLANK, BLANK,
    },{
        // Level 23
        TLCOR, HWALL, HWALL, HWALL, HWALL, TRCOR, BLANK, CHIPO, CHIPO, CHIPO, VWALL, CHIPO, CHIPO, CHIPO,
        VWALL, ROTAB, CHIPO, CHIPO, BLANK, NUBDO, BLANK, CHIPO, CHIPO, CHIPO, VWALL, CHIPO, HEATB, CHIPO,
        VWALL, BLANK, TLCOR, TRCOR, BLANK, VTROT, BLANK, CHIPO, CHIPO, BLANK, VWALL, CHIPO, CHIPO, NUBUP,
        VWALL, BLANK, VWALL, VWALL, BLANK, NUBLE, HWALL, NUBRI, CONDO, CONUP, NUBDO, CHIPO, CHIPO, VWALL,
        BRCOR, BLANK, BLCOR, BRCOR, BLANK, HTROT, BLANK, BLANK, BLANK, BLANK, HTROT, BLANK, BLANK, VWALL,
        BLANK, BLANK, CONRI, CONRI, BLANK, TLCOR, HWALL, NUBRI, HTROT, NUBLE, HWALL, NUBRI, HEATI, VWALL,
        START, BLANK, NUBLE, HWALL, HWALL, BRCOR, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
        EXITS, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, LEDOF, LEDOF, LEDOF, LEDOF, BLANK, BLANK, VWALL,
    },{
        // Level 24
        CHIPO, CHIPO, CHIPO, CHIPO, CONRI, BLANK, NUBUP, CHIPO, CHIPO, CHIPO, BLANK, CHIPO, CHIPO, CHIPO,
        HEATB, CHIPO, CHIPO, HEATB, NUBUP, HEATO, NUBDO, CHIPO, NUBLE, NUBRI, CONUP, CHIPO, LEDOF, CHIPO,
        CONUP, NUBLE, NUBRI, CONUP, VWALL, START, CHIPO, CONRI, CONRI, CONRI, BLANK, CHIPO, CHIPO, CHIPO,
        BLANK, CHIPO, CHIPO, BLANK, VWALL, BLANK, TLCOR, HWALL, HWALL, NUBRI, CONDO, NUBLE, NUBRI, CONDO,
        CONUP, NUBLE, NUBRI, CONUP, NUBDO, BLANK, NUBDO, CHIPO, CHIPO, BLANK, BLANK, CHIPO, CHIPO, BLANK,
        CHIPO, CHIPO, CHIPO, CHIPO, BLANK, BLROT, BLANK, CHIPO, CHIPO, CHIPO, BLANK, CHIPO, CHIPO, CHIPO,
        BLANK, BLANK, BLANK, BLANK, BLOCK, CONDO, NUBLE, HWALL, HWALL, NUBRI, BLANK, BLOCK, CHIPO, CHIPO,
        LEDOF, EXITS, LEDOF, BLANK, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CHIPO, BLANK,
    },{
        // Level 25
        CHIPO, CONDO, CHIPO, BLANK, CONLE, BLANK, BLANK, BLANK, CHIPO, CHIPO, BLANK, CHIPO, CHIPO, BLANK,
        CHIPO, BLANK, CHIPO, CHIPO, HTROT, HTROT, HTROT, TRROT, TLCOR, NUBRI, CONUP, NUBLE, NUBRI, BLANK,
        HWALL, NUBRI, VTROT, NUBLE, NUBRI, BLANK, NUBUP, CHIPO, VWALL, BLANK, BLANK, BLANK, BLANK, BLANK,
        EXITS, BLANK, VTROT, BLANK, BLANK, BLANK, VWALL, CHIPO, VWALL, CHIPO, BLANK, TLROT, BLANK, BLANK,
        HWALL, NUBRI, VTROT, NUBLE, TRCOR, BLANK, VWALL, CHIPO, VWALL, CHIPO, NUBUP, BLANK, NUBUP, BLANK,
        CHIPO, CHIPO, CHIPO, CHIPO, VWALL, BLANK, VWALL, CHIPO, NUBDO, CHIPO, NUBDO, BLANK, NUBDO, BLANK,
        CHIPO, BLANK, CONLE, CHIPO, NUBDO, BLANK, NUBDO, BLANK, START, BLANK, CONLE, BLANK, CONRI, BLANK,
        CHIPO, CHIPO, CHIPO, CHIPO, CONRI, BLANK, CONLE, BLANK, BLANK, BLANK, BLOCK, ROTAB, BLOCK, BLANK,
    },{
        // Level 26
        TLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR, LEDOF, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
        VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BRROT, BLROT, BRROT, BRROT, BRROT, BLANK,
        VWALL, BLANK, BLANK, TLROT, TLROT, TLROT, BLANK, BLANK, BRROT, HTROT, HTROT, HTROT, TRROT, BLANK,
        VWALL, BLANK, TRROT, VTROT, CHIPO, VTROT, TRROT, BLANK, BLROT, CHIPO, CHIPO, CHIPO, BRROT, BLANK,
        VWALL, BLANK, TRROT, VTROT, CHIPO, VTROT, TRROT, BLANK, BRROT, HTROT, HTROT, HTROT, BLROT, BLANK,
        VWALL, BLANK, BLANK, TLROT, TLROT, TLROT, BLANK, BLANK, TLROT, BRROT, BLROT, BRROT, BRROT, BLANK,
        VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
        BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR, LEDOF, BLANK, ROTAB, START, EXITS, BLANK, BLANK,
    },{
        // Level 27
        BLANK, BLANK, BLANK, CHIPO, BLANK, BLANK, HEATI, EXITS, BLANK, BLANK, BLANK, CHIPO, BLANK, BLANK,
        BLANK, NUBUP, CONUP, NUBLE, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR, BLANK,
        CHIPO, VWALL, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, ROTAB, CHIPO, VWALL, CHIPO,
        HTROT, VWALL, HEATB, CHIPO, CHIPO, CHIPO, CHIPO, START, CHIPO, CHIPO, CHIPO, HEATB, VWALL, BLANK,
        BLANK, VWALL, CHIPO, CHIPO, CHIPO, CHIPO, HEATB, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, VWALL, HTROT,
        CHIPO, VWALL, ROTAB, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, ROTAB, CHIPO, CHIPO, CHIPO, VWALL, CHIPO,
        BLANK, BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, NUBRI, CONDO, NUBDO, BLANK,
        BLANK, BLANK, CHIPO, BLANK, BLANK, BLANK, HEATO, BLANK, BLANK, BLANK, CHIPO, BLANK, BLANK, BLANK, 
    },{
        // Level 28
        CHIPO, CONRI, CHIPO, CHIPO, BLANK, BLANK, TRROT, EXITS, TLROT, BLANK, CHIPO, BLANK, CONLE, CHIPO,
        CHIPO, NUBLE, HWALL, NUBRI, HEATO, BLOCK, BLANK, NUBUP, BLANK, TLCOR, TRCOR, CHIPO, NUBUP, CHIPO,
        BLANK, CONLE, BLANK, BLANK, BLANK, CHIPO, CHIPO, NUBDO, BLANK, VWALL, NUBDO, BLANK, VWALL, CHIPO,
        CHIPO, NUBUP, HEATI, NUBLE, TRCOR, CHIPO, CHIPO, BLANK, BLANK, VWALL, HEATB, BLANK, VWALL, CHIPO,
        CHIPO, NUBDO, BLANK, CHIPO, BLCOR, HWALL, HWALL, NUBRI, BLANK, NUBDO, HEATI, NUBLE, BRCOR, CHIPO,
        BLANK, CONRI, BLANK, CHIPO, BLANK, CHIPO, BLANK, BLANK, BLANK, CHIPO, BLANK, BLANK, CONLE, BLANK,
        CHIPO, BLOCK, CONUP, NUBLE, HWALL, NUBRI, CONDO, NUBLE, HWALL, HWALL, HWALL, HWALL, NUBRI, BLANK,
        CHIPO, CHIPO, BLANK, BLANK, BLANK, BLANK, BLANK, START, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
    },{
        // Level 29
        BLANK, BLANK, BLANK, CONRI, START, HTROT, HTROT, HTROT, HTROT, HTROT, BLANK, CHIPO, CHIPO, ROTAB,
        CHIPO, CHIPO, CHIPO, BLOCK, HEATO, NUBLE, HWALL, HWALL, HWALL, NUBRI, BLANK, CHIPO, CHIPO, CHIPO,
        HEATB, BLANK, BLANK, CONLE, BLANK, CONLE, CHIPO, CHIPO, BLANK, HEATI, BLANK, BLANK, BLANK, BLANK,
        CHIPO, CHIPO, CHIPO, BLOCK, BLANK, NUBUP, CONDO, NUBUP, CONDO, NUBLE, NUBRI, VTROT, BLOCK, CONUP,
        HWALL, HWALL, HWALL, TRCOR, CONUP, NUBDO, CONDO, NUBDO, CONRI, CONRI, BLANK, BLANK, BLANK, BLANK,
        LEDOF, BLANK, BLANK, NUBDO, CONUP, BLANK, BLANK, BLANK, TRROT, TLROT, BLANK, CHIPO, CHIPO, CHIPO,
        EXITS, BLANK, BLANK, CONLE, CONLE, CHIPO, CHIPO, CHIPO, BLROT, BRROT, BLANK, CHIPO, CHIPO, CHIPO,
        LEDOF, BLANK, BLANK, NUBLE, NUBRI, CHIPO, CHIPO, CHIPO, CONRI, CONRI, BLANK, CHIPO, CHIPO, CHIPO,
    },{
        // Level 30
        BLANK, BLANK, BLANK, HEATI, BLANK, EXITS, BLANK, START, BLANK, BLANK, NUBLE, HWALL, HWALL, TRCOR,
        CHIPO, CHIPO, CHIPO, NUBUP, TLCOR, HWALL, HWALL, NUBRI, BLANK, HTROT, HTROT, HTROT, CHIPO, VWALL,
        HEATB, ROTAB, CHIPO, NUBDO, VWALL, CHIPO, BLANK, BLANK, BLANK, BLROT, HTROT, HTROT, BLANK, VWALL,
        CHIPO, CHIPO, CHIPO, BLANK, BLCOR, HWALL, HWALL, NUBRI, CONDO, NUBLE, HWALL, TRCOR, HEATO, VWALL,
        BLANK, TLCOR, TRCOR, BLANK, CONLE, CONLE, HEATB, CONLE, CONLE, LEDOF, LEDOF, VWALL, BLANK, VWALL,
        BLANK, VWALL, VWALL, BLANK, TLCOR, HWALL, HWALL, NUBRI, CONUP, NUBLE, HWALL, BRCOR, BLANK, VWALL,
        BLANK, BLCOR, BRCOR, CONUP, NUBDO, CHIPO, CHIPO, CHIPO, CHIPO, BLANK, CONRI, BLANK, CHIPO, VWALL,
        BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, NUBLE, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR,
    },{
        // Level 31
        CHIPO, CONRI, CHIPO, CHIPO, BLANK, BLANK, TRROT, EXITS, TLROT, BLANK, CHIPO, BLANK, CONLE, CHIPO,
        CHIPO, NUBLE, HWALL, NUBRI, HEATO, BLOCK, BLANK, NUBUP, BLANK, TLCOR, TRCOR, CHIPO, NUBUP, CHIPO,
        BLANK, CONLE, BLANK, BLANK, BLANK, CHIPO, CHIPO, NUBDO, BLANK, VWALL, NUBDO, BLANK, VWALL, CHIPO,
        CHIPO, NUBUP, HEATI, NUBLE, TRCOR, CHIPO, CHIPO, BLANK, BLANK, VWALL, HEATB, BLANK, VWALL, CHIPO,
        CHIPO, NUBDO, BLANK, CHIPO, BLCOR, HWALL, HWALL, NUBRI, BLANK, NUBDO, HEATI, NUBLE, BRCOR, CHIPO,
        BLANK, CONRI, BLANK, CHIPO, BLANK, CHIPO, BLANK, BLANK, BLANK, CHIPO, BLANK, BLANK, CONLE, BLANK,
        CHIPO, BLOCK, CONUP, NUBLE, HWALL, NUBRI, CONDO, NUBLE, HWALL, HWALL, HWALL, HWALL, NUBRI, BLANK,
        CHIPO, CHIPO, BLANK, BLANK, BLANK, BLANK, BLANK, START, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
    },{
        // Level 32
        HEATB, CHIPO, HEATO, HEATO, HEATO, HEATI, HEATI, BLANK, BLANK, HTROT, HTROT, HTROT, BLANK, CHIPO,
        HEATI, NUBLE, NUBRI, CHIPO, CHIPO, CHIPO, NUBUP, CHIPO, BLANK, CONRI, HEATB, CONRI, BLANK, NUBUP,
        HEATI, CHIPO, CHIPO, BLANK, BLANK, BLANK, BLCOR, NUBRI, HEATI, NUBLE, HWALL, NUBRI, VTROT, NUBDO,
        HEATO, CHIPO, CHIPO, BLANK, BLANK, BLANK, CHIPO, CHIPO, HEATI, BLANK, EXITS, BLANK, VTROT, CHIPO,
        HEATO, CHIPO, CHIPO, BLANK, START, BLANK, CHIPO, CHIPO, HEATI, BLANK, BLANK, BLANK, VTROT, CHIPO,
        HEATO, NUBLE, TRCOR, BLANK, BLANK, BLANK, TLCOR, NUBRI, HEATI, NUBLE, HWALL, NUBRI, VTROT, NUBUP,
        BLANK, CHIPO, NUBDO, CHIPO, CHIPO, CHIPO, NUBDO, CHIPO, BLANK, HTROT, HTROT, HTROT, BLANK, NUBDO,
        HEATB, BLANK, HEATI, HEATI, HEATI, HEATO, HEATO, BLANK, BLANK, CONLE, ROTAB, CONLE, BLANK, CHIPO,
    },{
        // Level 33
        LEDOF, EXITS, LEDOF, BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR,
        BLANK, START, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, HEATI, BLANK, HEATO, BLANK, CHIPO, VWALL,
        BLANK, BLANK, BLANK, BLANK, CONUP, NUBUP, CONUP, BLOCK, BLOCK, CPUOU, NUBUP, BLANK, CHIPO, VWALL,
        NUBUP, CONDO, TLCOR, TRCOR, HEATB, VWALL, BLANK, CONRI, CONRI, HEATB, VWALL, BLANK, CHIPO, VWALL,
        VWALL, CONDO, BLCOR, BRCOR, CONUP, VWALL, CHIPO, NUBUP, NUBUP, CPUOU, VWALL, CHIPO, CHIPO, VWALL,
        VWALL, BLANK, CHIPO, CHIPO, BLANK, NUBDO, VTROT, NUBDO, NUBDO, BLANK, NUBDO, CHIPO, CHIPO, VWALL,
        VWALL, CHIPO, CHIPO, CHIPO, BLANK, BLANK, HTROT, BLANK, HEATI, BLANK, HEATO, BLANK, BLANK, VWALL,
        BLCOR, HWALL, HWALL, NUBRI, BLROT, HTROT, BLANK, HTROT, HTROT, HTROT, HTROT, HTROT, BRROT, BLCOR,
    },{
        // Level 34
        CHIPO, BLANK, VTROT, VTROT, HTROT, VTROT, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
        CHIPO, ROTAB, NUBUP, BLANK, BLANK, BLANK, BLANK, TLCOR, HWALL, HWALL, TRCOR, CONUP, CHIPO, CHIPO,
        HWALL, NUBRI, VWALL, BLANK, BLANK, START, NUBLE, BRCOR, CHIPO, CHIPO, NUBDO, CONUP, CHIPO, CHIPO,
        CHIPO, CHIPO, BLCOR, HWALL, NUBRI, BLANK, BLANK, CHIPO, CHIPO, CHIPO, CHIPO, CONUP, CHIPO, CHIPO,
        CHIPO, CHIPO, CHIPO, CHIPO, BLANK, BLANK, NUBUP, CHIPO, CHIPO, HTROT, CHIPO, CONUP, CHIPO, CHIPO,
        CHIPO, CHIPO, TRROT, CHIPO, NUBUP, BLANK, VWALL, CHIPO, BLOCK, CHIPO, CHIPO, CONUP, CHIPO, CHIPO,
        CHIPO, CHIPO, CHIPO, CHIPO, NUBDO, BLANK, NUBDO, CHIPO, CHIPO, CHIPO, CHIPO, CONUP, ROTAB, CHIPO,
        CHIPO, CHIPO, CHIPO, CHIPO, BLANK, BLANK, BLANK, HTROT, HTROT, HTROT, HTROT, EXITS, LEDOF, LEDOF, 
    },{
        // Level 35
        CONRI, CONRI, CONRI, CONRI, CONRI, EXITS, NUBLE, HWALL, HWALL, HWALL, TRCOR, LEDOF, LEDOF, LEDOF,
        CONUP, TLCOR, HWALL, TRCOR, CHIPO, CHIPO, CHIPO, CHIPO, TLCOR, TRCOR, VWALL, BLANK, START, BLANK,
        CONUP, BLCOR, HWALL, BRCOR, CHIPO, CHIPO, ROTAB, CHIPO, BLCOR, BRCOR, NUBDO, BLANK, BLANK, BLANK,
        CONUP, BLOCK, CHIPO, CHIPO, VTROT, CHIPO, CHIPO, VTROT, CHIPO, CHIPO, BLOCK, BLANK, BLANK, BLANK,
        CONUP, BLANK, CHIPO, ROTAB, CHIPO, TLCOR, TRCOR, CHIPO, ROTAB, CHIPO, BLANK, BLANK, BLANK, BLANK,
        CONUP, NUBUP, CHIPO, CHIPO, CHIPO, BLCOR, BRCOR, CHIPO, CHIPO, CHIPO, NUBUP, CHIPO, CHIPO, CHIPO,
        CONUP, VWALL, ROTAB, CHIPO, HTROT, CHIPO, CHIPO, HTROT, CHIPO, CHIPO, VWALL, CHIPO, ROTAB, CHIPO,
        CONUP, BLCOR, HWALL, NUBRI, CHIPO, CONRI, CONRI, CHIPO, NUBLE, HWALL, BRCOR, CHIPO, CHIPO, CHIPO,
    },{
        // Level 36
        BLANK, BLANK, BLANK, CONRI, BLANK, CHIPO, CHIPO, BLANK, CONRI, BLANK, CHIPO, CHIPO, CHIPO, BLANK,
        VTROT, TLCOR, HWALL, TRCOR, CONDO, NUBLE, NUBRI, CONUP, TLCOR, HWALL, HWALL, HWALL, TRCOR, VTROT,
        VTROT, VWALL, CPUIN, VWALL, BLANK, CHIPO, CHIPO, CHIPO, VWALL, CPUIN, CPUIN, CPUIN, VWALL, VTROT,
        VTROT, VWALL, CPUIN, NUBDO, CHIPO, CHIPO, CHIPO, CHIPO, NUBDO, CPUIN, CPUIN, CPUIN, VWALL, VTROT,
        VTROT, BLCOR, HWALL, HWALL, NUBRI, CHIPO, NUBLE, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR, VTROT,
        BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
        HTROT, NUBLE, HWALL, NUBRI, BLANK, BLANK, BLANK, BLANK, NUBLE, HWALL, HWALL, HWALL, NUBRI, HTROT,
        ROTAB, CHIPO, BLANK, BLANK, BLANK, START, EXITS, BLANK, BLANK, BLANK, BLANK, BLANK, CHIPO, ROTAB
    },{
        // Level 37
        LEDOF, LEDOF, EXITS, LEDOF, LEDOF, VWALL, CONDO, BLOCK, CHIPO, HTROT, CHIPO, CHIPO, BLOCK, BLANK,
        CHIPO, BLANK, BLANK, BLANK, CHIPO, VWALL, CONDO, CONLE, CHIPO, CHIPO, ROTAB, CHIPO, CONLE, BLANK,
        HWALL, NUBRI, BLANK, NUBLE, HWALL, CPUIN, CONDO, NUBUP, CHIPO, CHIPO, CHIPO, CHIPO, BLOCK, BLANK,
        CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, VWALL, CONDO, VWALL, CHIPO, CHIPO, CHIPO, CHIPO, CONLE, BLANK,
        CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, VWALL, CONDO, VWALL, CHIPO, TRROT, CHIPO, CHIPO, NUBUP, BLANK,
        CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, VWALL, CONDO, NUBDO, CHIPO, CHIPO, VTROT, CHIPO, NUBDO, BLANK,
        HWALL, NUBRI, BLANK, NUBLE, HWALL, BRCOR, CONDO, CONLE, CHIPO, CHIPO, CHIPO, ROTAB, CONLE, BLANK,
        CONRI, CONRI, BLANK, CONLE, CONLE, CONLE, CONLE, BLOCK, CHIPO, CHIPO, CHIPO, CHIPO, BLOCK, START,
    },{
        // Level 38
        CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, HEATO, CONDO, NUBDO, CHIPO, TLCOR, HWALL, TRCOR, CHIPO, CHIPO,
        CHIPO, HEATI, CHIPO, BLOCK, CHIPO, NUBUP, CONDO, BLANK, BLANK, VWALL, BLANK, VWALL, HEATB, CHIPO,
        CHIPO, BLANK, BLROT, BLANK, CHIPO, NUBDO, CONDO, NUBUP, CHIPO, BLCOR, HWALL, BRCOR, CHIPO, CHIPO,
        CHIPO, BLOCK, CHIPO, BLANK, TRROT, BLANK, CONDO, VWALL, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO,
        CHIPO, HTROT, CHIPO, BLOCK, CHIPO, NUBUP, CONDO, NUBDO, CHIPO, BLOCK, HEATI, BLOCK, CHIPO, CHIPO,
        CHIPO, HTROT, CHIPO, HTROT, CHIPO, VWALL, CONDO, BLANK, BLANK, HEATO, CHIPO, HEATO, CHIPO, CHIPO,
        CHIPO, NUBLE, HWALL, NUBRI, CHIPO, NUBDO, CONDO, BLOCK, CHIPO, BLOCK, HEATI, BLOCK, CHIPO, CHIPO,
        BLANK, BLANK, BLANK, BLANK, BLANK, START, EXITS, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
    },{
        // Level 39
        TLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR, LEDOF,
        VWALL, BLANK, CHIPO, CHIPO, BLANK, BLANK, BLANK, START, BLANK, BLANK, CHIPO, CHIPO, VWALL, BLANK,
        VWALL, CONDO, TLCOR, HWALL, HWALL, NUBRI, BLANK, BLANK, NUBLE, HWALL, TRCOR, CHIPO, VWALL, BLANK,
        VWALL, CONDO, BLCOR, HWALL, NUBRI, TLROT, BRROT, BRROT, TRROT, NUBLE, BRCOR, BLANK, NUBDO, BLANK,
        VWALL, BLANK, BLANK, BLANK, BLANK, TRROT, BRROT, TRROT, BLROT, BLANK, BLANK, BLANK, BLANK, EXITS,
        VWALL, CONUP, TLCOR, HWALL, TRCOR, TRROT, TLROT, TRROT, BRROT, NUBLE, TRCOR, BLANK, NUBUP, BLANK,
        VWALL, CONUP, NUBDO, ROTAB, NUBDO, BLROT, TRROT, TRROT, BRROT, NUBLE, BRCOR, CHIPO, VWALL, BLANK,
        VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, CHIPO, CHIPO, VWALL, LEDOF,
    },{
        // Level 40
        BLANK, START, BLANK, BLANK, BLANK, BLANK, CHIPO, CHIPO, HEATB, HEATB, HEATB, TLCOR, HWALL, TRCOR,
        BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, CPUOU, BLOCK, CONDO, BLOCK, CONUP, NUBDO, ROTAB, VWALL,
        HEATI, HEATI, TLCOR, NUBRI, VTROT, BLOCK, CONRI, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
        CHIPO, CHIPO, VWALL, BLROT, BLANK, BLANK, CPUOU, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
        CHIPO, CHIPO, VWALL, HEATO, TLCOR, HWALL, HWALL, NUBRI, CONUP, NUBUP, CHIPO, CHIPO, CHIPO, VWALL,
        HEATO, HEATO, NUBDO, BLANK, VWALL, CHIPO, BLANK, BLANK, BLROT, NUBDO, CHIPO, CHIPO, CHIPO, VWALL,
        BLANK, BLANK, BLANK, BLANK, VWALL, ROTAB, NUBLE, NUBRI, BLANK, CONLE, CHIPO, CHIPO, CHIPO, VWALL,
        BLANK, BLANK, EXITS, BLANK, VWALL, CHIPO, BLANK, BLANK, BLANK, NUBLE, HWALL, HWALL, HWALL, BRCOR
    },{
        // Level 41
        CHIPO, CONRI, BLANK, CHIPO, BLANK, TLCOR, HWALL, HWALL, TRCOR, EXITS, TLCOR, HWALL, HWALL, NUBRI,
        BLANK, NUBLE, NUBRI, CONDO, HEATI, NUBDO, BLANK, START, VWALL, BLANK, NUBDO, BLANK, BLANK, BLANK,
        ROTAB, HEATB, CHIPO, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL, BLANK, BLANK, TRROT, NUBUP, BLANK,
        CONRI, CONUP, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL, BLANK, TLROT, BLANK, VWALL, BLANK,
        NUBUP, CONUP, NUBLE, HWALL, HWALL, NUBRI, TRROT, BLANK, BLCOR, TRCOR, BLANK, BLANK, VWALL, BLANK,
        VWALL, CONUP, BLANK, BLANK, TLROT, BLANK, BLANK, TLCOR, HWALL, BRCOR, HEATO, NUBLE, BRCOR, BLANK,
        VWALL, CONUP, BLANK, CHIPO, HTROT, BRROT, NUBLE, BRCOR, CHIPO, CHIPO, BLANK, CHIPO, CHIPO, BLANK,
        VWALL, CONUP, BLANK, CHIPO, BLROT, BLANK, BLANK, BLANK, CHIPO, CHIPO, BLANK, CHIPO, CHIPO, BLANK,
    },{
        // Level 42
        CHIPO, CHIPO, BLANK, CHIPO, HEATI, BLANK, CONLE, CHIPO, BLANK, HEATB, BLANK, EXITS, BLANK, BLANK,
        CHIPO, CHIPO, BLANK, CHIPO, NUBUP, CHIPO, NUBUP, CHIPO, BLANK, NUBLE, HWALL, HWALL, TRCOR, CONUP,
        CHIPO, CHIPO, BLANK, CHIPO, VWALL, CHIPO, VWALL, CHIPO, CHIPO, CONRI, BLANK, CHIPO, VWALL, CONUP,
        CHIPO, CHIPO, BLANK, CHIPO, VWALL, CHIPO, VWALL, CHIPO, CHIPO, NUBUP, CHIPO, CHIPO, VWALL, CONUP,
        CONDO, VTROT, NUBLE, HWALL, BRCOR, CHIPO, BLCOR, NUBRI, CHIPO, BLCOR, NUBRI, CONDO, NUBDO, CONUP,
        BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, HEATO, BLANK, BLANK, BLANK,
        NUBRI, VTROT, NUBLE, HWALL, NUBRI, CHIPO, NUBLE, HWALL, HWALL, HWALL, NUBRI, CONUP, NUBLE, HWALL,
        START, BLANK, CHIPO, CHIPO, HEATI, BLANK, CONRI, BLANK, CHIPO, CHIPO, BLANK, BLANK, BLANK, CHIPO,
    },{
        // Level 43
        CHIPO, CHIPO, CHIPO, CONRI, BLANK, CONLE, BLANK, CONRI, BLANK, CHIPO, CHIPO, HEATO, CHIPO, CHIPO,
        CHIPO, CHIPO, CHIPO, HEATO, BLANK, NUBUP, CHIPO, NUBUP, BLANK, CHIPO, CHIPO, NUBUP, CHIPO, CHIPO,
        CHIPO, HEATB, CHIPO, NUBUP, BLANK, NUBDO, CHIPO, NUBDO, CONDO, CHIPO, CHIPO, NUBDO, CHIPO, CHIPO,
        CHIPO, CHIPO, CHIPO, VWALL, BLANK, CONRI, BLANK, CONLE, BLANK, CHIPO, HEATB, CHIPO, HEATI, BLANK,
        CONDO, HEATI, NUBLE, BRCOR, CONUP, TLCOR, HWALL, TRCOR, CHIPO, CHIPO, CHIPO, CHIPO, NUBUP, CHIPO,
        CHIPO, CHIPO, CHIPO, BLANK, BLANK, NUBDO, EXITS, NUBDO, BLANK, TLCOR, NUBRI, HEATI, NUBDO, CHIPO,
        CHIPO, CHIPO, CHIPO, CHIPO, BLANK, HTROT, BLANK, HTROT, BLANK, NUBDO, CHIPO, CHIPO, CHIPO, CHIPO,
        CHIPO, CHIPO, CHIPO, BLANK, BLANK, NUBUP, START, NUBUP, BLANK, HEATO, BLANK, CHIPO, CHIPO, HEATB,
    },{
        // Level 44
        LEDOF, LEDOF, VWALL, BLANK, CONRI, ROTAB, HEATI, CONRI, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
        LEDOF, LEDOF, VWALL, BLANK, NUBLE, HWALL, HWALL, NUBRI, BLANK, NUBUP, CONDO, CHIPO, NUBUP, HEATI,
        HWALL, HWALL, BRCOR, BLANK, CONLE, CONLE, CONLE, CONLE, BLANK, NUBDO, BLANK, CHIPO, VWALL, CHIPO,
        BLANK, CHIPO, BLANK, BLANK, TLCOR, HWALL, HWALL, NUBRI, CHIPO, HTROT, BLANK, CHIPO, VWALL, ROTAB,
        CONDO, TLCOR, NUBRI, VTROT, VWALL, HEATB, CHIPO, TRROT, CHIPO, NUBLE, HWALL, HWALL, BRCOR, CHIPO,
        CHIPO, NUBDO, BLANK, BLANK, VWALL, CHIPO, CHIPO, BLROT, CHIPO, CONRI, ROTAB, CONLE, CHIPO, CHIPO,
        CONDO, HEATI, BLANK, BLANK, BLCOR, HWALL, HWALL, NUBRI, CHIPO, BLOCK, CONDO, NUBUP, CHIPO, CHIPO,
        HEATB, HEATI, BLANK, EXITS, BLANK, CONLE, HEATB, CONLE, BLANK, HTROT, START, BLCOR, HWALL, NUBRI
    },{
        // Level 45
        BLANK, CHIPO, CHIPO, HEATB, BLANK, CPUOU, BLANK, BLROT, HTROT, HTROT, HEATB, CHIPO, CHIPO, CHIPO,
        BLANK, CHIPO, CHIPO, CHIPO, CHIPO, NUBUP, BLANK, BLANK, NUBUP, BLANK, ROTAB, CHIPO, CHIPO, BLANK,
        CPUOU, NUBLE, HWALL, HWALL, HWALL, BRCOR, CPUOU, NUBLE, BRCOR, CONDO, CONUP, NUBLE, NUBRI, BLANK,
        BLANK, BLANK, BLANK, BLANK, BLANK, CPUOU, START, EXITS, CPUOU, BLANK, BLANK, BLANK, BLANK, BLANK,
        HEATO, NUBLE, NUBRI, CONUP, NUBLE, TRCOR, CPUOU, TLCOR, HWALL, NUBRI, VTROT, NUBLE, NUBRI, VTROT,
        BLANK, CHIPO, HEATI, HEATO, BLANK, VWALL, BLANK, VWALL, HEATB, CONLE, TLROT, BLANK, TLROT, BLANK,
        ROTAB, CHIPO, HEATI, CHIPO, BLANK, NUBDO, BLANK, NUBDO, CONDO, CHIPO, CHIPO, CHIPO, CHIPO, HTROT,
        CHIPO, CHIPO, HEATI, CHIPO, BLANK, CONLE, BLANK, HTROT, BLANK, CHIPO, CHIPO, BLANK, HTROT, CHIPO,
    },{
        // Level 46
        CHIPO, CHIPO, HTROT, BLANK, VWALL, VWALL, VWALL, CHIPO, VWALL, VWALL, BLANK, BLROT, CHIPO, HEATB,
        CHIPO, ROTAB, TLROT, BLANK, NUBDO, NUBDO, NUBDO, START, NUBDO, NUBDO, BLANK, BRROT, CHIPO, ROTAB,
        CHIPO, CHIPO, VTROT, BLANK, BLANK, BLANK, CHIPO, BLANK, CHIPO, BLANK, BLANK, HTROT, CHIPO, CHIPO,
        HEATI, HEATI, BLANK, BLANK, NUBUP, CONDO, BLOCK, CHIPO, BLOCK, CONDO, HEATI, BLANK, BLOCK, BLOCK,
        CHIPO, CHIPO, BRROT, BLANK, VWALL, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, NUBUP, BLANK, CHIPO, CHIPO,
        ROTAB, CHIPO, TRROT, BLANK, BLCOR, TRCOR, BRROT, CHIPO, TLROT, TLCOR, BRCOR, CHIPO, CHIPO, ROTAB,
        CHIPO, CHIPO, TRROT, BLANK, NUBUP, BLCOR, TRCOR, EXITS, TLCOR, BRCOR, NUBUP, CHIPO, CHIPO, CHIPO,
        HWALL, TRCOR, BLANK, BLANK, VWALL, NUBUP, VWALL, NUBUP, VWALL, NUBUP, VWALL, BLANK, CONLE, CONLE, 
    } ,
    {
        // Level 47
        BLANK, CONLE, CONLE, CONLE, CONLE, CONLE, BLANK, CONLE, CONLE, CONLE, BLANK, BLANK, BLANK, BLANK,
        BLANK, BLOCK, HEATB, EXITS, ROTAB, BLOCK, CHIPO, BLOCK, BLOCK, BLOCK, BLOCK, CONUP, BLOCK, HEATO,
        BLANK, BLOCK, BLANK, START, BLANK, BLOCK, BLANK, BLANK, CHIPO, BLOCK, BLANK, BLANK, BLOCK, CHIPO,
        BLANK, CONRI, CONRI, BLANK, CONRI, CONRI, BLANK, BLANK, CHIPO, BLOCK, BLANK, BLANK, BLOCK, CHIPO,
        BLANK, BLOCK, BLOCK, VTROT, BLOCK, BLOCK, BLOCK, BLOCK, BLOCK, BLOCK, BLANK, BLANK, BLOCK, BLANK,
        BLROT, BLANK, BLANK, BLANK, BLANK, BLANK, CONRI, BLANK, BLANK, BLANK, BLANK, BLANK, HEATI, BLANK,
        BLANK, BLOCK, BLOCK, BLOCK, BLOCK, CHIPO, BLOCK, BLOCK, BLOCK, BLOCK, BLOCK, CHIPO, BLOCK, CHIPO,
        BLROT, BLANK, HEATI, CHIPO, CHIPO, CHIPO, CHIPO, CHIPO, HEATI, BLANK, BLANK, BLANK, BLANK, BLANK,
    },{
        // Level 48
        HEATB, ROTAB, BLANK, VTROT, TRROT, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, CHIPO, CHIPO, CHIPO,
        CHIPO, NUBLE, HWALL, NUBRI, BLANK, BLANK, TRROT, BRROT, NUBUP, BLANK, BLANK, CHIPO, HEATB, HTROT,
        BLOCK, TRROT, VTROT, BRROT, BLANK, NUBUP, TLROT, BRROT, NUBDO, BLANK, NUBUP, CHIPO, CHIPO, CHIPO,
        CHIPO, BLANK, TRROT, BRROT, BLANK, VWALL, BLANK, TRROT, BLANK, BLANK, BLCOR, HWALL, NUBRI, CONDO,
        NUBUP, HTROT, HTROT, TLROT, BLANK, VWALL, TLROT, VTROT, NUBUP, BLANK, CONLE, CONLE, CONLE, ROTAB,
        NUBDO, TLROT, VTROT, VTROT, BLANK, VWALL, HTROT, TRROT, VWALL, BLANK, HEATI, CHIPO, CHIPO, HEATI,
        CHIPO, NUBLE, HWALL, NUBRI, BLANK, VWALL, BLANK, BRROT, VWALL, BLANK, NUBLE, HWALL, HWALL, NUBRI,
        BLANK, ROTAB, VTROT, HEATI, BLANK, VWALL, TLROT, CHIPO, VWALL, BLANK, BLANK, BLANK, START, EXITS,
    },{
        // Level 49
        BLANK, BLANK, BLANK, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, CONLE, VWALL,
        BLANK, ROTAB, BLANK, TRROT, TLROT, TLROT, TLROT, HTROT, TLROT, HTROT, BLROT, TLROT, CONUP, VWALL,
        BLANK, START, BLANK, TLROT, TRROT, BLROT, VTROT, TLROT, BRROT, TLROT, BLROT, TRROT, CONUP, VWALL,
        BLANK, BLANK, BLANK, BRROT, TRROT, HTROT, BLANK, BLANK, TRROT, ROTAB, BLANK, HTROT, CONUP, VWALL,
        HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, NUBRI, TRROT, HTROT, CONUP, VWALL,
        BLANK, BLANK, BLANK, LEDOF, TLROT, TRROT, TLROT, HTROT, HTROT, HTROT, HTROT, BRROT, CONUP, VWALL,
        EXITS, BLANK, BLANK, CHIPO, BLROT, BLROT, BRROT, TRROT, CONRI, CONRI, CONRI, CONRI, CONUP, VWALL,
        BLANK, BLANK, BLANK, LEDOF, BLROT, BLROT, BRROT, BRROT, TLCOR, HWALL, HWALL, HWALL, HWALL, BRCOR,
    },{
        // Level 50
        BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK,
        NUBRI, VTROT, NUBLE, HWALL, HWALL, HWALL, HWALL, HWALL, NUBRI, VTROT, NUBLE, NUBRI, CHIPO, CHIPO,
        BLANK, BLANK, BLANK, CONRI, BLANK, CONLE, BLANK, CHIPO, CHIPO, BLANK, CONLE, CHIPO, CHIPO, CHIPO,
        CHIPO, ROTAB, CHIPO, NUBUP, CHIPO, NUBUP, CHIPO, CHIPO, CHIPO, CHIPO, BLOCK, CHIPO, ROTAB, CHIPO,
        CHIPO, CHIPO, CHIPO, VWALL, CONDO, VWALL, CHIPO, CHIPO, CHIPO, CHIPO, CONRI, BLANK, CHIPO, CHIPO,
        CHIPO, VTROT, CHIPO, VWALL, CONDO, VWALL, CHIPO, TLROT, HTROT, CHIPO, TLCOR, NUBRI, CHIPO, NUBUP,
        NUBRI, VTROT, NUBLE, BRCOR, CONDO, BLCOR, NUBRI, VTROT, VTROT, NUBLE, BRCOR, BLANK, BLANK, VWALL,
        EXITS, BLANK, BLANK, BLANK, BLANK, BLANK, START, BLANK, BLANK, BLANK, BLANK, BLANK, NUBLE, BRCOR
    }
};

unsigned char currentmap[112] = {   //14x8 Tiles
    TLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, TRCOR,
    VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
    VWALL, BLANK, START, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
    VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
    VWALL, BLANK, BLANK, EXITS, BLANK, CHIPO, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
    VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
    VWALL, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, BLANK, VWALL,
    BLCOR, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, HWALL, BRCOR
};

void printmenuitem(int8_t menuitem, int8_t y) {
    arduboy.setCursor(68, y);
    if(menuitem > -5 && menuitem < 50) {
        if(menuitem == -4) {
            arduboy.printf("Erase Data");
        } else if(menuitem == -3) {
            arduboy.printf("Sound: ");
            if(soundon) {
                arduboy.printf("On");
            } else {
                arduboy.printf("Off");
            }
        } else if(menuitem == -2) {
            arduboy.printf("Credits");
        } else if(menuitem == -1) {
            arduboy.printf("Help");
        } else {
            arduboy.printf("Level ");
            arduboy.printf("%d",(int)(menuitem + 1));
            if(menuitem > maxlevel) {
                arduboy.drawBitmap(118, y, lock, 5, 8, WHITE);
            }
        }
    }
}

void drawtitle() {
    arduboy.drawBitmap(0, 0, title, 128, 64, WHITE);
    if(220 <= frame && frame < 225) {
        arduboy.drawBitmap(17, 21, eyes2, 32, 16, WHITE);
    } else if(225 <= frame && frame < 230) {
        arduboy.drawBitmap(17, 21, eyes3, 32, 16, WHITE);
    } else if(230 <= frame && frame < 235) {
        arduboy.drawBitmap(17, 21, eyes2, 32, 16, WHITE);
    } else if(235 <= frame && frame < 240) {
        arduboy.drawBitmap(17, 21, eyes1, 32, 16, WHITE);
    } else if(240 <= frame && frame < 245) {
        arduboy.drawBitmap(17, 21, eyes2, 32, 16, WHITE);
    } else if(245 <= frame && frame < 250) {
        arduboy.drawBitmap(17, 21, eyes3, 32, 16, WHITE);
    } else if(250 <= frame && frame < 255) {
        arduboy.drawBitmap(17, 21, eyes2, 32, 16, WHITE);
    } else {
        arduboy.drawBitmap(17, 21, eyes1, 32, 16, WHITE);
    }
}

void drawlevel() {
    int currentspot = 0;
    for (int y = 0; y < 8; y++) {
        for (int x = 0; x < 14; x++) {
            if(currentmap[currentspot] >= 21 && currentmap[currentspot] <= 24) {
                arduboy.drawBitmap(x * 8, y * 8, spritesheet[currentmap[currentspot] + animation / 2 * 4], 8, 8, WHITE);
            } else if(currentmap[currentspot] < 50) {
                if(currentmap[currentspot] == EXITS) {
                    if(levelcomplete) {
                        arduboy.drawBitmap(x * 8, y * 8, spritesheet[38 + animation / 2], 8, 8, WHITE);
                    } else {
                        arduboy.drawBitmap(x * 8, y * 8, spritesheet[38], 8, 8, WHITE);
                    }
                } else if(currentmap[currentspot] == 12) {
                    if(levelcomplete) {
                        arduboy.drawBitmap(x * 8, y * 8, spritesheet[13], 8, 8, WHITE);
                    } else {
                        arduboy.drawBitmap(x * 8, y * 8, spritesheet[12], 8, 8, WHITE);
                    }
                } else {
                    arduboy.drawBitmap(x * 8, y * 8, spritesheet[currentmap[currentspot]], 8, 8, WHITE);
                }
            }
            currentspot += 1;
        }
    }
}

#define NOISECONVEYER 100
#define NOISEMENU 300
#define NOISEMENUCLICK 350
#define NOISEEXPLOSION1 600
#define NOISEEXPLOSION2 700
#define NOISEEXPLOSION3 400
#define NOISEEXPLOSION4 100
#define NOISEHEATBUTTON 350
#define NOISEROTATEBUTTON 425
#define NOISEROTATE 250
#define NOISECPUOUT 140
#define NOISECHIPOUT 475
#define NOISELEVELCOMPLETE 700
void sound(int pitch, long duration) {
    if(soundon) {
        //arduboy.tunes.tone(pitch, duration);
    }
}


void continuestate(int8_t tostate) {
    if(arduboy.pressed(A_BUTTON) && menubuttonfree) {
        sound(NOISEMENUCLICK, 100);
        gamestate = tostate;
        menubuttonfree = false;
    }
}

void loadlevel(int givenlevel) {
    //digitalWrite(RED_LED, OFF);
    //digitalWrite(GREEN_LED, OFF);
        levelcompletecounter = 0;
    if(givenlevel == 50) {
        gamestate = 6;
    } else {
        if(givenlevel > maxlevel) {
            maxlevel = givenlevel;
            //EEPROM.put(SAVELOCATION, maxlevel);
        }
        levelcomplete = false;
        level = givenlevel;
        canswitch = true;
        deathcounter = 0;
        for (int i = 0; i < sizeof(currentmap) / sizeof(currentmap[0]); i++) {
            currentmap[i] = levelmap[givenlevel][i];
            if(currentmap[i] == 51) {
                playery = i / 14 * 8;
                playerx = (i - (i / 14) * 14)  * 8;
                playertoy = playery;
                playertox = playerx;
            }
        }
        animation = 0;
        frame = 0;
        levelcomplete = false;
        temperature = 0;
    }
}

bool checkcollision(int8_t locx, int8_t locy) {
    int8_t leftright = locx * 8 - playerx;    //0 = Up/Down, - = Left, + = Right
    int8_t updown = locy * 8 - playery;       //0 = Left/Right, - = Up, + = Down
    int8_t tile = currentmap[locx + locy * 14];
    if(locx < 0 || locy < 0 || locx >= 14 || locy >= 8) {
        return false;
    }
    if(tile <= 15) {
        return false;
    }
    if(leftright < 0) {
        if(tile == CONRI || tile == VTROT || tile == TRROT || tile == BRROT) {
        return false;
        }
    }
    if(leftright > 0) {
        if(tile == CONLE || tile == VTROT || tile == TLROT || tile == BLROT) {
            return false;
        }
    }
    if(updown > 0) {
        if(tile == CONUP || tile == HTROT || tile == TLROT || tile == TRROT) {
            return false;
        }
    }
    if(updown < 0) {
        if(tile == CONDO || tile == HTROT || tile == BLROT || tile == BRROT) {
            return false;
        }
    }
    return true;
}

void checklocation(int8_t locx, int8_t locy) {
    switch(currentmap[locx + locy * 14]) {
        case CONUP:
            playertoy -= 8;
            transitionanimation = 9;
            gamebuttonfree = false;
            sound(NOISECONVEYER, 230);
            break;
        case CONDO:
            playertoy += 8;
            transitionanimation = 9;
            gamebuttonfree = false;
            sound(NOISECONVEYER, 230);
            break;
        case CONLE:
            playertox -= 8;
            transitionanimation = 9;
            gamebuttonfree = false;
            sound(NOISECONVEYER, 230);
            break;
        case CONRI:
            playertox += 8;
            transitionanimation = 9;
            gamebuttonfree = false;
            sound(NOISECONVEYER, 230);
            break;
        case CHIPO:
            sound(NOISECHIPOUT, 100);
            currentmap[locx + locy * 14] = 11;
            break;
        case EXITS:
            if(levelcomplete) {
            sound(NOISELEVELCOMPLETE, 400);
                loadlevel(level + 1);
            }
            break;
        case CPUOU:
            sound(NOISECPUOUT, 150);
            currentmap[locx + locy * 14] = 14;
            break;
            case HEATB:
            if(canswitch) {
                sound(NOISEHEATBUTTON, 150);
                swapall(HEATO, HOLD);
                swapall(HEATI, HEATO);
                swapall(HOLD, HEATI);
                canswitch = false;
            }
            break;
        case ROTAB:
            if(canswitch) {
                sound(NOISEROTATEBUTTON, 150);
                swapall(BRROT, HOLD);
                swapall(TRROT, BRROT);
                swapall(TLROT, TRROT);
                swapall(BLROT, TLROT);
                swapall(HOLD, BLROT);
                swapall(VTROT, HOLD);
                swapall(HTROT, VTROT);
                swapall(HOLD, HTROT);
                canswitch = false;
            }
            break;
    }
}

void rotateinplace(int8_t index) {
    if(currentmap[index] == BRROT) {
        currentmap[index] = BLROT;
        sound(NOISEROTATE, 150);
        return;
    }
    if(currentmap[index] == TRROT) {
        sound(NOISEROTATE, 150);
        currentmap[index] = BRROT;
        return;
    }
    if(currentmap[index] == TLROT) {
        sound(NOISEROTATE, 150);
        currentmap[index] = TRROT;
        return;
    }
    if(currentmap[index] == BLROT) {
        sound(NOISEROTATE, 150);
        currentmap[index] = TLROT;
        return;
    }
    if(currentmap[index] == HTROT) {
        sound(NOISEROTATE, 150);
        currentmap[index] = VTROT;
        return;
    }
    if(currentmap[index] == VTROT) {
        sound(NOISEROTATE, 150);
        currentmap[index] = HTROT;
        return;
    }
}

void swapall(int8_t from, int8_t to) {
    for (int i = 0; i < sizeof(currentmap) / sizeof(currentmap[0]); i++) {
        if(currentmap[i] == from) {
            currentmap[i] = to;
        }
    }
}

void checkcompletion() {
    boolean gotemcoach = true;
    for (int i = 0; i < sizeof(currentmap) / sizeof(currentmap[0]); i++) {
        if(currentmap[i] == 37) {
            gotemcoach = false;
        }
    }
    levelcomplete = gotemcoach;
    if(levelcomplete && levelcompletecounter >= 0) {
        levelcompletecounter--;
        //digitalWrite(GREEN_LED, ON);
    } else {
        //digitalWrite(GREEN_LED, OFF);
        if(levelcompletecounter == 0) {
            levelcompletecounter = 75;
        }
    }
}

void setup() {
    led3 = 1;
    arduboy.begin();
    arduboy.setFrameRate(60);
    arduboy.display();
    //EEPROM.get(SAVELOCATION, maxlevel);
    if(maxlevel > 49) {
        maxlevel = 49;
    }
    if(maxlevel < 0) {
        maxlevel = 0;
    }
    levelchecker = maxlevel;
    //maxlevel = 49;
    //levelchecker = 0;
    arduboy.clear();
}

void loop() {
    if(!(arduboy.nextFrame())) {
        return;
    }
    
    frame++;
    if(frame > 260) {
        frame = 0;
    }
    if(frame % 2) {
        animation++;
        if(transitionanimation > 0) {
            transitionanimation -= 1;
            temperature = 0;
        }
    }
    
    if(animation > 7) {
        animation = 0;
    }
    
    arduboy.clear();

    switch(gamestate) {
        case 0: //Credits Screen
            arduboy.drawBitmap(8, 8, me, 48, 48, WHITE);
            arduboy.setCursor(75, 8);
            arduboy.printf("Jonathan");
            arduboy.setCursor(87, 18);
            arduboy.printf("Holmes");
            arduboy.setCursor(86, 38);
            arduboy.printf("@crait");
            arduboy.setCursor(68, 49);
            arduboy.printf("crait.net");
            continuestate(1);
            break;
        case 1: //Title Screen
            drawtitle();
            continuestate(2);
            break;
        case 2: //Main Menu
            frame++;
            drawtitle();
            arduboy.fillRect(64, 0, 64, 64, BLACK);
            arduboy.fillRect(51, 1, 12, 17, WHITE);
            if(levelchecker >= 50 || levelchecker <= -5) {
                levelchecker = 0;
            }
            if(arduboy.notPressed(DOWN_BUTTON) && arduboy.notPressed(UP_BUTTON)) {
                menubuttoncounter = 0;
            }
            if(menubuttoncounter > 10) {
                menubuttonfree = true;
            }
            if(arduboy.pressed(DOWN_BUTTON)) {
                menubuttoncounter++;
                if(menubuttonfree && levelchecker != 49) {
                    menubuttonfree = false;
                    levelchecker += 1;
                    sound(NOISEMENU, 100);
                }
            }
            if(arduboy.pressed(UP_BUTTON)) {
                menubuttoncounter++;
                if(menubuttonfree && levelchecker != -4) {
                    menubuttonfree = false;
                    levelchecker -= 1;
                    sound(NOISEMENU, 100);
                }
            }
            if(arduboy.pressed(A_BUTTON) && menubuttonfree) {
                sound(NOISEMENUCLICK, 100);
                menubuttonfree = false;
                if(levelchecker == -4) {
                    gamestate = 4;
                    maxlevel = 0;
                    //EEPROM.put(SAVELOCATION, maxlevel);
                } else if(levelchecker == -3) {
                    soundon = !soundon;
                } else if(levelchecker == -2) {
                    gamestate = 0;
                } else if(levelchecker == -1) {
                    gamestate = 3;
                } else {
                    if(levelchecker <= maxlevel) {
                        gamestate = 5;
                        loadlevel(levelchecker);
                    }
                }
            }
            printmenuitem(levelchecker - 2, 2);
            printmenuitem(levelchecker - 1, 10);
            arduboy.drawLine(64, 19, 128, 19, WHITE);
            arduboy.drawLine(64, 20, 128, 20, WHITE);
            arduboy.drawLine(64, 31, 128, 31, WHITE);
            arduboy.drawLine(64, 32, 128, 32, WHITE);
            printmenuitem(levelchecker, 22);
            printmenuitem(levelchecker + 1, 34);
            printmenuitem(levelchecker + 2, 42);
            printmenuitem(levelchecker + 3, 50);
          //  printmenuitem(levelchecker + 4, 58);
            break;
        case 3: //Instruction Screen
            arduboy.setCursor(0, 0);
            arduboy.printf("     Instructions");
            arduboy.setCursor(0, 18);
            arduboy.printf("    Find all sockets");
            arduboy.setCursor(0, 28);
            arduboy.printf("    Insert components");
            arduboy.setCursor(0, 38);
            arduboy.printf("    Proceed to exit");
            arduboy.drawBitmap(6, 18, spritesheet[CHIPO], 8, 8, WHITE);
            arduboy.drawBitmap(6, 28, spritesheet[CHIPI], 8, 8, WHITE);
            arduboy.drawBitmap(6, 38, spritesheet[38 + animation % 4], 8, 8, WHITE);
            continuestate(31);
            break;
        case 31: //Controls
            arduboy.setCursor(0, 0);
            arduboy.printf("       Controls");
            arduboy.setCursor(0, 18);
            arduboy.printf(" D-Pad: Move Around");
            arduboy.setCursor(0, 28);
            arduboy.printf("Hold A: Restart Level");
            continuestate(2);
            break;
    case 4: //Erased
            arduboy.setCursor(0, 0);
            arduboy.printf("       Complete\n\n");
            arduboy.printf("All saved data was\n");
            arduboy.printf("erased...");
            continuestate(2);
            break;
    case 5: //Game
            arduboy.drawBitmap(112, 0, side, 16, 64, WHITE);
            arduboy.drawBitmap(112, 56, signals[animation / 2], 16, 8,  WHITE);
            if(level >= 9) {
                arduboy.setCursor(114, 29);
            } else {
                arduboy.setCursor(117, 29);
            }
            arduboy.printf("%d",(int)(level + 1));
            drawlevel();
            if(transitionanimation == 0 && gamebuttonfree) {
                int8_t index = playerx / 8 + playery / 8 * 14;
                if(gamebuttonfree && arduboy.pressed(UP_BUTTON) && checkcollision(playerx / 8, (playery - 8) / 8) && currentmap[index] != HTROT && currentmap[index] != TLROT && currentmap[index] != TRROT) {
                    rotateinplace(index);
                    playertoy -= 8;
                    transitionanimation = 9;
                    canswitch = true;
                    gamebuttonfree = false;
                }
                if(gamebuttonfree && arduboy.pressed(DOWN_BUTTON) && checkcollision(playerx / 8, (playery + 8) / 8) && currentmap[index] != HTROT && currentmap[index] != BLROT && currentmap[index] != BRROT) {
                    rotateinplace(index);
                    playertoy += 8;
                    transitionanimation = 9;
                    canswitch = true;
                    gamebuttonfree = false;
                }
                if(gamebuttonfree && arduboy.pressed(LEFT_BUTTON) && checkcollision((playerx - 8) / 8, playery / 8) && currentmap[index] != VTROT && currentmap[index] != TLROT && currentmap[index] != BLROT) {
                    rotateinplace(index);
                    playertox -= 8;
                    transitionanimation = 9;
                    canswitch = true;
                    gamebuttonfree = false;
                }
                if(gamebuttonfree && arduboy.pressed(RIGHT_BUTTON) && checkcollision((playerx + 8) / 8, playery / 8) && currentmap[index] != VTROT && currentmap[index] != TRROT && currentmap[index] != BRROT) {
                    rotateinplace(index);
                    playertox += 8;
                    transitionanimation = 9;
                    canswitch = true;
                    gamebuttonfree = false;
                }
            } else {
                menubuttonfree = false;
            }
            
            if(playery > playertoy) {
                playery -= 1;
            }
            if(playery < playertoy) {
                playery += 1;
            }
            if(playerx > playertox) {
                playerx -= 1;
            }
            if(playerx < playertox) {
                playerx += 1;
            }
            if(playery == playertoy && playerx == playertox) {
                checklocation(playerx / 8, playery / 8);
                gamebuttonfree = true;
            } else {
                arduboy.drawPixel(playertox, playertoy, WHITE);
                arduboy.drawPixel(playertox + 7, playertoy, WHITE);
                arduboy.drawPixel(playertox, playertoy + 7, WHITE);
                arduboy.drawPixel(playertox + 7, playertoy + 7, WHITE);
            }
            if(arduboy.pressed(A_BUTTON) && menubuttonfree && gamebuttonfree) {
                temperature += 1;
                sound(100 + temperature * 10, 100);
            }
            
            if(temperature > 0) {
                arduboy.fillRect(112, 0, 16, 40, BLACK);
                arduboy.drawBitmap(112, 0, temptop, 16, 8, WHITE);
                arduboy.drawBitmap(112, 8, tempmiddle, 16, 8, WHITE);
                arduboy.drawBitmap(112, 16, tempmiddle, 16, 8, WHITE);
                arduboy.drawBitmap(112, 24, tempbottom, 16, 16, WHITE);
                arduboy.fillRect(119, 37 - temperature, 2, temperature, WHITE);
            }
            if(temperature == 32) {
                deathcounter = 1;
                temperature = 33;
            }
            
            checkcompletion();
            
            if(deathcounter == 0) {
                arduboy.drawBitmap(playerx, playery, character[0], 8, 8, WHITE);
                arduboy.drawBitmap(playerx, playery, character[1], 8, 8, BLACK);
            } else {
                //digitalWrite(RED_LED, ON);
                //digitalWrite(GREEN_LED, OFF);
                if((deathcounter - 1) / 8 == 0) {
                    sound(NOISEEXPLOSION1, 150);
                }
                if((deathcounter - 1) / 8 == 1) {
                    sound(NOISEEXPLOSION2, 150);
                }
                if((deathcounter - 1) / 8 == 2) {
                    sound(NOISEEXPLOSION3, 150);
                }
                if((deathcounter - 1) / 8 == 3) {
                    sound(NOISEEXPLOSION4, 150);
                }
                gamebuttonfree = false;
                temperature = 33;
                deathcounter += 1;
                arduboy.drawBitmap(playerx, playery, character[1], 8, 8, BLACK);
                arduboy.drawBitmap(playerx - 2, playery - 2, deathsheet[(deathcounter - 1) / 8], 12, 12, WHITE);
                if(deathcounter == 32) {
                    loadlevel(level);
                    menubuttonfree = false;
                }
            }
            break;




        case 6:
            arduboy.setCursor(0, 0);
            arduboy.printf("\nAnd now...\n\nYou will finally see\nwhat Circuit Dude has\nbeen building these\ncomputer chips for...");
            continuestate(7);
            break;
        case 7:
            arduboy.drawBitmap(0, 0, final1, 128, 64, WHITE);
            continuestate(8);
            break;
        case 8:
            arduboy.drawBitmap(0, 0, final2, 128, 64, WHITE);
            continuestate(9);
            break;
        case 9:
            arduboy.drawBitmap(0, 0, final2, 128, 64, WHITE);
            arduboy.fillRect(10, 36, 64, 28, WHITE);
            arduboy.drawBitmap(10, 36, final3, 64, 28, BLACK);
            continuestate(10);
            break;
        case 10:
            arduboy.drawBitmap(0, 0, final4, 128, 64, WHITE);
            continuestate(11);
            break;
        case 11:
            arduboy.drawBitmap(0, 0, final5, 128, 64, WHITE);
            continuestate(12);
            break;
        case 12:
            arduboy.setCursor(0, 0);
            arduboy.printf("The End...");
            continuestate(0);
            break;
  }

    if(arduboy.notPressed(A_BUTTON) && gamestate != 2) {
        menubuttonfree = true;
        temperature = 0;
    }
    if(arduboy.notPressed(DOWN_BUTTON) && arduboy.notPressed(UP_BUTTON) && arduboy.notPressed(A_BUTTON) && gamestate == 2) {
        menubuttonfree = true;
    }
    
    arduboy.display();
}
