#include "circleMonitoringStrategy.h"
#include "mbed.h"

CircleMonitoringStrategy::CircleMonitoringStrategy(Configuration* config)
{
    m_config = config;
}

CircleMonitoringStrategy::~CircleMonitoringStrategy()
{
}

bool CircleMonitoringStrategy::presenceCheck(const std::map<float, float>& distancesMap, ObjectPosition* objectPosition)
{
    Serial pc(USBTX, USBRX);
    float minDist = m_config->getDistance();
    float angle;
    std::map<float, float>::iterator it = distancesMap.begin();
        while (it != distancesMap.end()) {
            if(it->second < minDist) {
                minDist = it->second;
                angle = it->first;
            }
            it++;
        }
    if(minDist != m_config->getDistance()) {
        objectPosition->setAngle(angle);
        objectPosition->setDistance(minDist);
        //poppraviti i za squere
        return true;
    }
    return false;
}

