#ifndef MONITORINGCONTEXT_H
#define MONITORINGCONTEXT_H

#include "configuration.h"
#include "objectPosition.h"
#include "monitoringStrategyIf.h"

/*
* This class is used as Context for Monitoring Strategy for providing to client methods of interest
*/
class MonitoringContext
{
public:
    MonitoringContext(MonitoringStrategyIf* strategy);
    ~MonitoringContext();

    /**Executes algorithm for presence check*/
    bool executePresenceCheck(const std::map<float, float>& distancesMap, ObjectPosition* objectPosition);
    
    /**Setting new monitoring strategy into run time*/
    void setMonitoringStrategy(MonitoringStrategyIf* strategy);

private:
    MonitoringStrategyIf* m_strategy;

};
#endif