#ifndef MONITORINGSTRATEGYIF_H
#define MONITORINGSTRATEGYIF_H

#include<map>
#include "configuration.h"
#include "objectPosition.h"

/*
* This class is Monitoring Strategy interface and declares operations common to all monitoring strategies
*/
class MonitoringStrategyIf
{
public:
    virtual bool presenceCheck(const std::map<float, float>& distancesMap, ObjectPosition* objectPosition) = 0;
    void setConfiguration(Configuration* config)
    {
        m_config = config;
    }

protected:
    Configuration* m_config;
};
#endif