#ifndef SQUEREMONITORINGSTRATEGY_H
#define SQUEREMONITORINGSTRATEGY_H

#include "monitoringStrategyIf.h"

/*
* This class is implemntation of monitoringStrategIf for Square monitoring. Class is used to find nearest object in monitoring area
*/
class SquereMonitoringStrategy : public MonitoringStrategyIf
{
public:
    SquereMonitoringStrategy(Configuration* config);
    ~SquereMonitoringStrategy();
    bool presenceCheck(const std::map<float, float>& distancesMap, ObjectPosition* objectPosition);
    
    private:
    bool checkIsObjectUnderSquere(ObjectPosition tmpObjectPosition);
    
    int m_x;
    int m_y;
    const static double PI  =3.141592653589793238463;

};
#endif