#include "squareMonitoringStrategy.h"
#include <math.h>

SquereMonitoringStrategy::SquereMonitoringStrategy(Configuration* config)
{
    m_config = config;
    m_x = cos(PI/4) * m_config->getDistance();
    m_y = sin(PI/4) * m_config->getDistance();
}

SquereMonitoringStrategy::~SquereMonitoringStrategy()
{
}

bool SquereMonitoringStrategy::presenceCheck(const std::map<float, float>& distancesMap, ObjectPosition* objectPosition)
{
    float minDist = m_config->getDistance();
    float angle;
    std::map<float, float>::iterator it = distancesMap.begin();
        while (it != distancesMap.end()) {
            if(it->second < minDist) {
                ObjectPosition tmpObjectPosition(it->first, it->second);
                if(checkIsObjectUnderSquere(tmpObjectPosition)){
                    minDist = it->second;
                    angle = it->first;
                    }
            }
            it++;
        }
    if(minDist != m_config->getDistance()) {
        objectPosition->setAngle(angle);
        objectPosition->setDistance(minDist);
        return true;
    }
    return false;
}

bool SquereMonitoringStrategy::checkIsObjectUnderSquere(ObjectPosition tmpObjectPosition){
    if((tmpObjectPosition.getXCoordinate() < m_x) && (tmpObjectPosition.getYCoordinate() < m_y)){
        return true;
        }
    return false;
}
