#include "monitoringContext.h"

MonitoringContext::MonitoringContext(MonitoringStrategyIf* strategy)
{
    m_strategy = strategy;
}

MonitoringContext::~MonitoringContext()
{
    delete[] m_strategy;
}

bool MonitoringContext::executePresenceCheck(const std:: map<float, float>& distancesMap, ObjectPosition* objectPosition)
{
    if(this->m_strategy->presenceCheck(distancesMap, objectPosition)) {
        return true;
    }
    return false;
}

void MonitoringContext::setMonitoringStrategy(MonitoringStrategyIf* strategy)
{
    delete this->m_strategy;
    this->m_strategy = m_strategy;
}

