#include "STM32F103RGT6.h"
#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
//#include "string" // errors?
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
// the TFT is connected to SPI pin PB_15, PB_14, PB_13, PB_12, NC, PC_6, mosi, miso, sclk, cs, reset, dc
SPI_TFT_ILI9341 TFT(PB_15, PB_14, PB_13, PB_12, NC, PC_6,"TFT"); // mosi, miso, sclk, cs, reset, dc
//If your display need a signal for switch the backlight use a aditional IO pin in your program


Serial pc(PC_10, PC_11);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn joyleft(PB_5);
DigitalIn joysel(PB_6);
DigitalIn joydown(PB_7);
DigitalIn joyright(PB_8);
DigitalIn joyup(PB_9);
AnalogIn line(BT_RESET);
DigitalIn BT_1(BT_GPIO1);
//DigitalIn BT_2(BT_RESET);
DigitalIn BT_3(BT_POWER_ON);
//Timer timer;
//int begin, end;
int buff[320];

int main()
{
    int state =0;
    int pointx =0;
    int i;
   //timer.start();
    //int pointy =0;
    TFT.claim(stdout);      // send stdout to the TFT display
    //TFT.claim(stderr);      // send stderr to the TFT display
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.set_orientation(1); // 1 to set correct for m24sr-descovey
    TFT.newcls();                // clear the screen
    TFT.set_font((unsigned char*) Arial24x23);  // select font 2
    //TFT.line(0, 0, TFT.width(), TFT.height(), Red);
    //TFT.fillrect(200, 200, 100, 100, White);
    printf("width (%d)\n", TFT.width());
    printf("height(%d)\n", TFT.height());
    printf("columns (%d)\n", TFT.columns());
    printf("rows(%d)\n", TFT.rows());
    wait(5);
    TFT.locate(0,100);
    while(1) {
        if(!joyleft) {
            printf("  left\n");
            pc.printf("  left\n");
            TFT.cls();
            state =1;
        }
        if(!joyright) {
            printf("  right\n");
            pc.printf("  right\n");
            TFT.cls();
            state =2;
        }
        if(!joyup) {
            printf("  up\n");
            pc.printf("  up\n");
            TFT.cls();
            state =3;
        }
        if(!joydown) {
            led4 = !led4;
            printf("  down\n");
            pc.printf("  down\n");
            state =4;
        }
        if(!joysel) {
            printf("  sel\n");
            pc.printf("  sel\n");
            state =5;
        }

        switch (state) {
            case 1:
                led1 = !led1;
                TFT.locate(0,0);
                printf("BT_1! (%x)\n", BT_1.read());
                printf("BT_3! (%x)\n", BT_3.read());
                wait(1);
                break;
            case 2:
                led2 = !led2;
                TFT.locate(0,0);
                printf("val! (%d)\n", line.read_u16()); // 3v3 = +65,535
                printf("val! (%f)\n", line.read()); // 3v3 = ???
                printf("val! (%x)\n", line.read_u16());
                pc.printf("val! (%f)\n", line.read_u16());
                wait(1);
                break;
            case 3:
                TFT.newcls();                // clear the screen
                //begin = timer.read_us();
                for(i=0; i<320; i++) {
                    buff[i] = (int) (TFT.height()-(line.read()*TFT.height()));
                }
                //end = timer.read_us();
                for(pointx=0; pointx<320; pointx++) {
                    TFT.pixel(pointx,buff[pointx], Green);
                }
                led3 = !led3;
                TFT.locate(0,0);
                //end = timer.read_us();
                //printf("%d us", end - begin); // 1 read< 1uS

                break;
            default:
                TFT.newcls();
                TFT.locate(0,100);
                printf("  nothing to see \n");
                break;
        }
        wait(1);
    }

}
