/* mbed Terminal TextDisplay Library
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * Modified by Ned Konz
 * to add baud rate setting
 *
 * Implementation of a TextDisplay using a VT100 Terminal and 
 * escape codes (e.g. Teraterm, Hyperterminal)
 */

#include "TextDisplay.h"

#ifndef MBED_TERMINAL_H
#define MBED_TERMINAL_H

/** Terminal Textdisplay
 * 
 * Provides an TextDisplay version with output to a serial port
 * Example:
 * @code
 / simple test for TextDisplay class
 #include "mbed.h"
 #include "Terminal.h"
 
 Terminal lcd(USBTX, USBRX);
 
 int main() {
      lcd.printf("Hello TextDisplay world!\r\n");
      lcd.claim(stdout);
      printf("hello stream world\r\n");
 }

 * @endcode
 */
class Terminal : public TextDisplay {
public:
    /** Create the TextDisplay interface
     *
     * @param tx PinName for data sending (USBTX for pc connection)
     * @param rx PinName for data reception (USBRX for pc connection)
     * @param name The name used in the path to access the strean through the filesystem 
     */
    Terminal(PinName tx, PinName rx, const char *name = "term");

    virtual void character(uint16_t column, uint16_t row, int c);
    virtual uint16_t rows(); 
    virtual uint16_t columns();  

    virtual void cls();
    virtual void foreground(uint32_t colour);
    virtual void background(uint32_t colour);
    virtual void baud(uint16_t newbaud) { _serial.baud(newbaud); }

protected:

    Serial _serial;
    
};

#endif
