/* mbed Terminal TextDisplay Library
 * Copyright (c) 2007-2009 sford
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "Terminal.h"

#include "mbed.h"

Terminal::Terminal(PinName tx, PinName rx, const char *name) : TextDisplay(name), _serial(tx, rx) {
    cls();
}
    /** Create the TextDisplay interface
     *
     * reset PinName for reset
     * nRead PinName for /read
     * nWrite PinName for /write
     * nSelect PinName for /select
     * addr0 PinName for addr0
     * d0 - d7 PinName for D0 -D7
     * hor_dots horizontal resolution  of display (in pixels), default: 256
     * vert_dots vertical resolution of display (in pixels), default: 128
     * char_width diaply width of character (in pixels), default: 6
     * char_height display height of character (in pixels), default: 10 
     * name name to be used in pathname of the stream (defaults to "sed133x")
     * @param name The name used in the path to access the strean through the filesystem
     */
void Terminal::character(uint16_t column, uint16_t row, int c) {
    // Cursor Home    <ESC>[{ROW};{COLUMN}H 
    _serial.printf("\033[%u;%uH%c", row + 1, column + 1, c);
}

uint16_t Terminal::columns() {
    return 80;
}

uint16_t Terminal::rows() { 
    return 35; 
}

void Terminal::cls() {
    _serial.printf("\033[2J");
}

void Terminal::foreground(uint32_t colour) {

    /* Set Attribute Mode    <ESC>[{n}m
     * - Sets display attribute settings. The following lists standard attributes:
     * 
     * Foreground Colours
     * 30    Black
     * 31    Red
     * 32    Green
     * 33    Yellow
     * 34    Blue
     * 35    Magenta
     * 36    Cyan
     * 37    White
     */
    uint32_t r = (colour >> 23) & 1;
    uint32_t g = (colour >> 15) & 1;
    uint32_t b = (colour >> 7) & 1;
    uint32_t bgr = (b << 2) | (g << 1) | (r << 0);
    uint32_t c = 30 + bgr;
    _serial.printf("\033[%um", c);
}

void Terminal::background(uint32_t colour) {

    /* Background Colours
     * 40    Black
     * 41    Red
     * 42    Green
     * 43    Yellow
     * 44    Blue
     * 45    Magenta
     * 46    Cyan
     * 47    White
     */
    uint32_t r = (colour >> 23) & 1;
    uint32_t g = (colour >> 15) & 1;
    uint32_t b = (colour >> 7) & 1;
    uint32_t bgr = (b << 2) | (g << 1) | (r << 0);
    uint32_t c = 40 + bgr;
    _serial.printf("\033[%um", c);
}

