#ifndef TARGET_H
#define TARGET_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


class Target
{
    public:
    Target();
    ~Target();
    
    /** Initialise Target
    *
    *   This function initialises the target library.
    */
    void init();
    
    /** Draw
    *
    *   This function draws the target sprite onto the screen.
    */
    void draw(N5110 &lcd);
    
    /** Update
    *
    *   This function updates the position of the target as it moves on the screen.
    */
    void update();
    
    /** Get Position
    *
    *   This function obtains the coordinates of the top-left pixel in the targets sprite.
    */
    Vector2D get_pos();
    
    /** Set Position
    *
    *   This function is used to change the position of the sprite to specific coordinates when called.
    */
    void set_pos(Vector2D p);

    private:
    int n;
    int _x;
    int _y;
    Vector2D _velocity;

};
#endif