#ifndef PROJECTILE_H
#define PROJECTILE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Player.h"

class Projectile
{
    public:
    Projectile();
    ~Projectile();
    
    /** Initialise Projectile
    *
    *   This function initialises the projectile library.
    */
    void init(int playerx, int playery);
    
    /** Draw
    *
    *   This function draws the projectile on screen when called.
    */
    void draw(N5110 &lcd);
    
    /** Get Position
    *
    *   This function obtains the coordinates of the top-left pixel in the projectile.
    */
    Vector2D get_pos();
    
    /** Update
    *
    *   This function updates changes in position of the projectile on screen.
    */
    void update();
    int playerx;
    int playery;
    int _playerx;
    int _playery;
    
    /** Set Position
    *
    *   This function is used to set the position of the projectile to a specific coordinate on screen.
    */
    void set_pos(Vector2D p);
    
    private:
    int m;
    Vector2D _velocity;
    int _size;
    int _x;
    int _y;
    
};
#endif