#include "Player.h"

Player::Player()
{

}

Player::~Player()
{

}

//The Player Sprite.
int sprite[5][6] = {
    {0,1,0,0,1,0},
    {1,1,0,0,1,1},
    {1,1,1,1,1,1},
    {1,1,1,1,1,1},
    {0,1,1,1,1,0},
    };
    
int m = 0; //Variable used to allow a starting location for the player.
    

void Player::init()
{

    _speed = 0.15;// default speed 
    
}


void Player::draw(N5110 &lcd)
{   
    if(m == 0){
        _x = WIDTH/2 -3;  //Spawns player sprite near the middle of the screen.
        _y = HEIGHT/2 +5; 
        m = m+1;  
        }
    //printf("SPRITE %d %d \n", _x, _y); 
    lcd.drawSprite(_x,_y,5,6,(int *)sprite); //Function used to draw the sprite.
}



Vector2D Player::get_pos()
{
    Vector2D playerpos = {_x,_y}; //Obtains the player position.
    //printf("playerpos from player = %f %f \n", playerpos.x, playerpos.y);
    return playerpos;
}







void Player::update(Direction d,float mag)
{
    _speed = int(mag*7.0f);  //Speed changes depending on how much you push the joystick.


    // North is decrement as origin is at the top-left so decreasing moves up
    // Diagonal speeds are /2 to prevent player from going double the speed.
    if (d == N) {
        _y-=_speed;
    }
    if (d == S) {
        _y+=_speed;
    }
    if (d == E) {
        _x+=_speed;
    }
    if (d == W) {
        _x-=_speed;
    }
    if (d == NE) {
        _y-=_speed/2; 
        _x+=_speed/2;
    }
    if (d == NW) {
        _y-=_speed/2;
        _x-=_speed/2;
    }
    if (d == SE) {
        _y+=_speed/2;
        _x+=_speed/2;
    }
    if (d == SW) {
        _y+=_speed/2;
        _x-=_speed/2;
    }


    //Limits set so that the sprite does not travel off the screen.
    if (_y <= 0) {
        _y = 0;
    }
    if (_x <= 0) {
        _x = 0;
    }
    if (_x > 78) {
        _x = 78;
    }
    if (_y > 42) {
        _y = 42;
    }

}

