#ifndef PLAYER_H
#define PLAYER_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"


class Player
{
    public:
    
    
    Player();
    ~Player();
    
    /** Initialise Player
    *
    *   This function initalises the player library.
    */
    void init();
    
    /** Draw
    *
    *   This function draws the Player sprite onto the screen at the specified coordinates.
    */
    void draw(N5110 &lcd);
    
    /** Update
    *
    *   This function updates the player sprite position on screen.
    */
    void update(Direction d,float mag);
    
    /** Get Position
    *
    *   This function obtains the coordinate of the top-left pixel in the player sprite.
    */
    Vector2D get_pos();
    

    private:
    int m;
    int _x;
    int _y;
    int _speed;

};
#endif