#ifndef HEALTHBAR_H
#define HEALTHBAR_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

class HealthBar
{
    public:
    
    HealthBar();
    ~HealthBar();
    
    /** Initialise HealthBar
    *
    *   This function initialises the HealthBar and obtains the HP value from the game engine.
    */
    void init(int HP);
    
    /** Draw
    *
    *   This function draws the health bar onto the screen.
    */
    void draw(N5110 &lcd);
    
    /** Update
    *
    *   This function updates the health bar on screen as the HP value changes.
    */
    void update();
    
    /** Minus HP 1
    *
    *   This function obtains the HPLost1 value from the game engine.
    */
    void MinusHP1(int HPLost1);
    
    /** Minus HP 2
    *
    *   This function obtains the HPLost2 value from the game engine.
    */
    void MinusHP2(int HPLost2);
    
    int ZeroHP;
    
    

    private:
    int _HP;
    int _HPLost1;
    int _HPLost2;
    int TotalHP;
    
    

};
#endif