///////// pre-processor directives ////////
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "GameEngine.h"

/////////////// structs /////////////////
struct UserInput {
    Direction d;
    float mag;
};
/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
GameEngine game;
///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
///////////// functions ////////////////
int main()
{
    int fps = 15;  // frames per second

    init();
    welcome();
    
    render();  // draw initial frame 
    wait(1.0f/fps);  

    // game loop - read input, update the game state and render the display
    while (1) {
        game.read_input(pad);
        game.update(pad);
        render();
        
    
        
        wait(1.0f/fps);
        
        
                
    }
}

void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
     
    // initialise the game
    game.init();

}

void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    game.draw(lcd, pad);
    game.get_pos();
    lcd.refresh();
}

void welcome() {
    
    lcd.printString(" Professional ",0,1);
    lcd.printString("    Boxing ",0,2); 
    lcd.printString("  Press Start  ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
 
}