#ifndef GAMEENGINE_H
#define GAMEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Player.h"
#include "Projectile.h"
#include "Target.h"
#include "HealthBar.h"

class GameEngine
{
    public:
    GameEngine();
    ~GameEngine();
    
    /** Initialise Game Engine
    *
    *   This function initialises the game engine.
    */
    void init( );
    
    /** Read Input
    *
    *   This function obtains numeric data from the gamepads joystick.
    */
    void read_input(Gamepad &pad);
    
    /** Update
    *
    *   This function contains the update functions of the other libraries used in the game.
    */
    void update(Gamepad &pad);
    
    /** Draw 
    *
    *   This function contains the draw functions of the other libraries used in the game.
    */
    void draw(N5110 &lcd, Gamepad &pad);
    
    /** Get Position
    *
    *   This function contains the Get Position functions of the otehr libraries used in the game.
    */
    void get_pos();
    
    
    int playerx;
    int playery;
    int score;
    
    private:
    
    Player _p;
    Projectile _proj;
    Target _t;
    Target _tt;
    Target _ttt;
    HealthBar _hb;
    int _speed;
    Direction _d;
    float _mag;
    
    /** Check for Projectile and Target collision
    *
    *   This function checks if the projectile has come into contact with a target.
    */
    void CheckProjTargetCollision(Gamepad &pad);
    
    /** Check for Player and Target collision
    *
    *   This function checks if the player has come into contact with a target.
    */
    void CheckPlayerTargetCollision(Gamepad &pad);
    
    /** Check for Target and Floor collision
    *
    *   This function checks if the target sprite has reached the bottom of the screen.
    */
    void CheckTargetFloorCollision(Gamepad &pad);
    int HP;
    int n;
    int HPLost1;
    int HPLost2;
    
};
#endif