#include "GameEngine.h"

GameEngine::GameEngine()
{

}

GameEngine::~GameEngine()
{

}

void GameEngine::init()
{
    int HP = 8; //Health value is chosen here.
    _hb.init(HP); //HP value is then passed to the HealthBar library.
    
}



void GameEngine::read_input(Gamepad &pad)
{
    _d = pad.get_direction(); //Obtains numeric data from hardware.
    _mag = pad.get_mag(); //Obtains numeric data from hardware.
}

void GameEngine::draw(N5110 &lcd, Gamepad &pad)
{
    _p.draw(lcd); //Draws the Player Sprite.        
    _proj.draw(lcd); //Draws the Projectile.
    _t.draw(lcd); //Draws the first target.
    _tt.draw(lcd); //Draws the second target.
    _ttt.draw(lcd); //Draws the third target.
    _hb.draw(lcd); //Draws the health bar.
    
    //Code to print score on game screen.
    char bufferscore[14];
    sprintf(bufferscore,"%d",score);
    lcd.printString(bufferscore,1,0);
    
    
    //Losing condition and losing screen.
    if(_hb.ZeroHP == 1){ //Checks if health bar is empty. //Working
        
        lcd.clear(); 
        lcd.printString("   You Lose    ",0,1);  
        lcd.printString("  Score =   ",0,3);
        lcd.printString(bufferscore,WIDTH/2 + 20,3); 
        lcd.printString("   Press A  ",0,5);
        lcd.refresh();
        wait(0.5);
        
        while(1){
            wait(0.5);
            if(pad.check_event(Gamepad::A_PRESSED)){ //Waits for A button to be pressed.
                NVIC_SystemReset(); //Software Reset.
                }

        }
    }
        
        
    
}


void GameEngine::update(Gamepad &pad) //Updates objects on screen.
{
    _p.update(_d,_mag); 
    _proj.update();  
    _t.update();
    _tt.update();
    _ttt.update();
    CheckProjTargetCollision(pad); //Function checks for when a projectile collides with target.
    CheckPlayerTargetCollision(pad); //Function checks for when the player collides with target.
    CheckTargetFloorCollision(pad); //Function checks for when a target collides with the floor or bottom of the screen.
    _hb.update(); //Updates HP bar.
    
}

void GameEngine::get_pos()
{
    Vector2D player_pos = _p.get_pos();
    //printf("player pos = %f %f \n", player_pos.x, player_pos.y); //top left of player sprite
    // 81.000000 0.000000 top right
    // 0.000000 0.000000 is top left
    // 81.000000 45.000000 bottom right
    Vector2D proj_pos = _proj.get_pos();
    //printf("proj pos = %f %f \n", proj_pos.x, proj_pos.y);
    
    playerx = player_pos.x;
    playery = player_pos.y;
    //printf("playerxy in GAME = %d %d \n", playerx, playery);
    _proj.init(playerx,playery); //Sends the Player position to the projectile library
    
    }
    

/////////////////////////////////////////////
/////////////////////////////////////////////
/////////////////////////////////////////////  

void GameEngine::CheckTargetFloorCollision(Gamepad &pad)
{   
    Vector2D t_pos = _t.get_pos(); //Obtains the first target position.
    Vector2D tt_pos = _tt.get_pos(); //Obtains the second target position.
    Vector2D ttt_pos = _ttt.get_pos(); //Obtains the third target position.
    
    //printf("%f t_pos \n", t_pos.y);
    //printf("%f tt_pos \n", tt_pos.y);
    //printf("%f ttt_pos \n", ttt_pos.y);
    
    
    //If statements check for when the position of targets are equal to the
    //bottom of the screen, if so then HP is deducted using the HPLost2 variable.
    
    if(t_pos.y == 47){
        //printf("t floor \n");
        HPLost2 = HPLost2 - 1;
        }
    if(tt_pos.y == 47){
        //printf("tt floor \n");
        HPLost2 = HPLost2 - 1;
        }
    if(ttt_pos.y == 47){
        //printf("ttt floor \n");
        HPLost2 = HPLost2 - 1;
        }
        
        //printf("%d HP \n", HPLost2);
        
        _hb.MinusHP2(HPLost2); //Variable is sent to the HealthBar library.

    }
/////////////////////////////////////////////
/////////////////////////////////////////////
/////////////////////////////////////////////  
    
    
    
    
    
    
void GameEngine::CheckProjTargetCollision(Gamepad &pad)
{
    //Obtains all needed coordinates.
    Vector2D proj_pos = _proj.get_pos();
    Vector2D t_pos = _t.get_pos();
    Vector2D tt_pos = _tt.get_pos();
    Vector2D ttt_pos = _ttt.get_pos();

    Vector2D player_pos = _p.get_pos();

   // printf("proj %f %f \n", proj_pos.x, proj_pos.y);
    //printf("targ %f %f \n", t_pos.x, t_pos.y);
    
    
    //If states check if the projectile has collided with any of the three
    //targets, if so the target and the projectile's location is reset.
    //Score is also updated.
    
    if (
        ((proj_pos.y == t_pos.y) ||
        (proj_pos.y == t_pos.y + 1) ||
        (proj_pos.y == t_pos.y + 2) ||
        (proj_pos.y == t_pos.y + 3) ||
        (proj_pos.y == t_pos.y + 4) ||
        (proj_pos.y == t_pos.y + 5) ||
        (proj_pos.y == t_pos.y + 6) ||
        (proj_pos.y == t_pos.y + 7) ||
        (proj_pos.y + 1 == t_pos.y) ||
        (proj_pos.y + 1 == t_pos.y + 1) ||
        (proj_pos.y + 1 == t_pos.y + 2) ||
        (proj_pos.y + 1 == t_pos.y + 3) ||
        (proj_pos.y + 1 == t_pos.y + 4) ||
        (proj_pos.y + 1 == t_pos.y + 5) ||
        (proj_pos.y + 1 == t_pos.y + 6) ||
        (proj_pos.y + 1 == t_pos.y + 7)) &&
        ((proj_pos.x == t_pos.x) ||
        (proj_pos.x == t_pos.x + 1) ||
        (proj_pos.x == t_pos.x + 2) ||
        (proj_pos.x == t_pos.x + 3) ||
        (proj_pos.x == t_pos.x + 4) ||
        (proj_pos.x == t_pos.x + 5) ||
        (proj_pos.x == t_pos.x + 6) ||
        (proj_pos.x == t_pos.x + 7) ||
        (proj_pos.x + 1 == t_pos.x) ||
        (proj_pos.x + 1 == t_pos.x + 1) ||
        (proj_pos.x + 1 == t_pos.x + 2) ||
        (proj_pos.x + 1 == t_pos.x + 3) ||
        (proj_pos.x + 1 == t_pos.x + 4) ||
        (proj_pos.x + 1 == t_pos.x + 5) ||
        (proj_pos.x + 1 == t_pos.x + 6) ||
        (proj_pos.x + 1 == t_pos.x + 7) ||
        (proj_pos.x + 1 == t_pos.x + 8) ||
        (proj_pos.x + 1 == t_pos.x + 9) ||
        (proj_pos.x + 1 == t_pos.x + 10))
    ) {
        
        //printf("projtarget working \n");
        proj_pos.x = player_pos.x +2;
        proj_pos.y = player_pos.y;
        t_pos.x = rand() % 79;
        t_pos.y = 0;
        // audio feedback
        //pad.tone(1000.0,0.1);
        score = score + 1;
    }
    
    if (
        ((proj_pos.y == tt_pos.y) ||
        (proj_pos.y == tt_pos.y + 1) ||
        (proj_pos.y == tt_pos.y + 2) ||
        (proj_pos.y == tt_pos.y + 3) ||
        (proj_pos.y == tt_pos.y + 4) ||
        (proj_pos.y == tt_pos.y + 5) ||
        (proj_pos.y == tt_pos.y + 6) ||
        (proj_pos.y == tt_pos.y + 7) ||
        (proj_pos.y + 1 == tt_pos.y) ||
        (proj_pos.y + 1 == tt_pos.y + 1) ||
        (proj_pos.y + 1 == tt_pos.y + 2) ||
        (proj_pos.y + 1 == tt_pos.y + 3) ||
        (proj_pos.y + 1 == tt_pos.y + 4) ||
        (proj_pos.y + 1 == tt_pos.y + 5) ||
        (proj_pos.y + 1 == tt_pos.y + 6) ||
        (proj_pos.y + 1 == tt_pos.y + 7)) &&
        ((proj_pos.x == tt_pos.x) ||
        (proj_pos.x == tt_pos.x + 1) ||
        (proj_pos.x == tt_pos.x + 2) ||
        (proj_pos.x == tt_pos.x + 3) ||
        (proj_pos.x == tt_pos.x + 4) ||
        (proj_pos.x == tt_pos.x + 5) ||
        (proj_pos.x == tt_pos.x + 6) ||
        (proj_pos.x == tt_pos.x + 7) ||
        (proj_pos.x + 1 == tt_pos.x) ||
        (proj_pos.x + 1 == tt_pos.x + 1) ||
        (proj_pos.x + 1 == tt_pos.x + 2) ||
        (proj_pos.x + 1 == tt_pos.x + 3) ||
        (proj_pos.x + 1 == tt_pos.x + 4) ||
        (proj_pos.x + 1 == tt_pos.x + 5) ||
        (proj_pos.x + 1 == tt_pos.x + 6) ||
        (proj_pos.x + 1 == tt_pos.x + 7) ||
        (proj_pos.x + 1 == tt_pos.x + 8) ||
        (proj_pos.x + 1 == tt_pos.x + 9) ||
        (proj_pos.x + 1 == tt_pos.x + 10))
    ) {
        
        //printf("projtarget working \n");
        proj_pos.x = player_pos.x +2;
        proj_pos.y = player_pos.y;
        tt_pos.x = rand() % 79;
        tt_pos.y = 0;
        // audio feedback
        //pad.tone(1000.0,0.1);
        score = score + 1;
    }
    
    if (
        ((proj_pos.y == ttt_pos.y) ||
        (proj_pos.y == ttt_pos.y + 1) ||
        (proj_pos.y == ttt_pos.y + 2) ||
        (proj_pos.y == ttt_pos.y + 3) ||
        (proj_pos.y == ttt_pos.y + 4) ||
        (proj_pos.y == ttt_pos.y + 5) ||
        (proj_pos.y == ttt_pos.y + 6) ||
        (proj_pos.y == ttt_pos.y + 7) ||
        (proj_pos.y + 1 == ttt_pos.y) ||
        (proj_pos.y + 1 == ttt_pos.y + 1) ||
        (proj_pos.y + 1 == ttt_pos.y + 2) ||
        (proj_pos.y + 1 == ttt_pos.y + 3) ||
        (proj_pos.y + 1 == ttt_pos.y + 4) ||
        (proj_pos.y + 1 == ttt_pos.y + 5) ||
        (proj_pos.y + 1 == ttt_pos.y + 6) ||
        (proj_pos.y + 1 == ttt_pos.y + 7)) &&
        ((proj_pos.x == ttt_pos.x) ||
        (proj_pos.x == ttt_pos.x + 1) ||
        (proj_pos.x == ttt_pos.x + 2) ||
        (proj_pos.x == ttt_pos.x + 3) ||
        (proj_pos.x == ttt_pos.x + 4) ||
        (proj_pos.x == ttt_pos.x + 5) ||
        (proj_pos.x == ttt_pos.x + 6) ||
        (proj_pos.x == ttt_pos.x + 7) ||
        (proj_pos.x + 1 == ttt_pos.x) ||
        (proj_pos.x + 1 == ttt_pos.x + 1) ||
        (proj_pos.x + 1 == ttt_pos.x + 2) ||
        (proj_pos.x + 1 == ttt_pos.x + 3) ||
        (proj_pos.x + 1 == ttt_pos.x + 4) ||
        (proj_pos.x + 1 == ttt_pos.x + 5) ||
        (proj_pos.x + 1 == ttt_pos.x + 6) ||
        (proj_pos.x + 1 == ttt_pos.x + 7) ||
        (proj_pos.x + 1 == ttt_pos.x + 8) ||
        (proj_pos.x + 1 == ttt_pos.x + 9) ||
        (proj_pos.x + 1 == ttt_pos.x + 10))
    ) {
        
        //printf("projtarget working \n");
        proj_pos.x = player_pos.x +2;
        proj_pos.y = player_pos.y;
        ttt_pos.x = rand() % 79;
        ttt_pos.y = 0;
        // audio feedback
        //pad.tone(1000.0,0.1);
        score = score + 1;
    }
     

    _proj.set_pos(proj_pos);
    _t.set_pos(t_pos);
    _tt.set_pos(tt_pos);
    _ttt.set_pos(ttt_pos);

       
    }
    
    
/////////////////////////////////////////////
/////////////////////////////////////////////
/////////////////////////////////////////////
    
    
void GameEngine::CheckPlayerTargetCollision(Gamepad &pad)
    {
        //Obtains all required coordinates.
        
        
        Vector2D t_pos = _t.get_pos();
        Vector2D tt_pos = _tt.get_pos();
        Vector2D ttt_pos = _ttt.get_pos();
        Vector2D player_pos = _p.get_pos();
        
        //If statements check if the player sprite has collided with any
        //of the three targets, if so then the target location is reset and
        //health is deducted using the HPLost1 variable.
         
    if (
        ((player_pos.y == t_pos.y) ||
        (player_pos.y == t_pos.y + 1) ||
        (player_pos.y == t_pos.y + 2) ||
        (player_pos.y == t_pos.y + 3) ||
        (player_pos.y == t_pos.y + 4) ||
        (player_pos.y == t_pos.y + 5) ||
        (player_pos.y == t_pos.y + 6) ||
        (player_pos.y == t_pos.y + 7) ||
        (player_pos.y + 4 == t_pos.y) ||
        (player_pos.y + 4 == t_pos.y + 1) ||
        (player_pos.y + 4 == t_pos.y + 2) ||
        (player_pos.y + 4 == t_pos.y + 3) ||
        (player_pos.y + 4 == t_pos.y + 4) ||
        (player_pos.y + 4 == t_pos.y + 5) ||
        (player_pos.y + 4 == t_pos.y + 6) ||
        (player_pos.y + 4 == t_pos.y + 7)) &&
        ((player_pos.x == t_pos.x) ||
        (player_pos.x == t_pos.x + 1) ||
        (player_pos.x == t_pos.x + 2) ||
        (player_pos.x == t_pos.x + 3) ||
        (player_pos.x == t_pos.x + 4) ||
        (player_pos.x == t_pos.x + 5) ||
        (player_pos.x == t_pos.x + 6) ||
        (player_pos.x == t_pos.x + 7) ||
        (player_pos.x == t_pos.x + 8) ||
        (player_pos.x == t_pos.x + 9) ||
        (player_pos.x == t_pos.x + 10) ||
        (player_pos.x + 5 == t_pos.x) ||
        (player_pos.x + 5 == t_pos.x + 1) ||
        (player_pos.x + 5 == t_pos.x + 2) ||
        (player_pos.x + 5 == t_pos.x + 3) ||
        (player_pos.x + 5 == t_pos.x + 4) ||
        (player_pos.x + 5 == t_pos.x + 5) ||
        (player_pos.x + 5 == t_pos.x + 6) ||
        (player_pos.x + 5 == t_pos.x + 7) ||
        (player_pos.x + 5 == t_pos.x + 8) ||
        (player_pos.x + 5 == t_pos.x + 9) ||
        (player_pos.x + 5 == t_pos.x + 10))
    ) {
        
        //printf("collision working3 \n");
        // audio feedback
        //pad.tone(1000.0,0.1);
        t_pos.x = rand() % 79;
        t_pos.y = 0;
        
        HPLost1 = HPLost1 - 1;
        
    }
    
    if (
        ((player_pos.y == tt_pos.y) ||
        (player_pos.y == tt_pos.y + 1) ||
        (player_pos.y == tt_pos.y + 2) ||
        (player_pos.y == tt_pos.y + 3) ||
        (player_pos.y == tt_pos.y + 4) ||
        (player_pos.y == tt_pos.y + 5) ||
        (player_pos.y == tt_pos.y + 6) ||
        (player_pos.y == tt_pos.y + 7) ||
        (player_pos.y + 4 == tt_pos.y) ||
        (player_pos.y + 4 == tt_pos.y + 1) ||
        (player_pos.y + 4 == tt_pos.y + 2) ||
        (player_pos.y + 4 == tt_pos.y + 3) ||
        (player_pos.y + 4 == tt_pos.y + 4) ||
        (player_pos.y + 4 == tt_pos.y + 5) ||
        (player_pos.y + 4 == tt_pos.y + 6) ||
        (player_pos.y + 4 == tt_pos.y + 7)) &&
        ((player_pos.x == tt_pos.x) ||
        (player_pos.x == tt_pos.x + 1) ||
        (player_pos.x == tt_pos.x + 2) ||
        (player_pos.x == tt_pos.x + 3) ||
        (player_pos.x == tt_pos.x + 4) ||
        (player_pos.x == tt_pos.x + 5) ||
        (player_pos.x == tt_pos.x + 6) ||
        (player_pos.x == tt_pos.x + 7) ||
        (player_pos.x == tt_pos.x + 8) ||
        (player_pos.x == tt_pos.x + 9) ||
        (player_pos.x == tt_pos.x + 10) ||
        (player_pos.x + 5 == tt_pos.x) ||
        (player_pos.x + 5 == tt_pos.x + 1) ||
        (player_pos.x + 5 == tt_pos.x + 2) ||
        (player_pos.x + 5 == tt_pos.x + 3) ||
        (player_pos.x + 5 == tt_pos.x + 4) ||
        (player_pos.x + 5 == tt_pos.x + 5) ||
        (player_pos.x + 5 == tt_pos.x + 6) ||
        (player_pos.x + 5 == tt_pos.x + 7) ||
        (player_pos.x + 5 == tt_pos.x + 8) ||
        (player_pos.x + 5 == tt_pos.x + 9) ||
        (player_pos.x + 5 == tt_pos.x + 10))
    ) {
        
        //printf("collision working2 \n");
        // audio feedback
        //pad.tone(1000.0,0.1);
        tt_pos.x = rand() % 79;
        tt_pos.y = 0;
        
        HPLost1 = HPLost1 - 1;
        
    }
    
    if (
        ((player_pos.y == ttt_pos.y) ||
        (player_pos.y == ttt_pos.y + 1) ||
        (player_pos.y == ttt_pos.y + 2) ||
        (player_pos.y == ttt_pos.y + 3) ||
        (player_pos.y == ttt_pos.y + 4) ||
        (player_pos.y == ttt_pos.y + 5) ||
        (player_pos.y == ttt_pos.y + 6) ||
        (player_pos.y == ttt_pos.y + 7) ||
        (player_pos.y + 4 == ttt_pos.y) ||
        (player_pos.y + 4 == ttt_pos.y + 1) ||
        (player_pos.y + 4 == ttt_pos.y + 2) ||
        (player_pos.y + 4 == ttt_pos.y + 3) ||
        (player_pos.y + 4 == ttt_pos.y + 4) ||
        (player_pos.y + 4 == ttt_pos.y + 5) ||
        (player_pos.y + 4 == ttt_pos.y + 6) ||
        (player_pos.y + 4 == ttt_pos.y + 7)) &&
        ((player_pos.x == ttt_pos.x) ||
        (player_pos.x == ttt_pos.x + 1) ||
        (player_pos.x == ttt_pos.x + 2) ||
        (player_pos.x == ttt_pos.x + 3) ||
        (player_pos.x == ttt_pos.x + 4) ||
        (player_pos.x == ttt_pos.x + 5) ||
        (player_pos.x == ttt_pos.x + 6) ||
        (player_pos.x == ttt_pos.x + 7) ||
        (player_pos.x == ttt_pos.x + 8) ||
        (player_pos.x == ttt_pos.x + 9) ||
        (player_pos.x == ttt_pos.x + 10) ||
        (player_pos.x + 5 == ttt_pos.x) ||
        (player_pos.x + 5 == ttt_pos.x + 1) ||
        (player_pos.x + 5 == ttt_pos.x + 2) ||
        (player_pos.x + 5 == ttt_pos.x + 3) ||
        (player_pos.x + 5 == ttt_pos.x + 4) ||
        (player_pos.x + 5 == ttt_pos.x + 5) ||
        (player_pos.x + 5 == ttt_pos.x + 6) ||
        (player_pos.x + 5 == ttt_pos.x + 7) ||
        (player_pos.x + 5 == ttt_pos.x + 8) ||
        (player_pos.x + 5 == ttt_pos.x + 9) ||
        (player_pos.x + 5 == ttt_pos.x + 10))
    ) {
        
        //printf("collision working1 \n");
        // audio feedback
        //pad.tone(1000.0,0.1);
        ttt_pos.x = rand() % 79;
        ttt_pos.y = 0;
        
        HPLost1 = HPLost1 - 1;
        
    }

    //printf("%d", HPLost1); //Kind of working??
    _t.set_pos(t_pos);
    _tt.set_pos(tt_pos);
    _ttt.set_pos(ttt_pos);
    _hb.MinusHP1(HPLost1);
    }
        
        
        

    
    
    
    