/***********************************************************************************
    Filename: CharacterLCD.h

    
***********************************************************************************/
#ifndef CHARLCD_H
#define CHARLCD_H
#include "mbed.h"

//move this typedef to project specific datatype header file
typedef unsigned char uint8;



class charLcd
{   public:

        /** LCD panel format */
        enum LCDType {
            LCD16x2     /**< 16x2 LCD panel (default) */
            , LCD16x2B  /**< 16x2 LCD panel alternate addressing */
            , LCD20x2   /**< 20x2 LCD panel */
            , LCD20x4   /**< 20x4 LCD panel */
        };
        
        enum t_charlcd_entry_mode {
            shift_inc = 4, 
            noshift_inc = 3, 
            shift_dec = 2, 
            noshift_dec = 1, 
        };
        
        
        //constructor for 4-bit lcd control
        charLcd(PinName rs, PinName rw, PinName en, PinName d7, PinName d6, PinName d5, PinName d4, LCDType type = LCD16x2);
        //constructor for 8-bit lcd control
        charLcd(PinName rs, PinName rw, PinName en, PinName d7, PinName d6, PinName d5, PinName d4, PinName d3, PinName d2, 
            PinName d1, PinName d0, LCDType type = LCD16x2);
        
        void charLcdResetLCD(void);
        void charLcdClear (void);
        void charLcdReturnHome();
        //void charLcdEntryMode(uint8 increment, uint8 shift);
        void charLcdEntryMode(t_charlcd_entry_mode entrymode);
        void charLcdDisplayOn(uint8 on);
        void charLcdCursor(uint8 cursor, uint8 blink);
        void charLcdShift(uint8 left, uint8 cursor);
        void charLcdFunctionSet(uint8 dots, uint8 lines, uint8 bits);
        
    private:
        void charLcdSetCGRAMaddress(uint8 adr);
        void charLcdSetDDRAMaddress(uint8 address);
        uint8 charLcdReadBusyFlag();
        void charLcdWriteData(uint8 dat);
        uint8 charLcdReadData();
        void charLcdSendCommand(uint8 cmd);
        void charLcdWriteByte(uint8 byte);
        
        uint8 LcdStatus;
        uint8 LcdCustomChar[8];
        
        //LCD Control pins
        DigitalOut cl_rs;
        DigitalOut cl_rw;
        DigitalOut cl_en;
        
        //LCD Data pins
        //DigitalInOut cl_d7;
        //DigitalInOut cl_d6;
        //DigitalInOut cl_d5;
        //DigitalInOut cl_d4;
        //DigitalInOut cl_d3;
        //DigitalInOut cl_d2;
        //DigitalInOut cl_d1;
        //DigitalInOut cl_d0;
        
        //LCD Data port
        //PortInOut charLcdData;
        
        //LCD Data bus
        BusInOut cl_charLcdData;
        

        enum t_charlcd_function_set {NO_WIND = 4, NORTH_WIND = 3, SOUTH_WIND = 2, EAST_WIND = 1, WEST_WIND = 0};

};



/**********************************************************************************/
#endif //CHARLCD_H