#include "mbed.h"
#include "charLcd.h"
#include "hd44780.h"
#include "main.h"
Serial pc(USBTX, USBRX);
#define DEBUG

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
 //constructor for 4-bit lcd control
    charLcd::charLcd(PinName rs, PinName en, PinName rw, PinName d4, PinName d5, PinName d6, PinName d7, LCDType type) 
    : cl_rs(rs), cl_rw(rw), cl_en(en), cl_charLcdData(d7, d6, d5, d4) {
        pc.baud(115200);
        #ifdef DEBUG
            pc.printf("LCD 4bit init\r\n");
        #endif //DEBUG
        charLcdResetLCD();
    }

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
 //constructor for 8-bit lcd control
    charLcd::charLcd(PinName rs, PinName en, PinName rw, PinName d0, PinName d1, PinName d2, PinName d3, PinName d4, PinName d5, 
    PinName d6, PinName d7, LCDType type)
    : cl_rs(rs), cl_rw(rw), cl_en(en), cl_charLcdData(d7, d6, d5, d4, d3, d2, d1, d0) {
    
        pc.baud(115200);
        #ifdef DEBUG
            pc.printf("LCD 8-bit init\r\n");
        #endif //DEBUG
        charLcdResetLCD();
    
    }


 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdResetLCD(void) {
    cl_charLcdData.output();
    cl_charLcdData = 0x00;
    cl_en  = 1;
    cl_rs = 0;            // command mode
    cl_rw = 0;
    wait_ms(10);        // Wait 15ms to ensure powered up
    //charLcdFunctionSet(0,1,0);
    //wait_ms(5);        // Wait 15ms to ensure powered up
    //charLcdFunctionSet(0,1,0);
    //wait_us(100);        // Wait 15ms to ensure powered up
    //charLcdFunctionSet(0,1,0);
    //wait_us(100);        // Wait 15ms to ensure powered up
    //charLcdFunctionSet(0,1,0);
    //charLcdDisplayOn(0);
    while (1) {
    charLcdClear();
    wait_ms(500);
    cl_charLcdData = 0x00;
    wait_ms(500);
    }
    charLcdEntryMode(shift_inc);
    wait_ms(20);        // Wait 15ms to ensure powered up
    charLcdFunctionSet(0,1,0);
    wait_ms(20);        // Wait 15ms to ensure powered up
    charLcdDisplayOn(1);
    wait_ms(20);        // Wait 15ms to ensure powered up
    charLcdCursor(1, 1);
    wait_ms(20);        // Wait 15ms to ensure powered up
    charLcdEntryMode(shift_inc);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdClear (void){
    #ifdef DEBUG
            pc.printf("LCD Clear\r\n");
    #endif //DEBUG
    charLcdSendCommand(LCD_CLEAR);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdReturnHome(){
    #ifdef DEBUG
            pc.printf("LCD Home\r\n");
    #endif //DEBUG
    charLcdSendCommand(LCD_HOME);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
//void charLcd::charLcdEntryMode(uint8 increment, uint8 shift){
void charLcd::charLcdEntryMode(t_charlcd_entry_mode entrymode) {
    uint8 cmd = LCD_ENTRY_MODE;
    
    switch(entrymode) {
        case shift_inc: {cmd |= (LCD_ENTRY_SHIFT | LCD_ENTRY_INC); break;};
        case shift_dec: {cmd |= (LCD_ENTRY_SHIFT | LCD_ENTRY_DEC );break;};
        case noshift_inc: {cmd |= (LCD_ENTRY_STAT | LCD_ENTRY_INC); break;};
        case noshift_dec: {cmd |= (LCD_ENTRY_STAT | LCD_ENTRY_DEC); break;};
    }
    /*
    if (increment == 0x00){
        cmd |= LCD_ENTRY_DEC;
        #ifdef DEBUG
            pc.printf("LCD Entry Mode decrement\r\n");
        #endif //DEBUG
    } else {
        cmd |= LCD_ENTRY_INC;
        #ifdef DEBUG
            pc.printf("LCD Entry Mode Increment\r\n");
        #endif //DEBUG
    }
    if (shift == 0x00){
        cmd |= LCD_ENTRY_STAT;
        #ifdef DEBUG
            pc.printf("LCD Entry Mode Static\r\n");
        #endif //DEBUG
        
        
    } else {
        cmd |=LCD_ENTRY_SHIFT;
        #ifdef DEBUG
            pc.printf("LCD Entry Mode Shift\r\n");
        #endif //DEBUG
    }    */
    charLcdSendCommand(cmd);
    
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdDisplayOn(uint8 on){
    uint8 cmd = LCD_DISPLAY_CTR;
    if (on == 0x00){
        cmd |= LCD_DISP_OFF;
        #ifdef DEBUG
            pc.printf("LCD Display Control Display off\r\n");
        #endif //DEBUG
    } else {
        cmd |= LCD_DISP_ON;
        #ifdef DEBUG
            pc.printf("LCD Display Control Display on\r\n");
        #endif //DEBUG
    }
    charLcdSendCommand(cmd);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdCursor(uint8 cursor, uint8 blink){
    uint8 cmd = LCD_DISPLAY_CTR;
    if (cursor == 0x00){
        cmd |= LCD_CURSOR_OFF;
        #ifdef DEBUG
            pc.printf("LCD Display Control Cursor off\r\n");
        #endif //DEBUG
    } else {
        cmd |= LCD_CURSOR_ON;
        #ifdef DEBUG
            pc.printf("LCD Display Control Cursor on\r\n");
        #endif //DEBUG
    }
    if (blink == 0x00){
        cmd |= LCD_BLINK_OFF;
        #ifdef DEBUG
            pc.printf("LCD Display Control Cursor Blink off\r\n");
        #endif //DEBUG
    } else {
        cmd |=LCD_BLINK_ON;
        #ifdef DEBUG
            pc.printf("LCD Display Control Cursor Blink on\r\n");
        #endif //DEBUG
    }    
    charLcdSendCommand(cmd);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdShift(uint8 left, uint8 cursor){
    uint8 cmd = LCD_SHIFT;
    if (left == 0x00){
        cmd |= LCD_SHIFT_LEFT;
        #ifdef DEBUG
            pc.printf("LCD Shift Control Shift Left\r\n");
        #endif //DEBUG
    } else {
        cmd |= LCD_SHIFT_RIGHT;
        #ifdef DEBUG
            pc.printf("LCD Display Control Shift Right\r\n");
        #endif //DEBUG
    }
    if (cursor == 0x00){
        cmd |= LCD_SHIFT_DISP;
        #ifdef DEBUG
            pc.printf("LCD Display Control Shift Display\r\n");
        #endif //DEBUG
    } else {
        cmd |= LCD_SHIFT_CURS;
        #ifdef DEBUG
            pc.printf("LCD Display Control Shift Cursor\r\n");
        #endif //DEBUG
    }
    charLcdSendCommand(cmd);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdFunctionSet(uint8 dots, uint8 lines, uint8 bits){
    uint8 cmd = LCD_FUNCTION;
    if (dots == 0x00){
        cmd |= LCD_FUNC_5x8;
        #ifdef DEBUG
            pc.printf("LCD Display Function Control 5x8\r\n");
        #endif //DEBUG
    } else {
        cmd |= LCD_FUNC_5x10;
        #ifdef DEBUG
            pc.printf("LCD Display Function Control 5x10\r\n");
        #endif //DEBUG
    }
    if (lines == 0x00){
        cmd |= LCD_FUNC_1LINES;
        #ifdef DEBUG
            pc.printf("LCD Display Function Control 1 Line\r\n");
        #endif //DEBUG
    } else {
        cmd |= LCD_FUNC_2LINES;
        #ifdef DEBUG
            pc.printf("LCD Display Function Control 2 Lines\r\n");
        #endif //DEBUG
    }
    if (bits == 0x00){
        cmd |= LCD_FUNC_8BIT;
        #ifdef DEBUG
            pc.printf("LCD Display Function Control 8 BIT\r\n");
        #endif //DEBUG
    } else {
        cmd |= LCD_FUNC_4BIT;
        #ifdef DEBUG
            pc.printf("LCD Display Function Control 4 BIT\r\n");
        #endif //DEBUG
    }
    charLcdSendCommand(cmd);
//#define LCD_FUNCTION    0x20
//#define LCD_FUNC_5x10   0x04
//#define LCD_FUNC_5x8    0x00
//#define LCD_FUNC_2LINES 0x08
//#define LCD_FUNC_1LINES 0x00
//#define LCD_FUNC_8BIT   0x10
//#define LCD_FUNC_4BIT   0x00
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdSetCGRAMaddress(uint8 adr) {
    charLcdSendCommand(LCD_SET_CGRAM & adr);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdSetDDRAMaddress(uint8 adr) {
    charLcdSendCommand(LCD_SET_DDRAM & adr);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
uint8 charLcd::charLcdReadBusyFlag() {
    return 0x00;
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdWriteData(uint8 dat){
    cl_rs = 1;
    cl_rw = 1;
    charLcdWriteByte(dat);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
uint8 charLcd::charLcdReadData(){
    cl_rs = 0;
    cl_rw = 0;
    return 0x00;
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */        
void charLcd::charLcdSendCommand(uint8 cmd) {
    cl_rs = 0;
    cl_rw = 0;
    charLcdWriteByte(cmd);
}

 /** LCD constructor
 * 
 * More details about the function goes here
 * and here
 *
 * @param x a variable used by foo
 * @returns something magical done with x   
 */
void charLcd::charLcdWriteByte(uint8 byte) {
    cl_charLcdData = byte;
    pc.printf("Write %#X to LCD\r\n", byte);
    wait_us(500); // setup time
    cl_en = 0;
    wait_us(500); //hold time
    cl_en = 1;
}
