#ifndef __MBED_MXCHIP_WIFI_Interface_H
#define __MBED_MXCHIP_WIFI_Interface_H

#include "mbed.h"
#include "MXCHIP.h"

class MXCHIP_WIFI_Interface 
{
public:
    /** MXCHIP_WIFI_Interface lifetime
     * @param tx        TX pin
     * @param rx        RX pin
     * @param debug     Enable debugging
     */
    MXCHIP_WIFI_Interface(PinName tx, PinName rx);

    /** Start the interface
     *
     *  Attempts to connect to a WiFi network.
     *
     *  @param ssid      Name of the network to connect to
     *  @param pass      Security passphrase to connect to the network
     *  @param security  Type of encryption for connection (Default: NSAPI_SECURITY_NONE)
     *  @param channel   This parameter is not supported, setting it to anything else than 0 will result in NSAPI_ERROR_UNSUPPORTED
     *  @return          0 on success, or error code on failure
     */
     int connect(const char *ssid, const char *pass, nsapi_security_t security = NSAPI_SECURITY_NONE,
                                  uint8_t channel = 0);

    /** Stop the interface
     *  @return             0 on success, negative on failure
     */
     int disconnect();

    /** Get the internally stored IP address
     *  @return             IP address of the interface or null if not yet connected
     */
     const char *get_ip_address();

    /** Get the internally stored MAC address
     *  @return             MAC address of the interface
     */
     const char *get_mac_address();
     
     
     
     
     const char *get_gateway();

    /** Get the local network mask
     *
     *  @return         Null-terminated representation of the local network mask
     *                  or null if no network mask has been recieved
     */
     const char *get_netmask();
     
private:
    MXCHIP _mxchip;
    
    

};


#endif
