// 本作品采用知识共享 署名-非商业性使用-相同方式共享 3.0 未本地化版本 许可协议进行许可
// 访问 http://creativecommons.org/licenses/by-nc-sa/3.0/ 查看该许可协议
// ==============

// 版权所有：
// @老潘orz  wasdpkj@hotmail.com
// ==============

// Microduino-IDE
// ==============
// Microduino Getting start:
// http://www.microduino.cc/download/

// Microduino IDE Support：
// https://github.com/wasdpkj/Microduino-IDE-Support/

// ==============
// Microduino wiki:
// http://wiki.microduino.cc

// ==============
// E-mail:
// Kejia Pan
// pankejia@microduino.cc

// ==============
// Weibo:
// @老潘orz

#define _MAIN_CPP
#include "mbed.h"
#include "MicroduinoPinNames.h"
#include "Microduino_Matrix.h"
#include "SomeCartoon.h"

uint8_t Addr[MatrixPix_X][MatrixPix_Y] = {
    { 64}
};

static uint8_t logoA[] = {   //低位在前 逐行
    0x00, 0x66, 0x66, 0xDB, 0xDB, 0xDB, 0xDB, 0x00
};

static uint8_t logoB[] = {  //BMP File
    0x42, 0x4D, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x28, 0x00,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x01, 0x00, 0x18, 0x00, 0x00, 0x00,
    0x00, 0x00, 0xC2, 0x00, 0x00, 0x00, 0x20, 0x2E, 0x00, 0x00, 0x20, 0x2E, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xFF, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xEE, 0xEE, 0xEE, 0xEE, 0xDD, 0xEE, 0xEE,
    0xEE, 0x4D, 0x8E, 0x65, 0x26, 0x94, 0x50, 0x26, 0x94, 0x50, 0x26, 0x94, 0x50, 0x26, 0x94, 0x50,
    0x24, 0x60, 0x51, 0xEE, 0xEE, 0xDD, 0xEE, 0xEE, 0xEE, 0xDD, 0xBB, 0x99, 0xDD, 0xBB, 0x99, 0x4B,
    0x94, 0xD4, 0x2B, 0x69, 0x96, 0xCC, 0xBB, 0x84, 0xCC, 0xAA, 0x88, 0xFF, 0xEE, 0xDD, 0xFF, 0xEE,
    0xEE, 0xC7, 0xBB, 0x99, 0x50, 0xB2, 0x70, 0x26, 0x94, 0x50, 0x26, 0x94, 0x50, 0x47, 0x94, 0x4D,
    0xCC, 0xAA, 0x88, 0xEE, 0xEE, 0xDD, 0xEE, 0xEE, 0xEE, 0xDB, 0xCC, 0xB3, 0x53, 0xBB, 0x88, 0x53,
    0xBB, 0x88, 0x53, 0xBB, 0x88, 0x26, 0x94, 0x50, 0xB5, 0xAA, 0x92, 0xEE, 0xEE, 0xDD, 0xFF, 0xEE,
    0xEE, 0xDD, 0xDD, 0xCC, 0x53, 0xBB, 0x88, 0x3A, 0xD5, 0x95, 0x53, 0xBB, 0x88, 0x48, 0xAF, 0x50,
    0xCC, 0xAA, 0x99, 0xEE, 0xEE, 0xDD, 0xEE, 0xEE, 0xEE, 0xE2, 0xCB, 0xCD, 0x53, 0xBB, 0x88, 0x53,
    0xBB, 0x88, 0x3A, 0xD5, 0x95, 0x50, 0xB2, 0x70, 0xD6, 0xBB, 0xB1, 0xFF, 0xEE, 0xDD, 0xDD, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xFF, 0xEE, 0xEE, 0xEE, 0xEE, 0xFF, 0xEE, 0xEE, 0xEE, 0xEE, 0xEE,
    0xEE, 0xEE, 0xEE, 0xEE, 0xEE, 0xDD, 0x00, 0x00,
};

#define delay wait_ms
DigitalOut       myled(D13);
Matrix           display(Addr);
AnalogIn         gAnalogIn(A0);
Timer            g_Timer;
Serial           pc(D1, D0); // tx, rx

int main()
{
    int i;
    char buf[32];
    myled = 0;
    pc.baud(115200);
    g_Timer.start();

    for (int a = 0; a < display.getMatrixNum(); a++) {
        pc.printf("device add = %d", display.getDeviceAddr(a));
        pc.printf(" ");
    }
    pc.printf("\r\n");

    myled = !myled;
    display.clearDisplay();
    //setLedColor
    for (int y = 0; y < display.getHeight() * 8; y++) {
        for (int x = 0; x < display.getWidth() * 8; x++) {
            randomSeed(x);
            display.setLedColor(x, y, random(0, 255), random(0, 255), random(0, 255));   //x, y, r, g, b
            delay(20);
        }
    }
    delay(1000);
    myled = !myled;

    //setLed
    display.clearDisplay();
    display.setColor(255, 0, 0);
    for (int y = 0; y < display.getHeight() * 8; y++) {
        for (int x = 0; x < display.getWidth() * 8; x++) {
            display.setLed(x, y, true);   //x, y, sta
            delay(5);
        }
    }
    delay(1000);
    myled = !myled;

    //setLed
    display.clearDisplay();
    display.setColor(0, 255, 0);
    for (int y = 0; y < display.getHeight() * 8; y++) {
        for (int x = 0; x < display.getWidth() * 8; x++) {
            display.setLed(x, y, true);   //x, y, sta
            delay(5);
        }
    }
    delay(1000);
    myled = !myled;
    
    //setLed
    display.clearDisplay();
    display.setColor(0, 0, 255);
    for (int y = 0; y < display.getHeight() * 8; y++) {
        for (int x = 0; x < display.getWidth() * 8; x++) {
            display.setLed(x, y, true);   //x, y, sta
            delay(5);
        }
    }
    delay(1000);
    myled = !myled;

    display.clearDisplay();
    display.setColor(0, 255, 0);
    display.drawBMP(0, 0, 8, 8, logoA);  //x,y,w,h,data
    delay(2000);
    myled = !myled;

    display.clearDisplay();
    //Windows Bitmap (BMP) file,24bit
    display.drawBMP(0, 0, logoB);   //x,y,data
    delay(2000);
    myled = !myled;

    //clearColor
    display.clearColor();
    //writeString H
    display.writeString("Microduino", MODE_H, 20, 0); //string, MODE, time ,y
    display.clearDisplay();
    //writeString V
    display.writeString("Microduino", MODE_V, 20, 0); //string, MODE, time ,x
    display.clearDisplay();
    myled = !myled;
    while(1) {
        display.clearDisplay();
        drawCartoon01();
        display.clearDisplay();
        drawCartoon02();
        display.clearDisplay();
        drawCartoon03();
        
        display.setColor(random(0, 255), random(0, 255), random(0, 255));
        display.drawBox(0, 0, 8, 8);  //x,y,w,h
        delay(2000);
        display.clearDisplay();

        display.drawRBox(0, 0, 8, 8, 2);  //x,y,w,h,r
        delay(2000);
        display.clearDisplay();

        display.drawFrame(0, 0, 8, 8);  //x,y,w,h
        delay(2000);
        display.clearDisplay();

        display.drawRFrame(0, 0, 8, 8, 2);  //x,y,w,h,r
        delay(2000);
        display.clearDisplay();

        display.drawCircle(3, 3, 3);  //x,y,r
        delay(2000);
        display.clearDisplay();

        display.drawDisc(3, 3, 3);  //x,y,r
        delay(2000);
        display.clearDisplay();

        display.drawLine(0, 0, 7, 7); //x,y,x1,y1
        delay(2000);
        display.clearDisplay();

        i = display.getStringWidth("mCookie!");
        display.setColor(255, 255, 0);
        display.setFontMode(MODE_H);
        strcpy(buf, "mCookie!");
        for (int a = display.getWidth() * 8; a > -i - display.getWidth() * 8; a--) {
            display.setCursor(a, 0);   //x, y
            display.print(buf);
            delay(20);
        }
        display.clearDisplay();

        i = display.getStringHeight("mCookie!");
        display.setColor(255, 0, 255);
        display.setFontMode(MODE_V);
        for (int a = display.getHeight() * 8; a > -i - display.getHeight() * 8; a--) {
            display.setCursor(0, a);   //x, y
            display.print("mCookie!");
            delay(20);
        }
        display.clearDisplay();

        //Print
        int timer = g_Timer.read_ms();
        display.setColor(0, 255, 255);
        display.setFontMode(MODE_H);
        while (g_Timer.read_ms() - timer < 5000) {
            display.setCursor(0, 0);   //x, y
            display.print((g_Timer.read_ms() - timer) / 100);
            delay(20);
        }
        display.clearDisplay();

        //String to char*
        String _buffer_data = "Analog(A0):";
        //_buffer_data +=  analogRead(A0);
        _buffer_data += gAnalogIn.read_u16();

        char buffer_data[128];
        for (int a = 0; a < 128; a++) {
            buffer_data[a] = NULL;
        }

        for (int a = 0; a < _buffer_data.length(); a++) {
            buffer_data[a] = _buffer_data[a];
        }

        display.setColor(255, 255, 255);
        display.clearDisplay();
        display.writeString(buffer_data, MODE_H, 50, 1);
        myled = !myled;
    }
}