#include "SomeCartoon.h"
#include "mbed.h"
#include "Microduino_Matrix.h"

extern Matrix           display;
extern AnalogIn         gAnalogIn;
void randomSeed(unsigned long seed)
{
    if (seed != 0) {
        //srandom(seed);
        srand(seed);
    }
}

long random(long howbig)
{
    if (howbig == 0) {
        return 0;
    }
    return rand() % howbig;
}

long random(long howsmall, long howbig)
{
    if (howsmall >= howbig) {
        return howsmall;
    }
    long diff = howbig - howsmall;
    return random(diff) + howsmall;
}
/*
uint8_t donghua[128] = {
    0,0, 1,0, 2,0, 3,0, 4,0, 5,0, 6,0, 7,0,
    7,1, 7,2, 7,3, 7,4, 7,5, 7,6, 7,7,
    6,7, 5,7, 4,7, 3,7, 2,7, 1,7, 0,7,
    0,6, 0,5, 0,4, 0,3, 0,2, 0,1,
    1,1, 2,1, 3,1, 4,1, 5,1, 6,1,
};*/

void drawCartoon01(void)
{
    uint8_t r,g,b;
    randomSeed(gAnalogIn.read_u16());
    display.clearDisplay();
    int8_t x = 0;
    int8_t y = 0;
    int8_t xMax = 7;
    int8_t yMax = 7;
    int8_t xMin = 0;
    int8_t yMin = 0;
    uint8_t state = 0;
    r = random(0, 255);
    g = random(0, 255);
    b = random(0, 255);
    uint8_t times = 0;
    while (true) {
        display.setLedColor(x, y, r, g, b);   //x, y, r, g, b
        wait_ms(50);
        if (x == 3 && y == 4) {
            times++;
            if (times >=3) {
                break;
            }
            x = 0;
            y = 0;
            xMax = 7;
            yMax = 7;
            xMin = 0;
            yMin = 0;
            display.clearDisplay();
            wait_ms(200);
            state = 0;
            r = random(0, 255);
            g = random(0, 255);
            b = random(0, 255);
            display.setLedColor(0, 0, r, g, b);   //x, y, r, g, b
            //continue;
        }

        if (state == 0) {
            x++;
            if (x > xMax) {
                state = 1;
                x = xMax;
                y++;
            }
        } else if (state == 1) {
            y++;
            if (y > yMax) {
                state = 2;
                y = yMax;
                x--;
            }
        } else if (state == 2) {
            x--;
            if (x < xMin) {
                state = 3;
                x = xMin;
                y--;
            }
        } else if (state == 3) {
            y--;
            if (y == yMin) {
                state = 0;
                y = yMin+1;
                x++;
                xMax--;
                yMax--;
                xMin++;
                yMin++;
            }
        }
    }
}

void drawCartoon02(void)
{
    uint8_t times = 0;
    int8_t x,y,x1,y1;

doCartoon:
    display.setColor(random(0, 255), random(0, 255), random(0, 255));
    x = 0;
    y = 0;
    x1 = 7;
    y1 = 7;
    while (x < 8) {
        display.drawLine(x, y, x1, y1);//x,y,x1,y1
        wait_ms(200);
        x++;
        y1--;
    }
    x = 0;
    y = 1;
    x1 = 6;
    y1 = 7;
    while (y < 8) {
        display.drawLine(x, y, x1, y1);//x,y,x1,y1
        wait_ms(200);
        y++;
        x1--;
    }
    times++;
    if (times >= 3) {
        return;
    }
    wait_us(2000000);
    display.clearDisplay();
    goto doCartoon;
}

void drawCartoon03(void)
{
    uint8_t times = 0;
    int8_t x = 0;
    int8_t y = 0;
    int8_t w = 8;
    int8_t h = 8;
doCartoon:
    display.setColor(random(0, 255), random(0, 255), random(0, 255));
    while (x < 4) {
        display.clearDisplay();
        display.drawBox(x, y, w, h);  //x,y,w,h
        wait_ms(500);
        x++;
        y++;
        w -= 2;
        h -= 2;
    }
    display.clearDisplay();
    times++;
    if (times >= 3) {
        return;
    }
    wait_ms(2000);
    x = y = 0;
    w = h = 8;
    goto doCartoon;
}