#include "MicroduinoPinNames.h"
#include "Config.h"
#include "AM2321.h"

extern Serial pc;
extern Timer g_MainTimer;
#define INTERVAL_pm25    200

//SoftwareSerial pmSerial(4,5);   //PM2.5传感器通讯软串口
#ifdef OPEN_PM25
Serial pmSerial(D5, D4); //tx,rx
#endif
AnalogIn gLight(A0);
AnalogIn gCH4(A2);
AM2321 am2321;

float sensor_tem,sensor_hum,sensor_light,Sensor_etoh;

float sensorPM25 = 0.6;

long map(long x, long in_min, long in_max, long out_min, long out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

#ifdef OPEN_PM25
void PM25_init(void)
{
    //pc.printf("Enter PM25_init\r\n");
    pmSerial.baud(2400);
}

// 读取PM2.5传感器
void PM25()
{
    //pc.printf("Enter PM25()\r\n");
    int data_s = 0;    //串口接收数据
    int num = -1;      //串口接收数据计数
    int sum = 0;       //校验和
    int cal[6];        //接收数据缓存
    float dustDensity = 0;  //PM2.5浓度

    //pmSerial.begin(2400);   //首先启动软串口
    //pmSerial.baud(2400);
    //pmSerial.flush();       //清空串口缓存

    uint32_t start = g_MainTimer.read_ms();
    while(true) {//避免无限循环
        uint32_t nowTime = g_MainTimer.read_ms();
        if (nowTime - start > 100) {
            break;
        }
        //pc.printf("PM25:while(1)\r\n");
        //if(pmSerial.available() > 0) { //串口缓存有数据
        if (pmSerial.readable() > 0) {
        //if ((data_s = pmSerial.getc()) != 0) {
            //myled = 0;
            //pc.printf("readable() > 0\r\n");
            //data_s = pmSerial.read();   //读取串口缓存数据
            data_s = pmSerial.getc();
            if(data_s == 0xAA) {         //得到数据帧起始位
                num = 0;                  //开始计数
            } else if(num >= 0) {
                num++;                //读到数据，计数+1
                cal[num-1] = data_s;  //数据保存到缓存中
                if(num == 6) {         //读到数据帧最后一位
                    sum = cal[0] + cal[1] + cal[2] + cal[3];  //计算校验和
                    if(sum == cal[4] && cal[5] == 0xFF) {     //校验和匹配，数据帧最后一位为0xFF，说明接收的数据帧正常
                        dustDensity = (cal[0]*256 + cal[1])*(5.0/1024)*550;   //计算PM2.5浓度，单位ug/m3
                    } else {   //接收的数据不正常
                        dustDensity = 0;    //浓度清零
                    }
                    break;
                }
            }
        }
    }
    //pmSerial.end();     //关闭软串口
    //return dustDensity; //返回值
    sensorPM25 = dustDensity;
    //pc.printf("sensorPM25 = %f\r\n", sensorPM25);
}
#endif

#if 0
// 读取光照传感器
void updateLight()
{
    //sensor_light = map(analogRead(A0), 0, 1023, 0, 255);
    //float lvf = gLight;
    int lt = (int)(gLight.read()*1024.0);
    
    //pc.printf("light = %d, lvf = %f\r\n", lt, lvf);
    sensor_light = map(lt, 0, 1024, 0, 255);// 这里和Arduino不一样，不知道为什么
    
}
#else
void updateLight(void)
{
    uint16_t lt = gLight.read_u16();
    pc.printf("lt0 = 0x%x, ", lt);
    lt = lt & 0x03FF;// 10bit
    //lt = lt >> 2;
    //lt = (lt & 0x0FFF)>>2;
    //lt = (lt >> 2) & 0x03FF;
    sensor_light = map(lt, 0, 1023, 0, 255);
    //sensor_light = map(lt, 0, 65535, 0, 65535);
    pc.printf("lt=0x%x, sensor_light=%f\r\n", lt, sensor_light);
    sensorPM25 += 1.0;
}
#endif

// 读取甲醛传感器
void updateCH4()
{
    //Sensor_etoh = map(analogRead(A2), 0, 1023, 0, 30);
    uint16_t ch4 = gCH4.read_u16();
    //ch4 = ch4 & 0x03FF;
    //Sensor_etoh = map(ch4, 0, 1023, 0, 30);
    Sensor_etoh = map(ch4, 0, 65535, 0, 30);
    //pc.printf("CH4 = %d\r\n", ch4);
}

// 读取温湿度传感器
void updateTempHumi(void)
{
    static uint32_t lstTime = 0;
    uint32_t nowTime = g_MainTimer.read_ms();
    pc.printf("Enter updateTempHumi(), lstTime:%ums, nowTime:%u, cha:%u\r\n", lstTime, nowTime, nowTime - lstTime);
    if (nowTime - lstTime < 2000) {
        return;
    }
    am2321.read();
    sensor_tem = am2321.temperature / 10.0;
    sensor_hum = am2321.humidity / 10.0;
    //pc.printf("%u:temp = %.1f, hum = %.1f\r\n",cot, sensor_tem, sensor_hum);
    lstTime = g_MainTimer.read_ms();
}
