/*
 * Io_moon(木卫一) is a project name.
 * Io_moon port ESP8266BlynkWeatherStation from Microduino Core+ to LPC824.
 *
 * ref:
 * http://wiki.microduino.cn/index.php/开源WiFi气象站系统/zh
 * https://github.com/Microduino/ESP8266BlynkWeatherStation
 */
#include "mbed.h"

#include "Config.h"
#include "MicroduinoPinNames.h"
DigitalOut myled(P0_20);
I2C g_i2c(P0_11, P0_10);//SDA, SCL
Timer g_MainTimer;
Ticker g_Ticker;
#include "SimpleTimer.h"
#include "userDef.h"
#include "sensor.h"
#ifdef OPEN_OLED
#include "oled.h"
#endif
#ifdef OPEN_BLYNK
#include "WiFiBlynk.h"
#endif
Serial pc(P0_4, P0_0); // tx, rx

void led_flash()
{
#if 0
    static int cot = 0;
    cot++;
    if (cot > 4) {
        g_Timer.reset();
        cot = 0;
    }
#endif
    myled = 1;
    wait_ms(70);
    myled = 0;
}

static void led_flash_fast()
{
    myled = !myled;
}

#ifdef OPEN_OLED
Adafruit_SSD1306_I2c adaf(g_i2c, P0_13, 0x78, 64, 128);
void update_oled()
{
    static uint32_t start;
    start = g_MainTimer.read_ms();
    //pc.printf("update_oled: %u ms\r\n", start);
    myled = 1;
    wait_ms(60);
    myled = 0;
    oled(adaf, sensor_tem, sensor_hum, sensor_light, sensorPM25, Sensor_etoh);
}
#endif

int main()
{
    g_Ticker.attach_us(led_flash_fast, 40000);
    pc.baud(115200);
    pc.printf("Enter main()\r\n");
    g_MainTimer.start();
    SimpleTimer gSimpleTimer;

    // Setup a function to be called every second
#ifdef OPEN_BLYNK
    gSimpleTimer.setInterval(2000, senTempHumi);
    gSimpleTimer.setInterval(3000, sendLight);
    gSimpleTimer.setInterval(4000, sendCH4);
    gSimpleTimer.setInterval(5000, sendPM25);
#endif
    gSimpleTimer.setInterval(1001, updateLight);
    gSimpleTimer.setInterval(4002, updateCH4);
    gSimpleTimer.setInterval(4001, updateTempHumi);
#ifdef OPEN_PM25
    gSimpleTimer.setInterval(3000, PM25);
#endif
    gSimpleTimer.setInterval(4000, led_flash);
#ifdef OPEN_OLED
    gSimpleTimer.setInterval(2000, update_oled);
#endif
#ifdef OPEN_PM25
    PM25_init();
#endif
    wait_ms(2000);
#ifdef OPEN_OLED
    oled_init(adaf);
#endif
#ifdef OPEN_BLYNK
    /*
     * Set ESP8266 baud rate
     * 在LPC824上，波特率设为115200时，ESP8266无法工作
     */
    #define TARGET_BAUD 9600
    EspSerial.baud(115200);
    wifi.setUart(TARGET_BAUD, 2);
    EspSerial.baud(TARGET_BAUD);
    wait(2.0);

    Blynk.begin(auth, wifi, SSID, PASS);
    wait(3.0);
#endif
    g_Ticker.detach();

    while(1) {
        //pc.printf("Enter while(1)\r\n");
        //myled = !myled;
        gSimpleTimer.run();
#ifdef OPEN_BLYNK
        Blynk.run(); // All the Blynk Magic happens here...
#endif

    }
}
