/**
 * @file       BlynkSimpleShieldEsp8266.h
 * @author     Volodymyr Shymanskyy
 * @license    This project is released under the MIT License (MIT)
 * @copyright  Copyright (c) 2015 Volodymyr Shymanskyy
 * @date       Jun 2015
 * @brief
 *
 */

#ifndef BlynkSimpleShieldEsp8266_h
#define BlynkSimpleShieldEsp8266_h

#ifdef ESP8266
#error This code is not intended to run on the ESP8266 platform! Please check your Tools->Board setting.
#endif

//extern Timer g_Timer;

#ifndef BLYNK_INFO_CONNECTION
#define BLYNK_INFO_CONNECTION  "ESP8266"
#endif


extern Serial pc;
//#define LOG_ESP8266
#ifdef LOG_ESP8266
#define ESP8266_LOG pc.printf
#define LOG_ENTER ESP8266_LOG("Enter %s\r\n", __func__);
#else
#define ESP8266_LOG(...)
#define LOG_ENTER
#endif

#define BLYNK_MICRODUINO
//#define BLYNK_SEND_ATOMIC

// TODO: Remove this hotfix
//#define BLYNK_NO_INFO

#include <BlynkApiMbed.h>
#include <Blynk/BlynkProtocol.h>
#include <utility/BlynkFifo.h>
#include <ESP8266_Lib.h>

class BlynkTransportShieldEsp8266
{
    static void onData(uint8_t mux_id, uint32_t len, void* ptr) {
        ((BlynkTransportShieldEsp8266*)ptr)->onData(mux_id, len);
    }

    void onData(uint8_t mux_id, uint32_t len) {
        //BLYNK_LOG2("Got ", len);
        ESP8266_LOG("onData(),mux_id=%d,len=%u\r\n", mux_id,len);
        while (len) {
            if (client->getUart()->readable()) {
                uint8_t b = client->getUart()->getc();
                if(!buffer.push(b)) {
                    BLYNK_LOG1(BLYNK_F("Buffer overflow"));
                }
                len--;
            }
        }
    }

public:
    BlynkTransportShieldEsp8266()
        : client(NULL)
        , status(false)
        , domain(NULL)
        , port(0)
    {}

    void begin_domain(ESP8266* esp8266, const char* d,  uint16_t p) {
        LOG_ENTER;
        client = esp8266;
        client->setOnData(onData, this);
        domain = d;
        port = p;
    }

    bool connect() {
        uint32_t startTime = g_BlynkTimer.read_ms();
        ESP8266_LOG("connect(), domain = %s, port = %d\r\n", domain, port);
        pc.printf("connect(), domain = %s, port = %d, startTime=%u\r\n", domain, port, startTime);
        if (!domain || !port)
            return false;
        status = client->createTCP(domain, port);
        ESP8266_LOG("status = %d\r\n", status);
        return status;
    }

    void disconnect() {
#if 1
        LOG_ENTER;
        status = false;
        buffer.clear();
        client->releaseTCP();
#endif
    }

    size_t read(void* buf, size_t len) {
        //uint32_t start = g_BlynkTimer.read_ms();
        ESP8266_LOG("Waiting: %d, Occuied: %d\r\n", len, buffer.getOccupied());
        //uint32_t start = millis();
        //buffer.dump();
        uint32_t start = g_BlynkTimer.read_ms();
        //BLYNK_LOG4("Waiting: ", len, " Occuied: ", buffer.getOccupied());
        while ((buffer.getOccupied() < len) && (g_BlynkTimer.read_ms() - start < 1500)) {
            client->run();
        }
        return buffer.read((uint8_t*)buf, len);
    }

    size_t write(const void* buf, size_t len) {
        ESP8266_LOG("Enter write, len = %d\r\n", len);
        if (client->send((const uint8_t*)buf, len)) {
            return len;
        }
        return 0;
    }

    bool connected() {
        //LOG_ENTER
        return status;
    }

    int available() {
        client->run();
        //BLYNK_LOG2("Still: ", buffer.getOccupied());
        return buffer.getOccupied();
    }

private:
    ESP8266* client;
    bool status;
    BlynkFifo<uint8_t,256> buffer;
    const char* domain;
    uint16_t    port;
};

class BlynkWifi
    : public BlynkProtocol<BlynkTransportShieldEsp8266>
{
    typedef BlynkProtocol<BlynkTransportShieldEsp8266> Base;
public:
    BlynkWifi(BlynkTransportShieldEsp8266& transp)
        : Base(transp)
        , wifi(NULL) {
        //pc.printf("Enter BlynkWifi(BlynkTransportShieldEsp8266& transp)\r\n");
        //g_BlynkTimer.start();
    }

    bool connectWiFi(const char* ssid, const char* pass) {
        //int nowtime = millis();
        int nowtime = g_BlynkTimer.read_ms();
        ESP8266_LOG("connectWiFi: ssid=%s, pass=%s, nowtime=%u\r\n", ssid, pass, nowtime);
        wait_ms(500);
        BLYNK_LOG2(BLYNK_F("Connecting to "), ssid);
        /*if (!wifi->restart()) {
            BLYNK_LOG1(BLYNK_F("Failed to restart"));
            return false;
        }*/
        if (!wifi->setEcho(0)) {
            BLYNK_LOG1(BLYNK_F("Failed to disable Echo"));
            ESP8266_LOG(BLYNK_F("Failed to disable Echo"));
            return false;
        }
        if (!wifi->setOprToStation()) {
            BLYNK_LOG1(BLYNK_F("Failed to set STA mode"));
            ESP8266_LOG(BLYNK_F("Failed to set STA mode"));
            return false;
        }
        if (wifi->joinAP(ssid, pass)) {
            BLYNK_LOG2(BLYNK_F("IP: "), wifi->getLocalIP().c_str());
            ESP8266_LOG(BLYNK_F("IP: %s\r\n"), wifi->getLocalIP().c_str());
        } else {
            BLYNK_LOG1(BLYNK_F("Failed to connect WiFi"));
            ESP8266_LOG(BLYNK_F("Failed to connect WiFi"));
            return false;
        }
        if (!wifi->disableMUX()) {
            BLYNK_LOG1(BLYNK_F("Failed to disable MUX"));
            ESP8266_LOG(BLYNK_F("Failed to disable MUX"));
        }
        BLYNK_LOG1(BLYNK_F("Connected to WiFi"));
        int nowtime1 = g_BlynkTimer.read_ms();
        ESP8266_LOG("Connected to WiFi...%dms\r\n", nowtime1 - nowtime);
        return true;
    }

    void config(ESP8266&    esp8266,
                const char* auth,
                const char* domain = BLYNK_DEFAULT_DOMAIN,
                uint16_t    port   = BLYNK_DEFAULT_PORT) {
        LOG_ENTER;
        Base::begin(auth);
        wifi = &esp8266;
        this->conn.begin_domain(wifi, domain, port);
    }

    void begin(const char* auth,
               ESP8266&    esp8266,
               const char* ssid,
               const char* pass,
               const char* domain = BLYNK_DEFAULT_DOMAIN,
               uint16_t    port   = BLYNK_DEFAULT_PORT) {
        ESP8266_LOG("Enter begin, auth=%s\r\n", auth);
        config(esp8266, auth, domain, port);
        connectWiFi(ssid, pass);
    }

private:
    ESP8266* wifi;
};

static BlynkTransportShieldEsp8266 _blynkTransport;
BlynkWifi Blynk(_blynkTransport);

#include <BlynkWidgets.h>

#endif

