#include "mbed.h"

#include "Config.h"
#include "MicroduinoPinNames.h"
DigitalOut myled(P0_20);
I2C g_i2c(P0_11, P0_10);//SDA, SCL
#include "SimpleTimer.h"
#include "userDef.h"
#include "sensor.h"
#ifdef OPEN_OLED
#include "oled.h"
#endif
#include "WiFiBlynk.h"

Serial pc(P0_4, P0_0); // tx, rx
Timer g_Timer;
Ticker g_Ticker;

void led_flash()
{
    static int count = 0;
    count++;
    //pc.printf("count : %d, ms : %d\r\n", count, g_Timer.read_ms());
    myled = 1;
    wait_ms(70);
    myled = 0;
}

static void led_flash_fast()
{
    myled = !myled;
}

#ifdef OPEN_OLED
Adafruit_SSD1306_I2c adaf(g_i2c, P0_13, 0x78, 64, 128);
void update_oled()
{
    myled = 1;
    wait_ms(70);
    myled = 0;
    oled(adaf, sensor_tem, sensor_hum, sensor_light, sensorPM25, Sensor_etoh);
}
#endif

int main()
{
    g_Ticker.attach_us(led_flash_fast, 30000);
    pc.baud(115200);
    pc.printf("Enter main()\r\n");
    //myled = 1;
    g_Timer.start();
    SimpleTimer gSimpleTimer(g_Timer);

    /*
     * Set ESP8266 baud rate
     * 在LPC824上，波特率设为115200时，ESP8266是无法工作
     */
    EspSerial.baud(9600);

    Blynk.begin(auth, wifi, SSID, PASS);
    wait(5.0);
    g_Ticker.detach();
    
    // Setup a function to be called every second
    gSimpleTimer.setInterval(2000L, senTempHumi);
    gSimpleTimer.setInterval(1000, updateLight);
    gSimpleTimer.setInterval(5000, updateCH4);
    gSimpleTimer.setInterval(4000, updateTempHumi);
    //gSimpleTimer.setInterval(3000, PM25);
    gSimpleTimer.setInterval(4000, led_flash);
#ifdef OPEN_OLED
    gSimpleTimer.setInterval(1000, update_oled);
#endif
    //PM25_init();
    wait_ms(2000);
#ifdef OPEN_OLED
    oled_init(adaf);
#endif
    int pretime = g_Timer.read_ms();
    while(1) {
        //pc.printf("Enter while(1)\r\n");
        //myled = !myled;
        Blynk.run(); // All the Blynk Magic happens here...
        gSimpleTimer.run();
#if 0
        int curtime = g_Timer.read_ms();
        if (curtime - pretime > 4000) {
            //updateTempHumi();
            led_flash();
            pretime = curtime;
        }
#endif

    }
}
