#include "mbed.h"
//#include "rtos.h"
#include "MicroduinoPinNames.h"
#include "userDef.h"
#include "Protocol.h"
#include "Microduino_Motor.h"

Timer g_cubeTimer;
#if 1
Motor MotorLeft(motor_pin0A, motor_pin0B);
Motor MotorRight(motor_pin1A, motor_pin1B);
///////////////////////////////////////////////////////////
#define CHANNEL_NUM 8
uint16_t channalData[CHANNEL_NUM]; //8通道数据
bool mode = 0; //nrf或者ble模式
int16_t throttle = 0; //油门
int16_t steering = 0; //转向
int safe_ms = 0;

//Serial pc(P0_4,P0_0);

static long map(long x, long in_min, long in_max, long out_min, long out_max)
{
    return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

int main()
{
    bool freeFlag = true;
    g_cubeTimer.start();
    mode = protocolSetup();  //遥控接收器初始化

    MotorLeft.Fix(motor_fixL);
    MotorRight.Fix(motor_fixR);
    //pc.baud(115200);
    while(1) {
        if (protocolRead(channalData, mode)) { //判断是否接收到遥控信号
            throttle = map(channalData[CHANNEL_THROTTLE], 1000, 2000, -MAX_THROTTLE, MAX_THROTTLE);
            steering = map(channalData[CHANNEL_STEERING], 1000, 2000, -MAX_STEERING, MAX_STEERING);

            MotorLeft.Driver(MotorLeft.GetData(throttle, steering, CHAN_LEFT));
            MotorRight.Driver(MotorRight.GetData(throttle, steering, CHAN_RIGHT));

#ifdef _DEBUG
asdf
            Serial.print("DATA OK :[");
            for (int a = 0; a < CHANNEL_NUM; a++) {
                Serial.print(channalData[a]);
                Serial.print(" ");
            }
            Serial.print("],throttle:");
            Serial.print(throttle);
            Serial.print(",steering:");
            Serial.println(steering);
#endif
            safe_ms = g_cubeTimer.read_ms();
        }
#if 0
        if (safe_ms > g_cubeTimer.read_ms()) {
            safe_ms = g_cubeTimer.read_ms();
        }
        if (g_cubeTimer.read_ms() - safe_ms > SAFE_TIME_OUT) {
            MotorLeft.Free();
            MotorRight.Free();
            //MotorLeft.Brake();
            //MotorRight.Brake();
        }
#endif
        //pc.printf("Hello world\r\n");
        //sleep();
    }
}
#else
DigitalOut myled(D13);
PwmOut PWM_A(motor_pin0A);
PwmOut PWM_B(motor_pin0B);
int pv = 0;
int main()
{
    myled.write(1);
    PWM_A.period_us(255);
    PWM_B.period_us(255);
    
    PWM_A.pulsewidth_us(200);
    PWM_B.pulsewidth_us(0);
    while (1)
    {
        #if 0
        PWM_B.pulsewidth_us(pv);
        pv++;
        #endif
        wait(0.5);
        myled = !myled;
        if (pv >= 255)
        {
            pv = 0;
        }
    }
}
#endif