#ifndef _MICRODUINO_PROTOCOL_HARDSER_H
#define _MICRODUINO_PROTOCOL_HARDSER_H

#include "mbed.h"

#define PRO_PORT Serial

enum p_sta {
    P_ERROR,
    P_BUSY,
    P_NONE,
    P_FINE,
    P_TIMEOUT,
};

#define MODE_WHILE 1
#define MODE_LOOP 0

#define BUFFER_MAX 256
#define CHANNEL_NUM 8
#define TYPE_NUM 0xC8

class Protocol {
  public:
    Protocol(PRO_PORT *ser , uint8_t _channel) : num(0),time(0),sta(false),error(false){ // Constructor when using HardwareSerial
      //  common_init();  // Set everything to common state, then...
      channel = _channel;
      num = 0;
      sta = false;
      error = false;
      P_Serial = ser; // ...override P_Serial with value passed.
      //_timer.start();
    }
    void begin(uint16_t _baud);
    uint8_t parse(uint16_t* _data, bool _mod);

  private:
    uint8_t inChar, inCache;
    uint8_t buffer[BUFFER_MAX];
    uint8_t channel;
    uint32_t num ;
    uint32_t time;
    bool sta;
    bool error;

    bool available(bool _sta);
    PRO_PORT *P_Serial;
    
    
};


#endif