#include "mbed.h"

#define WAIT_TIME_MS 1000 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

int main()
{
    int i = 0;
    printf("Bare metal code on Mbed OS %d.%d.%d.\n", MBED_MAJOR_VERSION, MBED_MINOR_VERSION, MBED_PATCH_VERSION);

    for( i=0; i<20; i++) {
        led1 = led2 = led3 = 1;
        thread_sleep_for(100);
        led1 = led2 = led3 = 0;
        thread_sleep_for(100);
    }

    i = 0;

    while (true)
    {
        led1 = !led1;
        led2 = !led1;
        led3 = !led2;
        i++;
        printf("Time: %d\n", i);
        thread_sleep_for(WAIT_TIME_MS);
    }
}
