//
//
//

#include "mbed.h"
#include "EthernetInterface.h"

//#define     USE_DHCP


const char cip[] = "192.168.2.89";
const char cmask[] = "255.255.255.0";
const char cgateway[] = "192.168.2.1";

//const char* ECHO_SERVER_ADDRESS = "192.168.2.2";
const char* ECHO_SERVER_ADDRESS = "192.168.2.88";
const int ECHO_SERVER_PORT = 7;


int iCount = 0;
#define ICOUNT_MAX  10000


//
//
//

Serial pc(USBTX, USBRX);


//
//
//

int main() 
{
  pc.baud(115200);
    
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("--------------------------------\n");
    pc.printf("Program starts ...\n");
    
    
    EthernetInterface eth;

#ifdef  USE_DHCP    
    //eth.init(); //Use DHCP
    int init_rtn = eth.init(); //Use DHCP
#else

    // fix ip address
        
    int init_rtn = eth.init(cip,       //const char *    ip,
                         cmask,     //const char *    mask,
                         cgateway   //const char *    gateway 
                        );

#endif


    pc.printf("init() return : %d\n", init_rtn);

    pc.printf("\n");
    pc.printf(" wait for ethernet connect()......\n");
    pc.printf("\n");

    int connect_rtn = eth.connect();
    pc.printf("connect() return : %d\n", connect_rtn);
    
    //eth.connect();
    pc.printf("\nClient IP Address is %s\n", eth.getIPAddress());

    pc.printf("\n");
    pc.printf(" connect to tcp socket server......\n");
    pc.printf("\n");


    // Connect to Server
    TCPSocketConnection socket;

send_loop:
        
    while (socket.connect(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT) < 0) 
    {
        pc.printf("Unable to connect to (%s) on port (%d)\n", ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
        wait(2);
    }
    
    pc.printf("Connected to Server at %s\n",ECHO_SERVER_ADDRESS);
    pc.printf("\n");
    
    // Send message to server
    char hello[] = "Hello World";
    pc.printf("Sending  message to Server : '%s' \n",hello);

    int isend_all_rtn = socket.send_all(hello, sizeof(hello) - 1);
    pc.printf("chars send : %d\n", isend_all_rtn);
    pc.printf("\n");
    
    // Receive message from server
    char buf[256];
    int n = socket.receive(buf, 256);
    buf[n] = '\0';  // end of line
    
    pc.printf("Received message from server: '%s'\n", buf);
    
    // Clean up
    //socket.close();
    int iclose = socket.close();
    pc.printf("\n");
    pc.printf("sock.close return : %d\n", iclose);
    pc.printf("\n");
    
    iCount++;
    pc.printf("send # : %d\n", iCount);
    
    if ( iCount < ICOUNT_MAX )
    {
        wait(3);
        
        goto send_loop;
        
    }
        

    eth.disconnect();
    int idisconn = eth.disconnect();
    
    pc.printf("\n");
    pc.printf("disconnect return : %d\n", idisconn);

 
    pc.printf("--------------------------------\n");
    pc.printf("\n");
    pc.printf("\n");
    
    while(true) {}
}

// override the default weak function to provide a specific mac address
extern "C" void mbed_mac_address(char *mac)
{
    mac[0] = 0x00;
    mac[1] = 0x50;
    mac[2] = 0x56;
    mac[3] = 0xC0;
    mac[4] = 0x00;
    mac[5] = 0xAB;
};
