//
//
//

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"

//
//
//

EthernetInterface eth;

RawSerial pc(USBTX, USBRX); // tx, rx

int main()
{
    pc.baud(9600);
    
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("--------------------------------\n");
    pc.printf("Program starts ...\n");
    
//    eth.init(); //Use DHCP
    int init_rtn = eth.init(); //Use DHCP

    pc.printf("init() return : %d\n", init_rtn);

    pc.printf("\n");
    pc.printf(" wait for ethernet connect()......\n");
    pc.printf("\n");


//    eth.connect();
    int connect_rtn = eth.connect();
    pc.printf("connect() return : %d\n", connect_rtn);
    
    printf("IP Address is %s \n\r", eth.getIPAddress());

    pc.printf("IP Address is %s\n", eth.getMACAddress());
    pc.printf("\n");



    
    pc.printf("wait for socket server, 15 second ....\n");
    pc.printf("\n");
    

    TCPSocketConnection socket;

    // Initialize ifttt object, add up to 3 optional values, trigger event.
    IFTTT ifttt("hellowordmbed","ExqSjQiwzZINRMFTOgo--", &socket); // EventName, Secret Key, socket to use
    ifttt.addIngredients("this is awesome","test-ing","data!!!");     // 3 optional Values to send along with trigger.
    ifttt.trigger();

    // Send data using GET
    ifttt.addIngredients("Sending","GET","data");
    ifttt.trigger(IFTTT_GET);

    // Send Data using POST
    ifttt.addIngredients("Sending","POST","things");
    ifttt.trigger(IFTTT_POST);

    eth.disconnect();
    while(1) {
    }
}

// override the default weak function to provide a specific mac address
extern "C" void mbed_mac_address(char *mac)
{
    mac[0] = 0x00;
    mac[1] = 0x50;
    mac[2] = 0x56;
    mac[3] = 0xC0;
    mac[4] = 0x00;
    mac[5] = 0xAB;
};
