#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPSocketConnection.h"

const char cip[] = "192.168.10.89";
const char cmask[] = "255.255.255.0";
const char cgateway[] = "192.168.10.202";

EthernetInterface eth;
RawSerial pc(USBTX, USBRX); // tx, rx


int main()
{
    pc.baud(9600);
    
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("--------------------------------\n");
    pc.printf("Program starts ...\n");
    //eth.init(); //Use DHCP
    
    // fix ip address
        
    int init_rtn = eth.init(cip,       //const char *    ip,
                         cmask,     //const char *    mask,
                         cgateway   //const char *    gateway 
                        );
                        
    pc.printf("init() return : %d\n", init_rtn);

    pc.printf("\n");
    pc.printf(" wait for ethernet connect()......\n");
    pc.printf("\n");
    
    //    eth.connect();
    int connect_rtn = eth.connect();
    pc.printf("connect() return : %d\n", connect_rtn);
    
    printf("IP Address is %s \n\r", eth.getIPAddress());

    pc.printf("IP Address is %s\n", eth.getMACAddress());
    pc.printf("\n");
    
    
    TCPSocketConnection socket;
    
    int isocket_connect = socket.connect("maker.ifttt.com", 80);
    pc.printf("socket connectted... %d\n", isocket_connect);
    
    /*
    char str[]="";
    char *post = "POST /trigger/OWJMAN/with/key/bkJhw8soKcjx28zrqAgeW2 HTTP/1.1\r\n";
    char *host = "Host: maker.ifttt.com\r\n";
    char *type = "Content-Type: application/json\r\n\r\n";
    char contentLen[50] = {0};
    char *data = "{\"value1\":\"this is awesome\",\"value2\":\"test-ing\",\"value3\":\"data!!!\"}\r\n";
    sprintf(contentLen,"Content-Length: %d\r\n",strlen(data));
    sprintf(str,"%s%s%s%s%s",post,host,contentLen,type,data);
    socket.send_all(str, strlen(str));*/
    
    char *post = "POST /trigger/helloworld/with/key/brbeSCjegrJbPkzvV-v0uc HTTP/1.1\r\n";
    char *host = "Host: maker.ifttt.com\r\n";
    char *type = "Content-Type: application/json\r\n\r\n";
    char contentLen[] = "";
    char *data = "{\"value1\":\"this is awesome\",\"value2\":\"test-ing\",\"value3\":\"data!!!\"}\r\n";
        
    sprintf(contentLen,"Content-Length: %d\r\n",strlen(data));

    int i_post, i_host, i_type, i_content, i_data;

    pc.printf("Post: %s", post);
    i_post = socket.send_all(post, strlen(post));
    pc.printf("Post: %d\n", i_post);
    
    pc.printf("Host: %s", host);
    i_host = socket.send_all(host, strlen(host));
    pc.printf("Host: %d\n", i_host);
    
    pc.printf("Type: %s", type);
    i_type = socket.send_all(type, strlen(type));
    pc.printf("Type: %d\n", i_type);
    
    pc.printf("Content length: %s", contentLen);
    i_content = socket.send_all(contentLen, strlen(contentLen));
    pc.printf("Content: %d\n", i_content);
    
    pc.printf("Data: %s", data);
    i_data = socket.send_all(data, strlen(data));
    pc.printf("Data: %d\n", i_data);
     
    char buffer[600];
    int ret;
    while (true) {
        ret = socket.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
    printf("DONE!\n");
      
    int i_close;  
      
    i_close = socket.close();
    pc.printf("Socket close: %d\n", i_close);
    
    eth.disconnect();
    
    pc.printf("\n");
    pc.printf("\n");
    pc.printf("Program end....\n");
    pc.printf("\n");
    pc.printf("\n");
    
    while(1) {}
}
extern "C" void mbed_mac_address(char *mac)
{
    mac[0] = 0x00;
    mac[1] = 0x50;
    mac[2] = 0x56;
    mac[3] = 0xC0;
    mac[4] = 0x00;
    mac[5] = 0xAB;
};
