#include <mbed.h>
#include <motordriver.h>
//pc interface
Serial pc(USBTX, USBRX); // tx, rx
//declare motors
Motor A(p22, p6, p5, 1); // pwm, fwd, rev, can break
Motor B(p21, p7, p8, 1); // pwm, fwd, rev, can break
//debugging stuff, switches a new led on after each sqeuence.
DigitalOut led1 (LED1);
DigitalOut led2 (LED2);
DigitalOut led3 (LED3);
DigitalOut led4 (LED4);

int main() {
    pc.printf("motor A, reverse to foward \n");
    pc.printf("motor B, reverse to foward \n\n");

    pc.printf("state motor A, %f, state motor B, %f \n\n", A.state(), B.state());
    //should be 2.
    led1=1;

    for (float s=-1.0; s < 1.0 ; s += 0.01) {//sweep from reverse to foward
        pc.printf("A %f %f \n",A.speed(s), s);
        pc.printf("B %f %f \n\n",B.speed(s), s);
        //should follow the output of the for loop
        wait(0.02);
    }
    pc.printf("state motor A, %f, state motor B, %f \n\n", A.state(), B.state());
    //should be 0.99 0.99.
    
    led2=1;

    pc.printf("\nmotor A, braking \n");
    pc.printf("motor B, braking \n\n");

    pc.printf("A %f 0.5 \n",A.stop(0.5));
    pc.printf("B %f 0.5 \n",B.stop(0.5));

    pc.printf("\nstate motor A, %f, state motor B, %f \n\n", A.state(), B.state());
    //should be -2 -2.
    
        for (float s=-1.0; s < 1.0 ; s += 0.01) {//sweep motors in opposite directions
        pc.printf("A %f %f \n",A.speed(-s), s);
        pc.printf("B %f %f \n\n",B.speed(s), s);
        //should follow the output of the for loop
        wait(0.02);
    }
    pc.printf("state motor A, %f, state motor B, %f \n\n", A.state(), B.state());
    //should be -1 0.99.
    
    led3=1;
    wait(1);

    pc.printf("motor A, coasting \n");
    pc.printf("motor B, coasting \n\n");

    A.coast();
    B.coast();
    pc.printf("state motor A, %f, state motor B, %f \n end\n end\n", A.state(), B.state());
    //should be 2 2.
    led4=1;
}