/*motor driver libary modified from the following libary,
*  
* mbed simple H-bridge motor controller
* Copyright (c) 2007-2010, sford
* 
* by Christopher Hasler.
* 
* from sford's libary,
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/
 
#ifndef MBED_MOTORCS_H
#define MBED_MOTORCS_H
 
#include "mbed.h"
 
/** Interface to control a standard DC motor 
* with an H-bridge using a PwmOut and 2 DigitalOuts plus analog input from current sense.
*/
class Motor {
    public:
 
/** Create a motor control interface    
*
* @param pwm A PwmOut pin, driving the H-bridge enable line to control the speed
* @param fwd A DigitalOut, set high when the motor should go forward
* @param rev A DigitalOut, set high when the motor should go backwards
* @param brakeable, set if the motor driver is able to do braking 0 false 1 true. (addition)
* @param ain, analog in conected to current sense pin.
* @param ohms, value of resistor on current sense pin.
* @param limit, maximum current possible, in amps. ie, 1 = 1A, 0.1 = 100mA
8 @param cutby. the amount the system cuts the speed by in the event of a current spike above limit.
*/
        Motor(PinName pwm, PinName fwd, PinName rev, PinName ain, float ohms, float limit, float cutby, int brakeable);
  
/** Set the speed of the motor (addition)
* 
* @param speed The speed of the motor as a normalised value between -1.0 and 1.0
* @return speed applied after limiting due to current.
*/
        float speedcs(float speed);
        
/** Set the the motor to coast
* 
* @param void 
* @returns motor coasts until another instruction is recived
*/        
  
        void coastcs(void);

/** Set the motor to dynamicaly brake (addition)
* 
* @param float duty 0 - 1.0 provides some control over how hard the motor brakes.
* @return duty applied due to current limiting.
*/

        float stopcs(float duty);

/** read the current
*
* @param void 
* @return (analog in * 0.303)/ohms.
*/
        float current(void);
        
    protected:
        //pins
        PwmOut _pwm;
        DigitalOut _fwd;
        DigitalOut _rev;
        AnalogIn _ain;
        //variables
        int Brakeable; // (addition)
        int sign; //prevents throwing the motor from full foward to full reverse and stuff melting.
        float ohms;
        float currentlimit;
        float modifyspeed;
        //functions
};

#endif
