/*Libary for GP2D120
*  
* 
* by Christopher Hasler.
* 
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#ifndef MBED_IRRangeFinder_H
#define MBED_IRRangeFinder_H
#include "mbed.h"
/** class to control an IR range finder
*/
class IRRangeFinder {
    
    public:
    /**  creates a IR range finder interface
    *
    * @param pin An Analog pin, the data line of the sensor is attached to
    * @param type, deafult 1, GP2D120, 2, GP2D12
    */
        IRRangeFinder (PinName pin, int type = 1);
        
        /** returns value for range, greater than; note, scans from max to min. 
        * feel free to invert the order to scan from min to max if required
        */
        int read(void);
        
        /** returns value for float, read from analog in.
        */
        float read_f(void);
        
       /** returns value for voltage
        */
        float read_v(void);
        
        
    protected:
    
        AnalogIn _pin;
        int sensor;
        
};
#endif