/*Libary for GP2D120
*
*
* by Christopher Hasler.
*
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/


#include "mbed.h"
#include "GP2xx.h"
  /* 
  * @param ain analog in from sensor
  */

IRRangeFinder::IRRangeFinder (PinName pin, int type):   _pin(pin) {
    sensor=type;
};
// returns value for range, greater than 4, 5, 6, 7, 8, 10, 12, 14, 20, 25, 30 cm
int IRRangeFinder::read(void) {
    float temp = _pin.read();
    if (sensor==1) { //GP2D120
        if ( temp<0.1212) {
            return 30;
        } else if (temp<0.1515) {
            return 25;
        } else if (temp<0.2121) {
            return 20;
        } else if (temp<0.2727) {
            return 14;
        } else if (temp<0.303) {
            return 12;
        } else if (temp<0.3939) {
            return 10;
        } else if (temp<0.4848) {
            return 8;
        } else if (temp<0.5454) {
            return 7;
        } else if (temp<0.606) {
            return 6;
        } else if (temp<0.6969) {
            return 5;
        } else {
            return 4;
        }
    } else if (sensor == 2) { //GP2D12
        if ( temp<0.136) {
            return 80;
        } else if ( temp<0.145) {
            return 75;
        } else if ( temp<0.15) {
            return 70;
        } else if ( temp<0.17) {
            return 65;
        } else if ( temp<0.18) {
            return 60;
        } else if ( temp<0.19) {
            return 55;
        } else if ( temp<0.21) {
            return 50;
        } else if ( temp<0.23) {
            return 45;
        } else if (temp<0.26) {
            return 40;
        } else if (temp<0.30) {
            return 30;
        } else if (temp<0.34) {
            return 28;
        } else if (temp<0.42) {
            return 20;
        } else if (temp<0.46) {
            return 18;
        } else if (temp<0.50) {
            return 16;
        } else if (temp<0.56) {
            return 14;
        } else if (temp<0.64) {
            return 12;
        } else if (temp<0.74) {
            return 10;
        } else {
            return 9;
        }
    } else
        return -1;
}
//returns value for floating point given by analog in
float IRRangeFinder::read_f(void) {
    return _pin.read();
}

//returns value for voltage, given by (1/3.3)*(read_f)
float IRRangeFinder::read_v(void) {
    float temp = _pin.read();
    temp = temp*0.303;
    return temp;
}













/*
Serial pc(USBTX, USBRX); // tx, rx
AnalogIn IRRF(p18);

int main() {
    pc.printf("Hello World!");
    while (1) {

        pc.printf("%x \n", IRRF.read_u16());
        wait(0.1);

    }
}*/
