#include "mbed.h"

#define numsamples 1
int touchSense1(void);
int touchSense2(void);
int comparestr(int x,int y,char a[],char b[]);
void getstring(void);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
AnalogIn input1(p20);
AnalogIn input2(p15);
DigitalIn charger1(p19);
DigitalIn charger2(p16);
DigitalOut ground1(p18);
DigitalOut ground2(p17);
Serial pc(USBTX, USBRX); // tx, rx

static int j;
static char str[50];

int main() {
    pc.printf("Please input the trigger string (start with S and end with E):\r\n");
    getstring();
    pc.printf("Waiting for human input.\r\n");
    int i=0,k=0;
    char str1[50];
    int match=0;
    while (1) {
        if (pc.readable()) {
            getstring();
        }
        if (touchSense1()) {
            myled1 = 1;
        } else {
            myled1 = 0;
        }
        if (touchSense2()) {
            myled2 = 1;
        } else {
            myled2 = 0;
        }
        switch (i) {
            case 0:
                if (myled1&myled2) {
                    pc.printf("TOUCH ERROR\r\n");
                    i=1;
                }
                if (myled1==1&myled2==0) {
                    pc.printf("1");
                    i=1;
                    str1[k]='1';
                    match=0;
                    k++;
                }
                if (myled2==1&myled1==0) {
                    pc.printf("0");
                    i=1;
                    str1[k]='0';
                    match=0;
                    k++;
                }
            case 1:
                if ((myled1==0)&(myled2==0)) {
                    i=0;
                }
        }
        int x,y;
        x=k-1,y=j;
        if (match==0) {
            match=comparestr(x,y,str,str1);
            if (match==1) pc.printf("\r\nMATCH\r\n");
        }
        wait (0.05);
    }
}

void getstring(void) {
    char a;
    j=0;
X:
    while (1) {
        a=pc.getc();
        pc.printf("%c",a);
        if (a=='S') break;
        else {
            pc.printf("\r\nHOST ERROR,TRY AGAIN\r\n");
            continue;
        }
    }
    while (1) {
        a=pc.getc();
        pc.printf("%c",a);
        if (a=='E') {
            pc.printf("\r\n");
            break;
        } else if (a=='0'|a=='1') {
            str[j]=a;
            j++;
        } else if (a==' ') continue;
        else {
            pc.printf("\r\nHOST ERROR,TRY AGAIN\r\n");
            goto X;
        }
    }
    j=j-1;
}
int touchSense1(void) {
    float sample;
    ground1 = 0;
    charger1.mode(PullUp);
    charger1.mode(PullNone);
    sample=input1.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

int touchSense2(void) {
    float sample;
    ground2 = 0;
    charger2.mode(PullUp);
    charger2.mode(PullNone);
    sample=input2.read();
    if (sample < 0.3) {
        return 1;
    } else {
        return 0;
    }
}

int comparestr(int x,int y,char a[],char b[]) {
    while (y>=0) {
        if (a[y]==b[x]) {
            x--;
            y--;
        } else goto A;
    }
    return 1;
A:
    return 0;
}