#ifndef SDSK_h
#define SDSK_h

#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif
#define DEG2RAD M_PI / 180.0
#define RAD2DEG 180.0 / M_PI

#include <mbed.h>
#include <vector>

class SDSK
{
public:
    SDSK(PinName _pin_step, PinName _pin_dir, uint32_t _steps_per_rev=51200, double _max_acc=360, double _max_vel=180, uint32_t _min_us_step_pulse=4,  bool _positive_is_ccw=true);
    
    double move(double target_angle);
    
    vector<uint64_t> planner(double target_angle);
    void move_planner(vector<uint64_t> step_time, double target_angle);
    void set_dir(double target_angle);
    
    void reverse();
    void zero();
    void set_max_acc(double _max_acc);
    void set_max_vel(double _max_vel);
    
    void take_step(); 
    double position_angle;
     
private:
    DigitalOut step;
    DigitalOut dir;
    bool positive_is_ccw; // changes to -1 if untrue
    
    double max_acc;
    double max_vel;
    
    uint32_t min_us_step_pulse;
    
    uint32_t steps_per_rev;
    double steps_per_angle;
    double angle_per_steps;
    
    bool pos_dir;
    
    Serial pc;
    
    Timer profile_time;
    
};
#endif 
