#ifndef PLATFORM_H    
#define PLATFORM_H


#include "N5110.h"
#include "Rectangle.h"

/** Platform class
@brief class that draws out single platforms
@author Lev Duman
@date May 4 2017
*/


class Platform: public Rectangle
{
    
    public:
        /**Constructor*/
        Platform(int x, int y, int width, int height, FillType fill);
        /**Destructor*/
        ~Platform();
        /**Draws the platform*/
        void draw(N5110 &lcd, int absoluteCoord, bool white);
        /**Getter for Fill type*/
        FillType getFill();
        
    private:
        FillType fill;
    
};
#endif