#include "Platform.h"
#include "N5110.h"

//Serial pc(USBTX, USBRX);
Platform::Platform(int x, int y, int width, int height, FillType fill) //constructor
{
    //Stores values from the arguments into the constructed object fields
    this->x = x;           
    this->y = y;
    this->width = width;
    this->height = height;
    this->fill = fill;
}

Platform::~Platform() // destructor
{

}

///////////////////DRAW - PLATFORM//////////////////////////////////////////////
/**
@details converts platform's absolute coordinates into relative screen coordinates
*and then draws the platform
*/
void Platform::draw(N5110 &lcd,int absoluteCoord, bool white)
{
     if((x-absoluteCoord)<0)
     {  
        if(white)
        {
            lcd.drawRect(0, y, width-absoluteCoord+x, height, FILL_WHITE);  
        }
        else
        {
            lcd.drawRect(0, y, width-absoluteCoord+x, height, fill);
        }
     }
     else
     {
        if(white)
        {
            lcd.drawRect(x-absoluteCoord, y, width, height, FILL_WHITE);     
        }
        else
        {
            lcd.drawRect(x-absoluteCoord, y, width, height, fill);
        }
     }
}

////////////////////GETFILL - PLATFORM//////////////////////////////////////////////
/**
@details getter for fill type of platform
*/
FillType Platform::getFill()
{
    return fill;
}