#ifndef MAP_H    
#define MAP_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Platform.h"
#include "Enemy.h"
#include "Character.h"
#include <deque>

/**Map class
@brief class that handles drawing and clearing of the map
@author Lev Duman
@date May 4 2017
*/
class Map
{
    
public:
    /**Constructor*/
    Map(deque<Platform*>* levelMap, deque<Enemy*>* enemyMap, Character* character);
    /**Destructor*/
    ~Map();
    /**Draws the map*/
    void draw(N5110 &lcd,bool white);
    /**Getter for absolute coordinate*/
    int* getAbsoluteCoord();
    /**Getter for character object*/
    Character* getCharacter();
    /**Getter for Map dequeue*/
    deque<Platform*>* getLevelMap();
    /**Getter for Enemy dequeue*/
    deque<Enemy*>* getEnemyMap();
    /**Function to move enemies*/
    void moveEnemies();
private:
    deque<Platform*>* levelMap;
    deque<Enemy*>* enemyMap;
    Character* character;
    int absoluteCoord;
};
#endif