#ifndef ENEMY_H
#define ENEMY_H 

#include "mbed.h"
#include "N5110.h"
#include "Rectangle.h"
#include "Platform.h"
#include <deque>

/**Enemy class
@brief Class that handless enemy collisionand movement
@author Lev Duman
@date May 4 2017
*/

class Enemy: public Rectangle
{ 
    public:
        /**Constructor*/
        Enemy(int x, int y);
        /**Destructor*/
        ~Enemy();
        /**Draws Enemy*/
        void draw(N5110 &lcd,int absoluteCoord, bool white);
        /**Collision with platform to the east*/
        bool collisionPlatformE(deque<Platform*>* levelMap);
        /**Collision with platform to the west*/
        bool collisionPlatformW(deque<Platform*>* levelMap);
        /**Collision with platform to the south*/
        bool collisionPlatformS(deque<Platform*>* levelMap);
        /**Collision with platform to the north*/
        bool collisionPlatformN(deque<Platform*>* levelMap);
        /**moves enemies*/
        bool movement(int absoluteCoord, deque<Platform*>* levelMap);
        /**fall for enemies*/
        void fall(deque<Platform*>* levelMap);
        /**triger for fall*/
        void noPlatformFall(deque<Platform*>* levelMap);
        bool getSpawned();
        void setSpawned(bool);
         
    private:    
        float force;
        float floatY;
        bool directionW;
        bool spawned;   
};
#endif