#ifndef CHARACTER_H
#define CHARACTER_H 

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Rectangle.h"
#include "Platform.h"
#include <deque>
#include "Enemy.h"

/**Character class
@brief Class that handles character movement and rendering
@author Lev Duman
@date May 4 2017
*/


class Character: public Rectangle
{
    
    public:
        /**Constructor*/
        Character(int x, int y);
        /**Destructor*/
        ~Character();
        /**Draws character*/
        void draw(N5110 &lcd,int absoluteCoord, bool white);
        /**Character movement*/
        void movement(Direction d, int* absoluteCoord, deque<Platform*>* levelMap, deque<Enemy*>* enemyMap);
        /**Character jump*/
        void rise(deque<Platform*>* levelMap);
        /**Character falling*/
        void fall(deque<Platform*>* levelMap);
        /**Character falling without prior jump*/
        void noPlatformFall(deque<Platform*>* levelMap);
        /**Collision with platform to the east*/
        bool collisionPlatformE(deque<Platform*>* levelMap);
        /**Collision with platform to the west*/
        bool collisionPlatformW(deque<Platform*>* levelMap);
        /**Collision with platform to the south*/
        bool collisionPlatformS(deque<Platform*>* levelMap);
        /**Collision with platform to the north*/
        bool collisionPlatformN(deque<Platform*>* levelMap);
        /**Collision with enemy to the east*/
        bool collisionEnemyE(deque<Enemy*>* enemyMap);
        /**Collision with enemy to the west*/
        bool collisionEnemyW(deque<Enemy*>* enemyMap);
        /**returns iterator or -1 depending on if enemy is killed*/
        deque<Enemy*>::iterator collisionEnemyS(deque<Enemy*>* enemyMap);
        /**Collision with enemy from north*/
        bool collisionEnemyN(deque<Enemy*>* enemyMap); 
        /**function that checks for enemy or character death*/
        void characterOrEnemyDeath(deque<Enemy*>* enemyMap);
    private:    
        float force;
        float floatY;
        
};
#endif