#include "mbed.h"
Serial pc(USBTX, USBRX);

struct _task{
    unsigned long long int usec;
    void (*schedFunc)();
};


class PriorityQueue 
{
private:
    struct Node   
    {
        struct Node *Previous;
        _task Data;
        struct Node *Next;
    }Current;
    struct Node *head;  // Pointer to Head
    struct Node *ptr;   
        // Pointer for travelling through Queue
    int NumOfNodes;
        // Keeps track of Number of nodes
public:
    PriorityQueue(void);
    void Insert(_task * myTask);
    _task* Delete();
    void Display(void);
    ~PriorityQueue(void);
};

PriorityQueue::PriorityQueue(void)
{
    Current.Previous=NULL;
    Current.Next=NULL;
    head=&Current;
    ptr=head;
}

void PriorityQueue::Insert(_task * myTask)
{
    struct Node *newnode;
    struct Node *traceback;
    struct Node *backnode; //the node behind traceback

    traceback=ptr;
    newnode=new Node;
    newnode->Data.usec=myTask->usec;
    newnode->Data.schedFunc=myTask->schedFunc;
    if (ptr->Previous==NULL){
        head=newnode;
    }
    while ((newnode->Data.usec<traceback->Data.usec)&&(traceback->Previous!=NULL)){
        traceback=traceback->Previous;
    }
    if (traceback->Previous==NULL){
        head=newnode;
        newnode->Next=traceback;
    }
    
    if (traceback->Next!=NULL){
        backnode=traceback->Next;
        newnode->Next=backnode;
        newnode->Previous=traceback;
        traceback->Next=newnode;
        backnode->Previous=newnode;
    }
    
    if(traceback->Next==NULL)
        {
            newnode->Next=traceback->Next;
            traceback->Next=newnode;
            newnode->Previous=traceback;
        }

    while(ptr->Next!=NULL){                    
        ptr=ptr->Next;
    }    
    NumOfNodes++;
}

_task * PriorityQueue::Delete()
{
    struct Node *mynode;
    ptr=head;    
    mynode=head;
    head=head->Next;
    return &mynode->Data;
}

void PriorityQueue::Display(void)
{
    ptr=head;
    //pc.printf("Priority Queue is as Follows: ");
    while(ptr!=NULL)
    {
        pc.printf ("%lld\r\n",ptr->Data.usec);
        ptr=ptr->Next;
    }
}

PriorityQueue::~PriorityQueue(void)
{
    struct Node *temp;                      /* Temporary variable */
    while(head->Next!=NULL)
    {
        temp=head->Next;
        head=temp;
    }
    if(head->Next==NULL)
        delete head;
}