#include "mbed.h"
#include "queue.h"

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
struct timeval
{
  unsigned long long int tv_sec;     /* Seconds. */
  unsigned long long int tv_usec;    /* Microseconds. */
};
void runAtTime (void (*schedFunc)(), struct timeval *tv);
void schedFunc(void);
void SetupTimer1(struct timeval *tv);
void Timer1_IRQHandler(void);
void setTimeval(struct timeval *tv);
 timeval currentTime;

PriorityQueue myQueue;
_task runTime;
unsigned long long int triggerTime;


int main() {
    _task t1,t2,t3,t4,t5,t6,t7,t8,t9,t10;
    t1.usec=1000;
    triggerTime=t1.usec;
    t2.usec=2000;
    t3.usec=8000;
    t4.usec=4000;
    t5.usec=5000;
    t6.usec=3000;
    t7.usec=9000;
    t8.usec=5000;
    t9.usec=10000;
    //myQueue.Insert(&t1);
    myQueue.Insert(&t2);
    myQueue.Insert(&t3);
    myQueue.Insert(&t4);
    myQueue.Insert(&t5);
    myQueue.Insert(&t6);
    myQueue.Insert(&t7);
    myQueue.Insert(&t8);
    myQueue.Insert(&t9);
    setTimeval(&currentTime);
    SetupTimer1(&currentTime);
    //SetupTimer1();
    while(1){
       pc.printf("%llu\r\n",LPC_TIM1->TC);
       pc.printf("%llu\r\n",LPC_TIM1->IR);
      }
}

void SetupTimer1(struct timeval *tv){
   LPC_SC->PCONP |= 1 << 2;     // Power on Timer`
   LPC_SC->PCLKSEL0 |= 1 << 4;
   LPC_TIM1->TCR = 0x2;         // Reset and set to timer mode
   LPC_TIM1->CTCR = 0x0;
   LPC_TIM1->PR = 0;            // No prescale
     //unsigned long long int Tc=(unsigned long long int )tv->tv_sec*96000000;
     LPC_TIM1->MR0=tv->tv_usec*96000;
     //LPC_TIM1->MR0=0x20000000;
     LPC_TIM1->MR1=0xFFFFFFFF;
     LPC_TIM1->MCR = 0x00000001;           // Interrupt and Reset on Match
     LPC_TIM1->TCR = 1;           // Enable Timer
     //enable interrupt
     NVIC_SetVector (TIMER1_IRQn, (uint32_t)&Timer1_IRQHandler);
     NVIC_EnableIRQ (TIMER1_IRQn);
}

/*void TriggerHandler(void){
    runAtTime (schedFunc,&currentTime);
    LPC_TIM1->IR=63;
}*/

void Timer1_IRQHandler(void)
{
    if((LPC_TIM1->IR|0xFFFFFFFE)==0xFFFFFFFF){//handle timer overflow
    //myled1=!myled1;
    runAtTime (schedFunc,&currentTime);        
    LPC_TIM1->IR = 1<<0;
    }
    
    if((LPC_TIM1->IR|0xFFFFFFFD)==0xFFFFFFFF){//trigger function at specific time
    myled2=!myled2;
    
    LPC_TIM1->IR = 1<<1;
    }

}

void schedFunc(void){
    
     runTime=*myQueue.Delete();
     triggerTime=runTime.usec;
     setTimeval(&currentTime);
     myled1=!myled1;
}
void runAtTime(void (*scheFunc)(),struct timeval *tv){
    (*scheFunc)();
    LPC_TIM1->MR0=tv->tv_usec*96000;
}
void setTimeval(struct timeval *tv){
    
    tv->tv_usec=triggerTime;
}

