 #include "mbed.h"
 #include "pt.h"
 
 #define numsamples 1
 int touchSense1(void);
 int touchSense2(void);
 void readSerial();
 char touchDetect ();

 DigitalOut myled1(LED1);
 DigitalOut myled2(LED2);
 DigitalOut myled3(LED3);
 AnalogIn input1(p20);
 DigitalIn charger1(p19);
 DigitalOut ground1(p18);
 AnalogIn input2(p17);
 DigitalIn charger2(p16);
 DigitalOut ground2(p15);
 
 
 Serial pc(USBTX, USBRX); // tx, rx
 
char *host = new char [100];
char *input = new char [100];
static struct pt serial_pt, match_pt;
static int Thread=0;
static
PT_THREAD(serial(struct pt *pt))                   //Thread to read the host serial
{
  PT_BEGIN(pt);  
  while (1){ 
   PT_WAIT_UNTIL(pt, pc.readable()==1);
    readSerial();
    Thread=0;  
    }    
    PT_END(pt);  
}

static
PT_THREAD(match(struct pt *pt))                    //Thread to do the comparation
{
  PT_BEGIN(pt);  
  while (1){
   PT_WAIT_UNTIL(pt, Thread == 1);
    pc.printf (" MATCH ");
    pc.printf ("\r\n");
    Thread=0;
    }    
     PT_END(pt);
  
}

 int main() {
    PT_INIT(&serial_pt);
    PT_INIT(&match_pt);
    serial(&serial_pt);
 
   while (1){ 
    serial(&serial_pt); 
    match(&match_pt);             
    int j=0, i=1, flag=1;
    while (flag) {                  //Print the host value;
     pc.printf ("%c", host[j]);
     if (host[j]=='E'){
         flag=0; }
         j++;
      } 

     while (1) {
        serial(&serial_pt); 
        match(&match_pt);
        if (host[i]=='E'){
            Thread=1;
            i=1; 
            break;  
        }     
        else if (host[i]==touchDetect()){                              
           i++;
           wait (0.5);
        }   
        else{ 
            pc.printf (" TOUCH ERROR ");
            pc.printf ("\r\n");               
            break;}                         
      }  
    }      
 }
 
 
 void readSerial()                 //Read host serial value
 {
    char b;
    int flag=1,i=0;
    b=pc.getc();
    if (b=='S'){
        host[0]='S';
        i++;
        while (flag){
            host[i]=pc.getc();   
            if (host[i]=='E'){
                flag=0;} 
            else if (host[i]==' '){
            i--;}
            else if (host[i]=='S'){
                pc.printf (" HOST ERROR \r\n ");    
                break;} 
            i++;     
        }           
    }
}
 
char touchDetect ()        //Detect the user input
 {
    while (1) {
    if (touchSense1()){
           pc.printf (" T1 ");      //T1 means sensor1 is touched
           if (touchSense2()){
               return '3';
           }
            while (touchSense1()){
                wait(0.5);}
           return '1';
    }
    else if (touchSense2()){        //T0 means sensor2 is touched
           pc.printf (" T0 ");
           if (touchSense1()){
                return '3';
           }
             while (touchSense2()){
                wait(0.5);}
           return '0';
           
    }    
    wait (0.05); 
    }
  }
  
 int touchSense1(void)
 {
     float sample;
     ground1 = 0;
     charger1.mode(PullUp);
     charger1.mode(PullNone);
     sample=input1.read();
     if (sample < 0.3) {
         return 1;
     } else {
         return 0;
    }
 }

 int touchSense2(void)
 {
     float sample;
     ground2 = 0;
     charger2.mode(PullUp);
     charger2.mode(PullNone);
     sample=input2.read();
     if (sample < 0.3) {
         return 1;
     } else {
         return 0;
    }
 }
 

